{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the base module of the cge core.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


{$ifdef fpc}
  {$macro on}
{$endif}
{$longstrings on}

unit cl_hub;

{$define cge}
{$define cgekernel}

{$ifdef fpc}
  {$IFDEF Win32}
    {$DEFINE extdecl := stdcall}
  {$ELSE}
    {$DEFINE extdecl := cdecl}
    {$LINKLIB c}
  {$ENDIF}
{$endif}
interface
  uses un_typedefs, SysUtils, typinfo
      {$ifdef unix}
       ,x , xlib, xutil, dllfuncs, dl
      {$else}
       ,windows
      {$endif}
       ,classes, cl_preinityells, IniFiles
       {$ifdef fpc}, md5{$endif}
       ,cl_dyna, cl_filelist, cl_strings
       ,cl_splashscreen, cl_module, cl_container;

(* forum quotation:
Hi, I've had a short look at your files (especialy lua.pas).
1. Don't use libC in unix, use baseunix and unix units instead.
2. Don't use {$IFDEF LINUX} but {$IFDEF UNIX} or {$IFNDEF MSWINDOWS} otherwise BSD and other unices won't work
I haven't been able to get it to compile on my FreeBSD yet due to afforementioned problems but I'll try tomorrow and see what I can see Smile
I'll keep you posted.*)

{$ifdef unix}
  {$define MACROS}
  {$ifdef linux}
    {$define Linked_with_xf86vm} //undefine to link without the video mode switching support
  {$endif}
  {$ifdef Linked_with_xf86vm}
    {$LinkLib Xext}
    {$Linklib Xxf86vm}
  {$endif}
{$endif}

{$ifdef CPUI386}
  {$define ASSEMBLER_ALLOWED}
{$endif}


// ---------=========*******   *******========-------

CONST
  CGEString = 'Cheb''s Game Engine';

  BuildNumber = {$ifdef fpc}{$include build.h}{$else}0{$endif};

  {$INCLUDE un_texsages.h}
);

  {$include un_unicode.h}

  {$INCLUDE cl_texsages.h}
  

type
  //float = single;
  EFake = class(Exception);
  EDying = class(Exception);

var
  RunningOneShot: boolean;

  MainIni: TMemIniFile;
  StartDir, WorkingDir, AppNick, ModulesBasePath, SessionPath, SavePath: String;
  DebugMode: boolean = No;
  DeveloperMode: boolean = No;
  AbortHotKey, ConsoleToggleHotkey, ConsoleScrollUpHotkey, ConsoleScrollDownHotkey
     : TIntegerArray;
  ModuleHotKey : array[1..10] of TIntegerArray;
  CgeStartTime, SecondStageInitTime: TDateTime;
  CgeStartingTick: longint;
  DontWriteALog: boolean;

  WarningQueue: TAOW;
  
  TexTokenId: TAOI64;
  TexUnclaimed: TAOB;


  function Tick: longint; //miliseconds since CGE start;

  Procedure Die(YellID :TMessageID; Param: array of const); OVERLOAD;
  Procedure Die(YellID :TMessageID); OVERLOAD;
  Procedure Warning(YellID :TMessageID; Param: array of const); OVERLOAD;
  Procedure Warning(YellID :TMessageID); OVERLOAD;

  function NowDying(): boolean;
  function StopDying(): WideString;
  function ExtractDyingYell(): WideString;

  Procedure ClearWarningQueue;
  Function IsWarningQueueEmpty: boolean;
  Function PullWarningsFromQueue: WideString;

  Procedure Die(AnsiYell: AnsiString); OVERLOAD;

  Procedure PreInitDie(Yell: AnsiString);
  procedure DisplayDyingYells;

  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
//  function PervertedFormat(A: WideStringArray; P: array of const): WideString; OVERLOAD;
  function StrOrUndefined(U: WideString): WideString;

  Procedure AddLog(S: AnsiString); OVERLOAD;
  Procedure VerboseLog(S: AnsiString); OVERLOAD;
  Procedure AddLog(U: WideString); OVERLOAD;
  Procedure AddLog(mID: TMessageID); OVERLOAD;
  Procedure AddLog(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure VerboseLog(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure VerboseLogOk;
  Procedure AddLog(U: WideString; Param: array of const); OVERLOAD;
  Procedure AddLog(mID: TMessageID; Param: array of const); OVERLOAD;
  procedure VerboseLog(mID: TMessageID; Param: array of const); OVERLOAD;
  procedure VerboseLog(mID: TMessageID); OVERLOAD;
  Procedure AddLogComment(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure AddLogComment(U: WideString; Param: array of const); OVERLOAD;
  Procedure AddLogComment(mID: TMessageID; Param: array of const); OVERLOAD;
  Procedure AddLogComment(S: AnsiString); OVERLOAD;
  Procedure AddLogComment(U: WideString); OVERLOAD;
  Procedure AddLogComment(mID: TMessageID); OVERLOAD;
  
  Procedure DbgSay(Yell: AnsiString);
  
  Procedure ExportHostProc(i: integer; var p: pointer); stdcall;

  function RunningInWindows9x: boolean;
  function RunningInWindowsNT: boolean;
  function OsID: string;
  procedure LogOSVersion;
  
  procedure GetHotKeysFromConfig;
  procedure LoadSharedResources;
  procedure InitCTimer;
  
  function RuEn(Ru, En: string): string;
  function VersionToStr(major, minor, build: integer): AnsiString;
  function CGEPath(s: string): string;

 {$include cl_conflimits.h}

 {$include cl_confman.h}

 //function ToldMemRgn(ptr: pointer): WideString;
  function ToldException(E: Exception): WideString;

 {$include un_gl.h}  //*****  OpenGL headers

 {$include cl_winman.h}

 {$include cl_window.h}

  procedure InitOpenGL(GLLibName: string);
  procedure CloseOpenGL;
  function Load_WGL_EXT_swap_control: Boolean;
  procedure GetOpenGLVersion(var hi, med: integer);

 
 {$define header}
   {$ifdef notlaz}
     {$define e_fun_1 := function }
     {$define e_fun_2 := }
     {$define e_pro_1 := procedure }
     {$define e_pro_2 := }
     {$define e_cm := }

     {$include un_exported_func.h}
   {$else}
     {$define cgekernel}
     {$include cl_eh_delphi.inc}
   {$endif}
   
 {$undef header}


var
  MCInitialized: boolean = No; //is message container initialized yet?..

implementation
  uses cl_libpng, cl_piccodec, cl_console, cl_file_io;


  function Tick: longint;
  begin
    //{$ifdef Win32}
    // Result:=GetTickCount() - CgeStartingTick;
    //{$else}

     // Rough. Rounds to 15..16 ms.
     Result:=round((Now() - CgeStartTime) * 86400000.0);
    //{$endif}
  end;

var
  Dying: boolean = No;
  TimeStamp: Int64 = 0;

  function PCharToString(P: PAnsiChar): AnsiString;
  var
    i: integer;
    p2: PAnsiChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i);
    end;
  end;

  function PWideCharToWideString(P: PWideChar): WideString;
  var
    i: integer;
    p2: PWideChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i*2);
    end;
  end;

  {$include cl_exported_func.inc}

  Procedure PreInitDie(Yell: AnsiString);
  //all error messages given before MessageContainer is initialized
  // are in English, so there's no need for unicode...
  begin
   {$ifdef win32}
    MessageBox(0, PChar(Yell), PChar(CGEString + ' crashed at startup!'), MB_ICONERROR + MB_OK);
   {$else}
    WriteLn(#10#13#10#13#10#13 + ExtractFileName(CGEString + ' crashed at startup!'));
    Writeln(#10#13 + Yell + #10#13);
    Writeln('Press Enter to close.');
    ReadLn;
   {$endif}
    Halt(1);
  end;

 {$ifdef win32}
   function MessageBoxA(w1:longint;l1,l2:pointer;w2:longint):longint; stdcall; external 'user32' name 'MessageBoxA'; 
   function MessageBoxW(w1:longint;l1,l2:pointer;w2:longint):longint; stdcall; external 'user32' name 'MessageBoxW';   
 {$endif}  
  
  function ExtractDyingYell(): WideString;
  var i: integer;
  begin
    Result:='';
    For i:=WarningQueue.High downto 0 do begin
      Result:=Result + WarningQueue[i];
      if i > 0 then Result:=Result + #10#13#10#13;
    end;
    ClearWarningQueue;
  end;

  procedure DisplayDyingYells;
  var
    tit, DyingYell: WideString;
    titA: AnsiString;
  begin
    DyingYell:=ExtractDyingYell();
    AddLog(MI_ERROR_MESSAGE_IS, [DyingYell]);
    {$ifdef win32}
     tit:=MessageContainer[MI_CGE_TITLE] + #0;
     titA:=WideToAnsi(tit);
     MessageBeep($FFFFFFFF);
     if RunningInWindows9x
       //Windows 9x may not have Unicode support installed,
       // so we convert the text ourselves and call the ANSI function,
       // while assuming that the locale is Russian (1251).
       then MessageBoxA(0, PChar(WideToAnsi(DyingYell)), @(titA[1]), MB_ICONERROR + MB_OK)
       else begin
         DyingYell:=DyingYell + #0;
         MessageBoxW(0, @(DyingYell[1]), @(tit[1]), MB_ICONERROR + MB_OK);
       end;
    {$else}
     WriteLn(#10#13#10#13#10#13 + ExtractFileName(ParamStr(0) + ' crashed!'));
     Writeln(#10#13 + WideToAnsi(DyingYell) + #10#13);
     Writeln('Press Enter to close.');
     ReadLn;
    {$endif}
  end;

  function RunningInWindows9x: boolean;
  begin
   {$ifdef win32}
    Result := (Win32Platform = VER_PLATFORM_WIN32_WINDOWS) {and
      (Win32MajorVersion < 5)} {and (WIN32MinorVersion <= 1)}
   {$else}
    Result:=No;
   {$endif}
  end;
  
  function RunningInWindowsNT: boolean;
  begin
   {$ifdef win32}
    Result := (Win32Platform =  VER_PLATFORM_WIN32_NT)
   {$else}
    Result:=No;
   {$endif}
  end;

  function OsID: string;
  begin
   {$ifdef win32}
    if RunningInWindows9x then begin
      case Win32MajorVersion of
        4: case WIN32MinorVersion of
             0: Result:='Windows 95';
             90: Result:='Windows Millennium';
           else
             Result:='Windows 98';
           end;
      else
        Result:='Windows';
      end;
    end
    else begin
      case Win32MajorVersion of
        5: case WIN32MinorVersion of
             0: Result:='Windows 2000';
             2: Result:='Windows Server 2003';
           else
             Result:='Windows XP';
           end;
       // 6: Result:='Windows Vista';
      else
        Result:='Windows';
      end;
    end;
    if Result = 'Windows' then begin
      Result:=Result + ' ';
      if RunningInWindowsNT then Result:=Result + 'NT';
      Result:=Result + IntToStr(Win32MajorVersion) + '.' + IntToStr(WIN32MinorVersion);
    end;
   {$else}
     {$ifdef linux}
       Result:='Linux';
     {$else}
       Result:= '???';
     {$endif}
   {$endif}
  end;
  
  procedure LogOsVersion;
  begin
    AddLog(MI_OS_VERSION, [OsId()]);
  end;


  Procedure DbgSay(Yell: AnsiString);
  begin
   {$ifdef win32}
    MessageBox(0, PChar(Yell), PChar(''), MB_ICONINFORMATION + MB_OK);
   {$else}
    Writeln(#10#13 + Yell);
    Writeln('Press Enter.');
    ReadLn;
   {$endif}
  end;

 {$include un_unicode.inc}

  function LoadUnicodeText(FileName: string): TAOW;
  var
    f: file;
    h: WideChar;
    u: WideString;
  begin
    if not FileExists(FileName) then
      if MCInitialized
        then Die(MI_ERROR_FILE_NOT_FOUND, [FileName])
        else PreInitDie('File "' + Filename + '" does not exist.');
    Try
      Assign(f, FileName);
      Reset(f, 2);
      BlockRead(f, h, 1);
      if ord(h) <> $FEFF then PreInitDie('"' + Filename + PIYTxtNotUtf16);
      Result:=TAOW.Create;
      u:='';
      While not eof(f) do begin
        BlockRead(f, h, 1);
        if (ord(h) > 32) or ((Length(u) > 0) and (ord(h) >= 32)) then u:=u + h;//w + h; //ignore spaces in the beginning
        if ord(h) = 13 then begin
          Result.Add(u);
          u:='';
        end;
      end;
      if u<>'' then Result.Add(u) else u:='';
      Close(f);
    Except
      if MCInitialized
        then Die(MI_ERROR_INVALID_UNICODE_TEXT,[FileName])
        else PreInitDie('"' + Filename + PIYTxtReadFailed);
    End;
  end;

  {$include cl_texsages.inc}

  function VarRecToWide(V: TVarRec): WideString;
  begin
    Case V.Vtype of
      vtInteger:    Result := IntToStr(V.VInteger);
      vtBoolean:    Result := AnsiToWide(BoolChars(V.VBoolean));
      vtChar:   Result := AnsiToWide(V.VChar);
      vtWideChar:   Result:=V.VWideChar;
      vtExtended:   Result := FloatToStr(V.VExtended^);
      vtAnsiString: Result := AnsiString(V.VAnsiString);
      vtWideString: Result := WideString(V.VWideString);
      vtPChar:  Result := AnsiToWide(PCharToString(V.VPChar));
      vtPWideChar:  Result := PWideCharToWideString(V.VPWideChar);
//      vtPChar:      Result := AnsiToWide(PCharToString(V.VPChar));
      vtObject:     Result := V.VObject.ClassName;
      vtClass:      Result := V.VClass.ClassName;
      vtPointer: begin
        if Assigned(V.VPointer) then Result:= Format('%Ph',[V.VPointer])
                                else Result:='NIL';
      end;
     {
      //not supported in the FreePascal 1.0.6
      vtCurrency:   Result := CurrToStr(V.VCurrency^);
      vtVariant:    Result := string(V.VVariant^);
      }
      vtInt64:      Result := IntToStr(V.VInt64^);
    else
      Result:='?unknown VarRec type?';
    end;
  end;

{  procedure PervertedFormat(A: WideStringArray; P: array of const);
  var u: WideString;
  begin
    u:=ArrayToUni(A);
    a.Free;
    PervertedFormat(u, p);
    A:=UniToArray(u);
    u.Free;
  end;}

  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
  var
    j: integer;
    b, e: WideString;
  begin
    e:='';
    For j:=0 to High(p) do begin
      b:=VarRecToWide(P[j]);
      if WidePos('%' + IntToStr(j), U) < 1
        then e:=e + '  [' + b + ']  '
        else u:=WideReplace(u, '%' + IntToStr(j), b);
    end;
    if e <> '' then begin
      e:=' +FORMAT ERROR!! ' + e;
    end;
    Result:=u + e;
  end;
  
  function StrOrUndefined(U: WideString): WideString;
  begin
    if U='' then Result:=MessageContainer[MI_UNDEFINED]
            else Result:=U;
  end;

 {$ifdef win32}
  function Win32LastError: WideString;
  var
    M: Cardinal;
    u: WideString;
  begin
    M:=GetLastError;
    if M = ERROR_SUCCESS then Result:=''
    else begin
      if RunningInWindows9x
        then u:=AnsiToWide(SysErrorMessage(M))
        else u:=SysErrorMessage(M);
      Result:=#10#13 + Result + #10#13 + PervertedFormat(
        MessageContainer[MI_WIN32_EXPLAINS],
        [IntToHex(M, 8), u]);
    end;
  end;
 {$endif}

    function ExceptObjectisException: boolean;
    begin
      Try
        Result:=ExceptObject is Exception;
      Except
        Result:=No;
      End;
    end;

  procedure CheckForGenericDyingYells(var U: WideString);
  begin
    Try
      if not Dying
        and {$ifdef fpc}Assigned(ExceptObject){$else}(ExceptObject() <> nil){$endif}
        and ExceptObjectisException
        and not (ExceptObject is EFake)
      then begin
        U:=U + #10#13#10#13 + ToldException(ExceptObject as Exception);
      {$ifdef win32}
        //..  
        //   WinAPI GetLastEror (  Win32LastEror)
        U:= U + Win32LastError;
      {$endif}
      end;
      {$ifdef win32}
        SetLastError(0);
      {$endif}
    Except
      U:=U + #10#13'!Crashed accessing Exception object!';
    End;
  end;

  Procedure Die(YellID :TMessageID; Param: array of const);
  var
    U: WideString;
    Ey: AnsiString;
  begin
    U:=PervertedFormat(MessageContainer[YellID], Param);
    CheckForGenericDyingYells(U);
    if not Dying then begin
      AddLog(MI_SHIT_HAPPENS_SEE_BELOW, []);
      Dying:=Yes;
    end;
    Ey:=WideToAnsi(U);
    WarningQueue.Add(U);
    raise EDying.Create(Ey);
  end;
  
  Procedure Die(AnsiYell: AnsiString);
  var
    U: WideString;
  begin
    U:=AnsiToWide(AnsiYell);
    if not Dying then begin
      AddLog(MI_SHIT_HAPPENS_SEE_BELOW, []);
      Dying:=Yes;
      {$ifdef win32}
        //..  
        //   WinAPI GetLastEror (  Win32LastEror)
        U:= U + Win32LastError;
        SetLastError(0);
      {$endif}
    end;
    WarningQueue.Add(U);
    raise EDying.Create(AnsiYell);
  end;

  Procedure Die(YellID :TMessageID);
  begin
    Die(YellId, []);
  end;
  
  Procedure Warning(YellID :TMessageID; Param: array of const); OVERLOAD;
  var
    U: WideString;
  begin
    U:=PervertedFormat(MessageContainer[YellID], Param);
    WarningQueue.Add(U);
  end;
  
  Procedure Warning(YellID :TMessageID); OVERLOAD;
  begin
    Warning(YellID, []);
  end;

  function NowDying(): boolean;
  begin
    Result:=Dying;
  end;

  function StopDying(): WideString;
  begin
    if not Dying and (ExceptObject <> nil) and (ExceptObject is Exception)
      then Result:= ToldException(ExceptObject as Exception)
      else Result:=ExtractDyingYell();
    Dying:=No;
  end;

  Procedure ClearWarningQueue;
  begin
    WarningQueue.Length:=0;
  end;

  Function IsWarningQueueEmpty: boolean;
  begin
    Result:=(WarningQueue.Length = 0);
  end;

  Function PullWarningsFromQueue: WideString;
  var
    i: integer;
    r: WideString;
  begin
    r:='';
    For i:=WarningQueue.High downto 0 do begin
      r:=r + WarningQueue[i];
      if i > 0 then r:=r + #10#13#10#13;
    end;
    ClearWarningQueue;
    Result:=r;
  end;


//  function PervertedFormat(U: WideString; P: array of const): WideString;

//  function PervertedFormat(A: WideStringArray; P: array of const): WideString;

{  var
    w, w2: WideString;
    j: integer;
  begin
    Result:=TAOW.Create;
    w:=PervertedFormatStr(S, P);
    j:=1;
    Repeat
      w2:=Strparm(w, j, #13);
      if w2 <> '' then Result.Add(w2);
    until w2='';
    For j:=0 to Result.High - 1 do Result[j]:=Result[j] + #13;
  end;
 }
  Procedure AddLog(S: Ansistring; Param: array of const);
  begin
    AddLog(AnsiToWide(S), Param);
  end;

  procedure WriteLogToFile(u: WideString; EraseLF: boolean);
  var
    h: WideChar;
    f: file;
  begin
    if u = '' then Exit;
    AssignFile(f, WorkingDir + 'LOG');
    if not fileexists(WorkingDir + 'LOG')
      then begin
        Rewrite(f, Sizeof(WideChar));
        h:=#$FEFF;//unicode utf-16 text signature
        BlockWrite(f, h, 1);
      end
      else begin
        Reset(f, Sizeof(WideChar));
        if EraseLF then Seek(f, FileSize(f) - 2)
                   else Seek(f, FileSize(f) - 1)
      end;
    BlockWrite(f, u[1], Length(u));
    CloseFile(F);
  end;

  Procedure AddLog(U: WideString; Param: array of const);
  begin
    U:= PervertedFormat(U, Param) + #10#13;
   {$ifdef unix}
    WriteLn(WideToAnsi(U));
   {$endif}
   
    if Assigned(Console) then Console.Add(WideToAnsi(U));

    if DontWriteALog then Exit; //a special case. We don't want to ruin
                                //the log of an already running instance.
    
    WriteLogToFile(u, No);
  end;

  Procedure AddLogComment(U: WideString; Param: array of const);
  begin
    U:= PervertedFormat(U, Param) + #10#13;
    if Assigned(Console) then
      if Console.Count > 0
        then Console[Console.Count - 1]
          := Copy(Console[Console.Count - 1], 1, Length(Console[Console.Count - 1]) - 2) + WideToAnsi(U)
        else Console.Add(WideToAnsi(U));
    if DontWriteALog then Exit; //a special case. We don't want to ruin
                                //the log of an already running instance.
    WriteLogToFile(u, Yes);
  end;

  Procedure AddLog(mID: TMessageID; Param: array of const);
  begin
    AddLog(MessageContainer[mID], Param);
  end;

  Procedure AddLog(mID: TMessageID);
  begin
    AddLog(MessageContainer[mID], []);
  end;

  Procedure AddLogComment(S: AnsiString; Param: array of const);
  begin
    AddLogComment(AnsiToWide(S), Param);
  end;

  Procedure AddLogComment(mID: TMessageID; Param: array of const);
  begin
    AddLogComment(MessageContainer[mID], Param);
  end;

  Procedure AddLogComment(S: AnsiString);
  begin
    AddLogComment(S,[]);
  end;

  Procedure AddLogComment(U: WideString);
  begin
    AddLogComment(U,[]);
  end;


  Procedure AddLogComment(mID: TMessageID);
  begin
    AddLogComment(mID,[]);
  end;


  Procedure AddLogOK;
  begin
    AddLogComment(MessageContainer[MI_LOG_SUCCESS]);
  end;

  Procedure AddLog(S: AnsiString);
  begin
    AddLog(S, []);
  end;

  Procedure AddLog(U: WideString);
  begin
    AddLog(U, []);
  end;

  procedure VerboseLog(mID: TMessageID; Param: array of const);
  begin
    if DebugMode then AddLog(mID, param);
  end;
  
  Procedure VerboseLogOk;
  begin
    if DebugMode then AddLogOk;
  end;

  procedure VerboseLog(mID: TMessageID);
  begin
    if DebugMode then AddLog(mID, []);
  end;


  Procedure VerboseLog(S: AnsiString; Param: array of const);
  begin
    if DebugMode then AddLog(S, Param);
  end;

  Procedure VerboseLog(S: AnsiString);
  begin
    if DebugMode then AddLog(S, []);
  end;
  
  procedure GetHotKeyFromConfig(par: string; var HK: TIntegerArray);
  var
    str: string;
    i: integer;
  begin
    Try
      str:=Config.Str['main', par];
      i:=1;
      While StrParm(str, i, [',']) <> '' do begin
        System.SetLength(HK, i);
        HK[i - 1]:=StrToInt(StrParm(str, i, [',']));
        inc(i);
      end;
    Except
      Die(MI_INVALID_HOST_HOTKEY_RECORD, ['main', par, str]);
    End;
  end;

  procedure GetHotKeysFromConfig;
  var
    i: integer;
  begin
    GetHotKeyFromConfig('Abort_Hotkey', AbortHotKey);
    GetHotKeyFromConfig('Console_Toggle_Hotkey', ConsoleToggleHotkey);
    GetHotKeyFromConfig('Console_Scroll_Up_Hotkey', ConsoleScrollUpHotkey);
    GetHotKeyFromConfig('Console_Scroll_Down_Hotkey', ConsoleScrollDownHotkey);
    For i:=1 to 10 do
      GetHotKeyFromConfig('Module_'+IntToStr(i) + '_Hotkey', ModuleHotKey[i]);
  end;
  
  procedure LoadSharedResources;
  var
    stub: integer;
  begin
    VerboseLog('Loading shared resources...');
{    CreateContainerFromFile('$font_0.png', 'core/data/fonts/sysfont/chebstyle_0.png', stub);
    CreateContainerFromFile('$font_0_b.png', 'core/data/fonts/sysfont/chebstyle_0_bold.png', stub);
    CreateContainerFromFile('$font_1.png', 'core/data/fonts/sysfont/chebstyle_1.png', stub);
    CreateContainerFromFile('$font_1_b.png', 'core/data/fonts/sysfont/chebstyle_1_bold.png', stub);
    CreateContainerFromFile('$font_2.png', 'core/data/fonts/sysfont/chebstyle_2.png', stub);
    CreateContainerFromFile('$font_2_b.png', 'core/data/fonts/sysfont/chebstyle_2_bold.png', stub);
    CreateContainerFromFile('$font_3.png', 'core/data/fonts/sysfont/chebstyle_3.png', stub);
    CreateContainerFromFile('$font_3_b.png', 'core/data/fonts/sysfont/chebstyle_3_bold.png', stub);
    CreateContainerFromFile('$font_4.png', 'core/data/fonts/sysfont/chebstyle_4.png', stub);
    CreateContainerFromFile('$font_4_b.png', 'core/data/fonts/sysfont/chebstyle_4_bold.png', stub);
    CreateContainerFromFile('$font_5.png', 'core/data/fonts/sysfont/chebstyle_5.png', stub);
    CreateContainerFromFile('$font_5_b.png', 'core/data/fonts/sysfont/chebstyle_5_bold.png', stub);
}
    CreateContainerFromFile('$console.png', PChar(ModulesBasePath + 'cge/texture/console.png'), stub);
    CreateContainerFromFile('$bsod.png', PChar(ModulesBasePath + 'cge/texture/bsod.png'), stub);
    CreateContainerFromFile('$defaultfont.png', PChar(ModulesBasePath + 'cge/texture/font/default_2.png'), stub);
    CreateContainerFromFile('$fpsmeter.png', PChar(ModulesBasePath + 'cge/texture/fpsmeter.png'), stub);
    CreateContainerFromFile('$shit_happens.png', PChar(ModulesBasePath + 'cge/texture/shit_happens.png'), stub);
//    CreateContainerFromFile('$', 'core/data/', stub);
    VerboseLogOk;
  end;
  
  function CGEPath(s: string): string;
  begin
    Result:=s;
    if  (Result = '') or ({$ifdef win32} ExtractFileDrive(Result) = ''{$else} Result[1] <> '/'{$endif})
    then Result:=WorkingDir + Result;
    Result:=OptiPath(StrReplace(Result, '{$PLATFORM}', SystemSuffix)) + ExtractFileName(Result);
  end;
  
  function RuEn(Ru, En: string): string;
  begin
    if UpperCase(MessageContainer.Language) = 'RUSSIAN'
      then Result:=Ru
      else Result:=En;
  end;

  function VersionToStr(major, minor, build: integer): AnsiString;
  begin
    Result:=format('%d.%.2d.%.4d' ,[Major, minor, build]);
  end;



  {$include cl_confman.inc}

  {$include cl_winman.inc}
  
  {$include cl_window.inc}

  {$include cl_talesteller.inc}
  
  {$include un_gl.inc}

  {$include cl_gl_init.inc}

  

initialization
  NewSessionID;
  TexTokenId:=TAOI64.Create;
  TexUnclaimed:=TAOB.Create;
finalization
  CloseOpenGL;
end.

