{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains basic OpenGL initialization routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


var
  LibGL: {$IFDEF Win32} THandle {$ELSE} Pointer {$ENDIF} ;


function GetGLProcAddress(ProcName: PChar): Pointer;
begin
{$IFDEF Win32}
   Result:=GetProcAddress(LibGL, ProcName);
{$ELSE}
   Result:=dlsym(LibGL, ProcName);
{$ENDIF}
end;


function GetGLEXTProcAddress(ProcName: PChar): Pointer;
begin
{$IFDEF Win32}
   Result:=wglGetProcAddress(ProcName);
{$ELSE}
   Result:=dlsym(LibGL, ProcName);
{$ENDIF}
end;


Procedure CloseOpenGL;
begin
  ClearProcAddresses;
 {$IFDEF Win32}
  If LibGL <> 0 then FreeLibrary(LibGl);
 {$ELSE}
  If Assigned(LibGL) then dlClose(LibGl);
 {$ENDIF}
end;

Procedure InitOpenGL(GLLibName: string);
begin
 //Disable FPU exceptions (it will ignore divisions by zero and such)
 {$ifdef win32}
  Set8087CW($133F);
  LibGL:=0;
 {$else}
  LibGL:=nil;
 {$endif}

 {$IFDEF Win32}
  LibGL:=LoadLibrary(PChar(GLLibName));
  if LibGL = 0 then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLLibName]);
    {$else}raise Exception.Create('OpenGl library ' + GLLibName + ' not found!');{$endif}
 {$ELSE}
  LibGL := dlopen(PChar(GLLibName), RTLD_NOW);
  If not Assigned(LibGL) then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLLibName]);
    {$else}raise Exception.Create('OpenGl library ' + GLLibName + ' not found!');{$endif}
 {$ENDIF}
  InitProcAddresses;
end;


