{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the functions exported from the engine core
      to the module DLL.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$include cl_cfile_func.inc}

{$include cl_ctimer_func.inc}


  function GetIsRussian(): boolean;stdcall;
  begin
    Result:=UpperCase(MessageContainer.Language) = 'RUSSIAN';
  end;

  function _exp_NowDying(): boolean;stdcall;
  begin
    Result:=NowDying();
  end;
  
    var _std2e: WideString;
  function _exp_StopDying(): PWideChar; stdcall;
  begin
    _std2e:=StopDying();
    Result:=@_std2e[1];
  end;

  procedure CgeSwapBuffers(); stdcall;
  begin
    TheWindow.SwapBuffers;
  end;
  
  function FrameBufferHasAlphaComponent (): boolean; stdcall;
  begin
    Result:=TheWindow.HasAlpha;
  end;
  
  function GetCurrentSessionID(): int64; stdcall;
  begin
    Result:=TimeStamp;
  end;
  
  var
    PrevTimeStamp: int64 = 0;
    
  function GetTimeStamp: int64;
  begin
    asm
      pushf
      push edx
      push eax
      rdtsc
    {$ifdef fpc}
      mov [Result], eax
      mov [Result + 4], edx
    {$else}
      //Delphi dumb, Delphi dumb, Delphi dumb, dumb, dumb!
      mov [cardinal(Result)], eax
      mov [cardinal(Result) + 4], edx
    {$endif}
      pop eax
      pop edx
      popf
    end;
    if Result <= PrevTimeStamp then begin
      ctDualProcessorDetected:=True;
      Result:=PrevTimeStamp + Random(1000);
    end;
    PrevTimeStamp:=Result;
  end;

  procedure NewSessionID(); stdcall;
  begin
    TimeStamp:=GetTimeStamp();
  End;

 procedure _SetConfigInt (section, id: PAnsiChar; Value: integer); stdcall;
 begin
   Config[section, id]:=value;
 end;
 
 function _GetConfigInt (section, id: PAnsiChar): integer; stdcall;
 begin
   Result:=Config[section, id];
 end;
 
 function _GetConfigIntCh (section, id: PAnsiChar; min, max:integer): integer; stdcall;
 begin
   Result:=Config.IntChk[section, id, min, max];
 end;


  Procedure HostDieW(txt: PWideChar); stdcall;
  begin
    Die(PWideCharToWideString(txt));
  end;
  Procedure HostLogW(txt: PWideChar); stdcall;
  begin
    AddLog(PWideCharToWideString(txt));
  end;
  
  Procedure DbgSayA (Yell: PAnsiChar); stdcall;
  begin
    DbgSay(PCharToString(Yell));
  end;

  function GetModNum: integer; stdcall;
  begin
    Result:=1;
  end;

  function GetModName(num: integer): PAnsiChar; stdcall;
  begin
    Result:=nil;
  end;

  procedure ValidateTypesets(i, n: integer); stdcall;
  begin
    Case n of
      0: if i <> ord (MI_CORE_MIDs_END) then Die(MI_ERROR_TYPESETS_MISMATCH,['TMessageId']);
      1: if i <> ord (Re_Stub) then Die(MI_ERROR_TYPESETS_MISMATCH,['TCbMessage']);
    else
      Die(MI_ERROR_TYPESETS_MISMATCH,['ValidateTypesets()']);
    end;
  end;
  
  procedure RequestExit; stdcall;
  begin
    TheWindow.ExitRequested:=Yes;
  end;

  var
    CurrentCodec: TImageCodec;
    CurrentStream: TContainer;
    CurrentFile, CurrentDirPack: AnsiString;

    function GetContainerObject (Name: AnsiString): TContainer;
    var
      i: integer;
    begin
      i:=Containers.IndexOf(Name);
      if i < 0 then Result:=nil
      else Result:=Containers.Objects[i] as TContainer;
    end;

  procedure PrepareToDecodePic (ContainerName: PAnsiChar; var width, height: integer; var mode: TImageMode); stdcall;
  var
    ext, cn, FileName: AnsiString;
    ConNa: AnsiString;
  begin
    cn:='';
    ConNa:=PCharToStr(ContainerName);
    Try
      if Assigned(CurrentCodec) then CurrentCodec.Free;
      CurrentStream:=GetContainerObject(ConNa);
      FileName:=(CurrentStream as TContainer).FileName;
      ext:=UpperCase(ExtractFileExt(FileName));
      if ext='.PNG' then CurrentCodec:=TPngCodec.Create else
{      if ext='.TGA' then CurrentCodec:=TTgaCodec.Create else
      if ext='.BMP' then CurrentCodec:=TBmpCodec.Create else
      if ext='.PCX' then CurrentCodec:=TPcxCodec.Create else
      if ext='.LBM' then CurrentCodec:=TPcxCodec.Create else     }
          Die(MessageContainer[MI_CGE_TITLE] + ' v.' + IntToStr(VersionMajor) + '.' + IntToStr(VersionMinor)
               + RuEn('     "', ' doesn''t support image file format "')
               + ext + '"!');
      cn:=CurrentCodec.ClassName;
      CurrentCodec.PrepareToDecode(CurrentStream, width, height, mode);
      CurrentFile:=FileName;
      CurrentDirPack:=ConNa;
    Except
      CurrentStream.Free;
      CurrentStream:=nil;
      Die(MI_CRASHED_DECODING_PIC, [StrOrUndefined(FileName), StrOrUndefined(ConNa), StrOrUndefined(cn)]);
    End;
  end;
  
  
  procedure DecodePic (OutBuff: Pointer); stdcall; //Output buffer
                                    // must be allocated by the caller!
  var
    cn: string;
  begin
    cn:='';
    Try
      cn:=CurrentCodec.ClassName;
      CurrentCodec.Decode(OutBuff);
      //CurrentStream.Free;
      CurrentStream:=nil;
      CurrentCodec.Free;
      CurrentCodec:=nil;
      CurrentFile:='';
    Except
      Die(MI_CRASHED_DECODING_PIC, [StrOrUndefined(CurrentFile),
              StrOrUndefined(CurrentDirPack), StrOrUndefined(cn)]);
    End;
  end;

  procedure EncodePic(FileName: PAnsiChar; Image: pointer; width, height: integer; mode: TImageMode);  stdcall;
  var
    ext, cn: AnsiString;
    C: TImageCodec;
    S: TContainer;
    FS: TCGEStream;
    FN: AnsiString;
  begin
    FN:=PCharToStr(FileName);
    FN:=OptiPath(FN) + ExtractFileName(FN);
    cn:='';
    Try
      ext:=UpperCase(ExtractFileExt(FN));
      if ext='.PNG' then C:=TPngCodec.Create
        else Die(RuEn('    "', 'Writing images in the "')
                 + ext
                 + RuEn('"  !', '" format isn''t supported!'));
      cn:=C.ClassName;
      S:=TContainer.Create(0);
      C.Encode(S, Image, width, height, mode);
      C.Free;
      FS:=TCGEStream.CreateForWrite(FN);
      S.WriteToStream(FS);
      FS.Free;
      S.Free;
    Except
      Die(MI_CRASHED_ENCODING_PIC, [FN, StrOrUndefined(cn)]);
    End;
  end;

  procedure ValidateVersion (m, n, b: integer); stdcall;
  begin
    if (m > VersionMajor) or (n > VersionMinor) then
      DIE(MI_VERSIONS_MISMATCH, [VersionToStr(m, n, b), VersionToStr(VersionMajor, VersionMinor, BuildNumber)]);
  end;

    var _bd2e: WideString;
  function GetBaseDir(): PWideChar; stdcall;
  begin
    _bd2e:=StartDir;
    Result:=PWideChar(_bd2e);
  end;

  function CreateContainer(Name: PAnsiChar; Size: integer): pointer; stdcall;
  var
    i: integer;
    C: TContainer;
    n: Ansistring;
  begin
    n:=PCharToStr(Name);
    i:=Containers.IndexOf(n);
    if i < 0
      then C:=TContainer.Create(size)
      else begin
        C:=Containers.Objects[i] as TContainer;
        C.Size:=Size;
      end;
    Result:=C.MemoryPtr;
    if i < 0
      then Containers.AddObject(n, C);
  end;
  
  function GetContainer (Name: PAnsiChar): pointer; stdcall;
  var
    i: integer;
    n: Ansistring;
  begin
    n:=PCharToStr(Name);
    i:=Containers.IndexOf(n);
    if i < 0 then Result:=nil
    else Result:=(Containers.Objects[i] as TContainer).MemoryPtr;
  end;
  
  function GetContainerSize (name: PAnsiChar): integer;   stdcall;
  var
    i: integer;
    n: Ansistring;
  begin
    n:=PCharToStr(Name);
    i:=Containers.IndexOf(n);
    if i < 0 then Result:=0
    else Result:=(Containers.Objects[i] as TContainer).Size;
  end;
  
  procedure DeleteContainer (Name: PAnsiChar); stdcall;
  var
    i: integer;
    n: Ansistring;
  begin
    n:=PCharToStr(Name);
    i:=Containers.IndexOf(n);
    if i < 0 then Exit;
    Containers.Objects[i].Free;
    Containers.Delete(i);
  end;
  
  procedure StoreContainerToFile (Name, FileName: PAnsiChar); stdcall;
  var
    F: TCGEStream;
    N, FN: AnsiString;
    p:pointer;
  begin
    N:=PCharToStr(name);
    FN:=PCharToStr(filename);
    p:=GetContainer(name);
    if not Assigned(p) then Die (MI_ERROR_ATTEMPT_TO_STORE_NONEXISTENT_CONTAINER,
      [N, FN]);
    F:=TCGEStream.CreateForWrite(FN);
    F.Write(p^, GetContainerSize(Name));
    F.Free;
  end;
  

  function CreateContainerFromFile (Name, FileName: PAnsiChar; var Size: integer): pointer; stdcall;
  var
    i: integer;
    C: TContainer;
    N, FN: AnsiString;
    FS: TCGEStream;
  begin
    N:=PCharToStr(name);
    FN:=PCharToStr(filename);
    FS:=TCGEStream.CreateForRead(FN);
    i:=Containers.IndexOf(N);
    if i < 0
      then begin
        C:=TContainer.Create(0);//(ModuleManager.ActiveModule.Num)
        C.FileName:=FN;
        C.LoadFromStream(FS, 0);
      end
      else begin
        C:=Containers.Objects[i] as TContainer;
        C.Clear;
        C.FileName:=FN;
        C.LoadFromStream(FS, 0);
      end;
    FS.Free;
    Result:=C.MemoryPtr;
    Size:=C.Size;
    if i < 0
      then Containers.AddObject(N, C);
  end;
  
  function InFullScreenMode: boolean; stdcall;
  begin
    Result:=TheWindow.InFullScreenMode;
  end;
  procedure SwitchToWindowedMode; stdcall;
  begin
    TheWindow.SwitchToWindowedMode;
  end;
  function SwitchToFullscreenMode(width, height, hertz: integer): boolean; stdcall;
  begin
    Result:=TheWindow.SwitchToFullscreenMode(width, height, hertz);
  end;
  function DisplayWidth: integer; stdcall;
  begin
    Result:=TheWindow.DisplayWidth;
  end;
  function DisplayHeight: integer; stdcall;
  begin
    Result:=TheWindow.DisplayHeight;
  end;


    var _Mi2e: WideString;
  function HostMsg (M: TMessageId): PWideChar; stdcall;
  begin
    _Mi2e:=MessageContainer[M];
    Result:=@_Mi2e[1];
  end;
  
  procedure SwitchToModule(n: integer); stdcall;
  begin
   //
  end;
  
  function GetIsInDeveloperMode(): boolean; stdcall;
  begin
    Result:=DeveloperMode;
  end;

  function GetIsLogVerbose(): boolean; stdcall;
  begin
    Result:=DebugMode;
  end;
  
  function _exp_Tick(): integer; stdcall;
  begin
    result:=Tick();
  end;


// *********************  TEXTURE MANAGEMENT ************************

  function CgeGenTexture (var texture: glUint): int64; stdcall;
  begin
    glGenTextures(1, @texture);
    Assert(texture < 1000000, 'Unexpected OpenGL behavior: texture name is too high!');
    if TexTokenId.High < texture then begin
      TexTokenId.Length:= texture - 1;
      TexUnclaimed.Length:= texture - 1;
    end;
    Result:=GetTimeStamp;
    TexTokenId[texture]:=Result;
  end;
  
  procedure CgeDeleteTexture (texture: glUint; token: int64); stdcall;
  var
    i: integer;
  begin
    if (texture > 0) and (TexTokenId.High >= texture) and (TexTokenId[texture] = token)
    then begin
      TexUnclaimed[texture]:=No;
      TexTokenId[texture]:=0;
      glDeleteTextures(1, @texture);
    end;
  end;
  
  function UpdateTextureToken (texture: glUint): int64; stdcall;
  begin
    Result:=GetTimeStamp;
    TexTokenId[texture]:=Result;
  end;

  procedure UnclaimTexture (texture: glUint; token: int64); stdcall;
  var
    i: integer;
  begin
    if (texture > 0) and (TexTokenId.High >= texture) and (TexTokenId[texture] = token)
      then TexUnclaimed[texture]:=Yes;
  end;
  
  function ClaimTexture (texture: glUint; token: int64): longbool; stdcall;
  var
    i: integer;
  begin
    if (texture = 0) or (TexTokenId.High < texture)
      then {$ifdef fpc}Exit(No);{$else}begin Result:=No; Exit end;{$endif}
                                      //Dumb Delphi.

    if (TexTokenId[texture] = token) then begin
      TexUnclaimed[texture]:=No;
      Result:=Yes;
    end
    else
      Result:=No;
  end;

  procedure ClearUnclaimedTexturesList (); stdcall;
  var
    i: integer;
  begin
    For i:=1 to TexUnclaimed.High do TexUnclaimed[i]:=No;
  end;
  
  procedure DeleteUnclaimedTextures (); stdcall;
  var
    i: glUint;
  begin
    if TexUnclaimed.Length > 0 then
      For i:=1 to TexUnclaimed.High do
        if TexUnclaimed[i] then begin
          if TexTokenId[i] > 0 then glDeleteTextures(1, @i);
          TexUnclaimed[i]:=No;
          TexTokenId[i]:=0;
        end;
  end;
  
//*******************************************************************
  
  //These include implementation of
  //  procedure CgeBuildAlphaMipmaps(Width, Height: integer; Data: pointer); stdcall;
  {$ifdef ASSEMBLER_ALLOWED}
    {$include cle_alphamip_asm.inc}
  {$else}
    {$include cle_alphamip.inc}
  {$endif}
  
{$ifdef notlaz}
 //e_fun_1 is "", e_fun2 is "" and e_cm is ":p:=@"
   {$define e_fun_1 := }
   {$define e_fun_2 := }
   {$define e_pro_1 := }
   {$define e_pro_2 := }
   {$define e_cm := :p:=@ }

  procedure ExportHostProc(i: integer; var p: pointer); stdcall;
  begin
    case i of
      {$include un_exported_func.h}
    else
      Die(MI_ERROR_TYPESETS_MISMATCH,[
        RuEn('   (      '
             , 'exported functions list (there is no entry #')
        + IntToStr(i) + ')']);
    end;
  end;
 {$else}
   {$include cl_ee_delphi.inc}
 {$endif}


//******************************************************************  
