{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains configuration manager class header.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

 type
   TConfigManager = class
   protected
     Ini: TAoIni;
     overlist: TAoS;
     _filename: string;
     wherefound: integer;
     function AttachIni(FileName: string): boolean;
     function _Find(s, i: string): string;
     function _FindWritePos(s, i: string): integer;
     function _ReadStr(s, i: string): string;
     function _ReadPath(s, i: string): string;
     function _ReadBool(s, i: string): boolean;
     function _ReadInt(s, i: string;  min, max: integer): integer; OVERLOAD;
     function _ReadInt(s, i: string): integer; OVERLOAD;
     function _ReadIntChk(s, i: string; min,max: integer): integer;
     procedure _WriteStr(s,i,d: string);
     procedure _WriteInt(s,i: string; v:integer);
     procedure _WriteIntChk(s,i: string; min, max, v:integer);
     procedure _WriteBool(s,i: string; b: boolean);
     procedure _WritePath(s,i,d: string);
     procedure ScreamLimitsRead(fnum: integer; s,i: string; val, min, max: integer);
     //procedure ScreamLimitsWrite;
   public
     SilentCorrectionsOnWrite,
     StrictLimitsCheck: boolean;
     Constructor Create(name: string);
     Destructor Destroy; OVERRIDE;
     Procedure Reload;
     procedure AttachOverrides;
     Property Int[sect, id: string]: integer read _ReadInt write _WriteInt; DEFAULT;
     Property IntChk[sect, id: string; min, max: integer]: integer read _ReadIntChk write _WriteIntChk;
     Property Bool[sect, id: string]: boolean read _ReadBool write _WriteBool;
     Property Str[sect, id: string]: string read _ReadStr write _WriteStr;
     Property Path[sect, id: string]: string read _ReadPath write _WritePath;
     property mainininame: string read _filename;
   end;

 var
   Config: TConfigManager;

