{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains source of the test module #012.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
unit _test012_main;
 
interface
 
 uses
  SysUtils,
  un_typedefs,
  mo_hub,
  mo_classes;

  procedure T11_OnGetFocus;
  procedure T11_OnLoseFocus;
  procedure T11_OnIdle;
  procedure T11_OnCreate;
  procedure T11_OnPress(scancode: integer);
  procedure T11_OnRelease(scancode: integer);
  procedure T11_OnMouseMove(x, y: integer);
  
Type
  TBigBin = array[1..100] of integer;
  { TTest12Data }


  TTest12Data = class (TTrulyPersistent)
  public
    _666: integer;
    mx, my, r, g, b, ar, ag ,ab, aa, s, dx, dy: glFloat;
    m: TImageMode;
    Oopaloopa: Int64;
    w,h, t: integer;
    p: pointer;
    texture: glUint;
    previous, next, last: TTest12Data;
//    BigBin: TBigBin;
    constructor FirstCreate(prv: TTest12Data); virtual;
    procedure RegisterFields; override;
    procedure AfterLoading; override;
//    procedure InitTexture;
    procedure Render;
    procedure OnIdle;
    destructor Destroy; override;
  end;

Var
  Test12Data: TTest12Data;
  SlotNum: integer = 0;

implementation


  Const
    PrefDist = 5.0;
    PrefSize = 64.0;
    Speed = 1.0;
    Quantity = 50;
    AddPerFrame = 1;
    ColorWaveSpeed = 2;
  

   Procedure QuickSave;
   var
      t: integer;
      gamename: AnsiString;
   begin
     gamename:= 'modules/_test012/save/slot'+IntToStr(SlotNum)+'.cge';
t:=tick();
     SaveGame(Test12Data, MI_OF_GAME, 's', gamename);
if VerboseLog then AddLog('Saving to file took %0 ms.',[Tick()-t]);
   end;

   Procedure QuickLoad;
   var
     stub, t, n: integer;
     version: AnsiChar;
     gamename: AnsiString;
   begin
     gamename:= 'modules/_test012/save/slot'+IntToStr(SlotNum)+'.cge';
     If not FileExists(BaseDir + gamename)
       then AddLog(RuEn(' %0 !'
                       ,'Slot %0 is empty!'), [SlotNum])
     else begin
       Test12Data.Free;
       Test12Data:= LoadGame(MI_OF_GAME, gamename, 'TTest12Data') as TTest12Data;
     end;
   end;

{ TTest12Data }

 constructor TTest12Data.FirstCreate(prv: TTest12Data);
 begin
   _666:=666;
   ar:=1;
   ag:=1;
   ab:=1;
   aa:=0.75;
   s:=PrefSize;
   mx:=DisplayWidth/2;
   my:=DisplayHeight/2;
   r:=0.15;
   g:=0.25;
   b:=0.5;
   previous:=prv;
   //InitTexture();
 end;

procedure TTest12Data.RegisterFields;
begin
    RegType(TypeInfo(TImageMode));
    RegType('TBigBin', TypeInfo(integer), SizeOf(TBigBin));
//    RegType(TypeInfo(glUint), SizeOf(glUint), nil);
//    RegType(TypeInfo(glFloat), SizeOf(glFloat), nil);
    RegField('_666', @_666, TypeInfo(integer));
    RegField('mx', @mx, TypeInfo(glFloat));
    RegField('my', @my, TypeInfo(glFloat));
    RegField('r', @r, TypeInfo(glFloat));
    RegField('g', @g, TypeInfo(glFloat));
    RegField('b', @b, TypeInfo(glFloat));
    RegField('ar', @ar, TypeInfo(glFloat));
    RegField('ag', @ag, TypeInfo(glFloat));
    RegField('ab', @ab, TypeInfo(glFloat));
    RegField('aa', @aa, TypeInfo(glFloat));
    RegField('s', @s, TypeInfo(glFloat));
    RegField('dx', @dx, TypeInfo(glFloat));
    RegField('dy', @dy, TypeInfo(glFloat));
    RegField('m', @m, TypeInfo(TImageMode));
    RegField('oopaloopa', @Oopaloopa, TypeInfo(Int64));
    RegField('w', @w, TypeInfo(integer));
    RegField('h', @h, TypeInfo(integer));
    RegField('t', @t, TypeInfo(integer));
    RegSkip('p', @p, TypeInfo(pointer));
    RegSkip('texture', @texture, TypeInfo(glUint));
    RegField('previous', @previous, TypeInfo(TTest12data));
    RegField('next', @next, TypeInfo(TTest12data));
    RegField('last', @last, TypeInfo(TTest12data));
//    RegField('BigBin', @BigBin, TypeInfo(TBigBin));
end;

{  procedure TTest12Data.InitTexture;
  var
    mode: glUint;
    t:  integer;
  begin
    inherited;
      if Assigned(previous) then Exit;

      if texture = 0 then begin
        texture:=CgeHasTexture('Moya tekstura');
        if texture = 0 then begin
          texture:=CGEGenTexture('Moya tekstura');
          if VerboseLog then AddLog('Texture is alreadty loaded. Created as %0.', [texture]);
          p:=GetContainer('Konteiner s teksturoi');
          if VerboseLog then AddLog('Decoding texture image from container at %0 ...',[p]);
          t:=Tick();
          PrepareToDecodePic ('Konteiner s teksturoi', w, h, m);
          GetMem(p, w * h * ImgModeBpp[m]);
          DecodePic(p);
          if VerboseLog then AddLog('Decoding took %0 ms.', [Tick() - t]);
          if VerboseLog then AddLog('Deleting the container, freeing %0 Kbytes of memory'
            , [GetContainerSize('Konteiner s teksturoi') div 1024]);
          DeleteContainer('Konteiner s teksturoi');
          texture:=CgeGenTexture('Moya tekstura');

          glBindTexture(GL_TEXTURE_2D, texture);
          if m = Im_RGBA then mode:=GL_RGBA else mode:=GL_RGB;
          t:=tick();
          gluBuild2DMipMaps(GL_TEXTURE_2D, mode , w, h, mode, GL_UNSIGNED_BYTE, p);
          if VerboseLog then AddLog('Texture image loaded. gluBuild2DMipMaps() call took %0 ms.',[Tick()-t]);
          FreeMem(p);
        end;
      end
      else AddLog('Texture is alreadty loaded. Its name is %0.', [texture]);
  end;}

  procedure TTest12Data.AfterLoading;
  begin
    //if Assigned(previous) then Exit;
    //InitTexture;
  end;

  procedure TTest12Data.Render;
  begin

{    glBegin(GL_QUADS);//GL_TRIANGLES);
      glNormal3f( 0.0, 0.0, 1.0);
}      glColor4f(ar, ag, ab , aa);
     glVertex2f(mx, DisplayHeight() - my);  //top left
{      glTexCoord2f(0, 0);
      glVertex2f(mx - s/2, DisplayHeight() - my + s/2);  //top left
      glTexCoord2f(1, 0);
      glVertex2f(mx + s/2, DisplayHeight() - my + s/2);
      glTexCoord2f(1, 1);
      glVertex2f(mx + s/2, DisplayHeight() - my - s/2);
      glTexCoord2f(0, 1);
      glVertex2f(mx - s/2, DisplayHeight() - my - s/2);
    glEnd;
}    if Assigned(previous) then previous.Render();
  end;

procedure TTest12Data.OnIdle;
var
  distance,
  force: float;
  dmx, dmy: float;
begin
  if Assigned(next) then begin
    next.OnIdle();
    distance:=sqrt(sqr(previous.mx - mx) + sqr(previous.my - my));
    if distance < 1 then distance:=1;
    force:= - speed * 0.01 * sqr(PrefDist)/sqr(Distance);
    if force < -5 then force:=-5;
//    force:=aa * force;
    dmx:= (previous.mx - mx) / distance;
    dmy:= (previous.my - my) / distance;
    mx += force * dmx;
    my += force * dmy;
  end;
  if Assigned(previous) then begin
    ag:=previous.ag;
    ab:=previous.ab;
    ar:=previous.ar;
    aa:=previous.aa;
    distance:=sqrt(sqr(previous.mx - mx) + sqr(previous.my - my));
    if distance < 1 then distance:=1;
    dmx:= (previous.mx - mx) / distance;
    dmy:= (previous.my - my) / distance;
    if distance > PrefDist
      then begin
        force:= speed * 0.1 * (distance - PrefDist);
        if ag < 0.5 then force:= -force;
      end
      else force:= - speed * 0.1 * PrefDist/Distance;
    if force > 50 then force:=50;
    if force < -5 then force:= -5;
 //   force:=aa * force;
    mx += force * dmx + dx;
    my += force * dmy + dy;
    
    
    
    
    if mx < -1000 then mx:= -1000;
    if mx > DisplayWidth + 1000 then mx:=DisplayWidth + 1000;
    if my < -1000 then my:= -1000;
    if my > DisplayHeight + 1000 then my:= DisplayHeight + 1000;
    
    dx += Speed * 0.01 * (random() - 0.5);
    dx *= 0.98;
    dy += Speed * 0.01 * (random() - 0.5);
    dy *= 0.98;
   // s += Speed * 0.01 * (PrefSize * (PrefDist/distance) - s);
  end;
  
  distance:=sqrt(sqr(Test12data.mx - mx) + sqr(Test12data.my - my));
  if distance < 1 then distance:=1;
  dmx:= (Test12data.mx - mx) / distance;
  dmy:= (Test12data.my - my) / distance;
  force:=0;
  if ar < 0.5 then force -= speed * 1 * PrefDist / Distance;
  if ab < 0.5 then force += 0.1;
  if force > 5 then force:=5;
  if force < -5 then force:= -5;
//  force:=aa * force;
  mx += force * dmx;
  my += force * dmy;
  
end;

destructor TTest12Data.Destroy;
begin
  if Assigned(next) then next.Free;
  inherited;
end;


    procedure T11_OnGetFocus;
    begin
{     With Test12Data do begin
      r:=0.15;
      g:=0.25;
      b:=0.5;
     end; }
    end;

    procedure T11_OnLoseFocus;
    begin
  {   With Test12Data do begin
      r:=1;
      g:=0;
      b:=0;
     end;}
    end;

    procedure T11_OnMouseMove(x, y: integer);
    begin
//SaveGame; LoadGame;
     With Test12Data do begin
      //s:=5;
      mx:=x;
      my:=y;
     end;
    end;

    procedure ChooseSlot(i: integer);
    begin
      AddLog(RuEn('  %0.','Active slot is now %0.'), [i]);
      SlotNum:=i;
    end;


 var ooo: integer = 0;

    procedure T11_OnPress(scancode: integer);
    begin
     With Test12Data do begin
      case Scancode of
        KEY_WHEEL_UP: aa:=aa + 0.1;
        KEY_WHEEL_DOWN: aa:=aa - 0.1;
        KEY_LEFT_BUTTON: if ar > 0.5 then ar:=0 else ar:=1;
        KEY_RIGHT_BUTTON: if ag > 0.5 then ag:=0 else ag:=1;
        KEY_MIDDLE_BUTTON: if ab > 0.5 then ab:=0 else ab:=1;
        KEY_ESCAPE: RequestExit;
        KEY_ENTER: if InFullScreenMode() then SwitchToWindowedMode
                                         else SwitchToFullscreenMode(800, 600, 0);
        KEY_SPACE: begin
          Test12Data.Free;
          Test12Data:=TTest12Data.FirstCreate(nil);
          Test12Data.next:=TTest12Data.FirstCreate(Test12Data);
          Test12Data.Last:=Test12Data.next;
          AddLog(RuEn('   .','The rope has been re-started.'));
          Exit;
//          raise Exception.Create('Crash test!')
//          AddLogA('****** %0', [ooo]);
//          inc(ooo);
        end;
        KEY_F6: QuickSave;
        Key_F9: QuickLoad;
        Key_0: ChooseSlot(0);
        Key_1..Key_9: ChooseSlot(1 + Scancode - Key_1);
      else
        g:=g + 0.11;
      end;
     end;
    end;

    procedure T11_OnRelease(scancode: integer);
    begin
     With Test12Data do begin
      if not (scancode in [KEY_WHEEL_DOWN, KEY_WHEEL_UP, KEY_MIDDLE_BUTTON,
        KEY_RIGHT_BUTTON, KEY_LEFT_BUTTON, KEY_ESCAPE, KEY_ENTER, Key_f6, key_f9])
      then g:=g - 0.11;
     end;
    end;

    procedure T11_OnCreate;
    var
      i: integer;
      n: TTest12data;
    begin
     // if Assigned(Test12Data) then exit;
     InitProcAddresses;
     If FileExists(BaseDir + 'modules/_test012/save/autosave.cge')
      then Test12Data:= LoadGame(MI_OF_GAME, 'modules/_test012/save/autosave.cge', 'TTest12Data') as TTest12Data
      else begin
        Test12Data:=TTest12Data.FirstCreate(nil);
        n:=Test12Data;
        For i:=1 to Quantity do begin
          n.next:=TTest12Data.FirstCreate(n);
          n.mx:=n.mx + (Random() - 0.5) * 1000;
          n.my:=n.my + (Random() - 0.5) * 1000;
          n:=n.next;
        end;
        Test12Data.Last:=n;
        AddLog(RuEn(' :   ,'#10#13'     .'
                   ,'First run: the auto-save slot is empty,'#10#13'  rope created from the scratch.'));
      end;
    end;

   var ti: longint;

    procedure T11_OnIdle;
    var i: integer;
    begin

     With Test12Data do begin
      if aa > 1 then aa:=1;
      if aa < 0 then aa:=0;
      //s:=s + 0.01 * (64 - s);
      //if s > 128 then s:=128;
      
      r+=(random() - 0.5)*0.007;
      if r > 0.4 then r:=0.4;
      if r < 0 then r:=0;

      g+=(random() - 0.5)*0.007;
      if g > 0.4 then g:=0.4;
      if g < 0 then g:=0;

      b+=(random() - 0.5)*0.007;
      if b > 0.4 then b:=0.4;
      if b < 0 then b:=0;


      glEnable(GL_ALPHA_TEST);
      //glDisable(GL_BLEND);
      glEnable(GL_BLEND);
      glAlphaFunc(GL_GREATER, 0);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      glDisable(GL_CULL_FACE);
      glDisable(GL_DEPTH_TEST);
      glViewport(0, 0, DisplayWidth(), DisplayHeight());
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      glOrtho(0, DisplayWidth(), 0, DisplayHeight(), 0 ,1);
      glClearColor(r, g, b, 0);
      glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
      glDisable(GL_TEXTURE_2D);
      glBegin(GL_QUADS);
        glNormal3f( 0.0, 0.0, 1.0);
        glColor3f(r, g, b);
        glVertex2f(0, 0);
        glVertex2f(0, DisplayHeight());
        glVertex2f(DisplayWidth(), DisplayHeight());
        glVertex2f(DisplayWidth(), 0);
      glEnd;
      {glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D, texture);
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtered
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtered
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      }
     end;

     glEnable(GL_POINT_SMOOTH);
     glPointSize(3);
     glBegin(GL_POINTS);

     
     try
       Test12Data.Last.Render(); //transparency isue
     except
       Die('Render crashed');
     end;
     glEnd;

     try
      // AddLog('%0 %1', [Test12Data.mx, Test12Data.my]);
      // AddLog('%0', [assigned(Test12Data.next)]);
       For i:=1 to ColorWaveSpeed do
         Test12Data.next.OnIdle();
     except
       Die('Phys. crashed');
     end;


     For i:=1 to AddPerFrame do begin
       Test12Data.Last.next:=TTest12Data.FirstCreate(Test12Data.Last);
       Test12Data.Last:=Test12Data.Last.next;
       Test12Data.Last.mx += (Random() - 0.5) * 1000;
       Test12Data.Last.my += (Random() - 0.5) * 1000;
     end;

     {$ifdef unix}
       //delay(15);
     {$else}
       //Sleep(15);
     {$endif}
    end;
begin
  pointer(Test12data):=nil;
end.
