{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains source of the test module #011.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$ifdef fpc}
  {$unitpath ../../cge/src}
  {$includepath ../../cge/src} //note: it seems this shit doesn't work
                                 // (at least, partially).
                                 // The command-line switch -Fi is still needed.


  {$memory 10000, 10000}   //Both values have no meaning.
  // First one - because the DLLs use the host apps's stack,
  // Second one - because heap can grow dynamically.
{$endif}

{$include mo_globaldefs.h}

{$stackframes off}  

library _test012;

uses
  SysUtils,
  un_typedefs,
  mo_hub,
  mo_classes,
  typinfo, 
  _test012_main;

  procedure Initialize(SelfName, SessionPath, SavePath: PChar); export; stdcall;
  var t, stub: integer;
  begin
    GrandInitialize(0,0,0); //Here we go...

    AddLog(MI_VERSION_INFO,['TEST #12', '0.01.????', CompileDate, CompileTime, CompilerVersion, CompileTarget]);

    RegClass(TTest12Data);

    {if VerboseLog then AddLog('Loading Texture file into memory...');
    T:=Tick();
    if not Assigned(GetContainer('Konteiner s teksturoi')) then begin
      CreateContainerFromFile('Konteiner s teksturoi'
                  , '', 'modules/_test012/tekstura.png', stub);
      if VerboseLog then AddLog('  ..took %0 ms.', [Tick() - T])
    end
    else
      if VerboseLog then AddLog('  ..No need to. It''s loaded already.', []);
    }
    ClearProcAddresses; //OpenGL;
  end;

var
  FirstRun: boolean = Yes;

  function HandleMessage (msg: TCbMessage; p0, p1, p2: integer): boolean; export; stdcall;
  var
    s1, s2: string;
    version: AnsiChar;
  begin
    Try
      Result:=Yes;
      //raise exception.create('Boo!');
      if FirstRun then begin
        ClearProcAddresses; //OpenGL;
        InitProcAddresses;//OpenGL;
        if CgeFileExists('modules/_test012/save/autosave.cge') then begin
          ClearProcAddresses; //OpenGL;
          InitProcAddresses;//OpenGL;
          Test12Data:= LoadGame(MI_OF_GAME, 'modules/_test012/save/autosave.cge', 'TTest12Data') as TTest12Data;
          T11_OnGetFocus;
        end
        else T11_OnCreate;
        FirstRun:=No;
      end;
      Case msg of
        Re_OnGetFocus:begin
          T11_OnGetFocus;
        end;
        Re_OnLoseFocus: begin
          T11_OnLoseFocus;
        end;
        Re_OnMouseMove: T11_OnMouseMove(p0, p1);
        Re_OnCycle: T11_OnIdle;
        Re_OnPress: T11_OnPress(p0);
        Re_OnRelease: T11_OnRelease(p0);
        Re_OnUnload: begin
          SaveGame(Test12Data, MI_OF_GAME, '0', 'modules/_test012/save/autosave.cge');
          T11_OnLoseFocus;
        end;
        Re_OnDestroy:
          SaveGame(Test12Data, MI_OF_GAME, 's', 'modules/_test012/save/autosave.cge');
        Re_OnLoad: begin
        end;

      else
        Result:=No;
      end;
//Function GetTypeData(TypeInfo : PTypeInfo) : PTypeData;
//Function GetEnumName(TypeInfo : PTypeInfo;Value : Integer) : string;
    Except
      s1:=(ExceptObject as Exception).ClassName;
      s2:=(ExceptObject as Exception).Message;
      Die(MI_CRASHED_IN, [GetEnumName(TypeInfo(TCbMessage), Ord(msg)) + '  message handler'
      ,s1, s2]);
    End;
  end;

  procedure SetGetAddressCallbackProc(Addr: pointer); export; stdcall;
  begin
    RegisterProc:= Addr;
  end;
  
exports
  Initialize name 'cgemoduleinit',
  HandleMessage name 'sendmsg',
  SetGetAddressCallbackProc name 'setcallback';
begin

end.
