{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the definitions of exported CGE functions.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{   ,  ,     
     (   - )  
              .
        ,     
       ...
     -       
       (  String  PChar).
      -   ... =:(

 **********************************************************************}
{
    This header is used by both the core and the modules.
     The core definition style:
       function A (): integer;
       , so macro e_fun_1 is "function", e_fun_2 is "", and e_cm is "".
     The module definition style:
       var A: function (): integer;
       , so macro e_fun_1 is "", e_fun_2 is ":function", and e_cm is "".
     The core exporting proc definition style:
       3: p:=@A;
       , so macro e_fun_1 is "", e_fun2 is "" and e_cm is ":p:=@"
     The module importing proc definition style:
       RegisterProc(3, @A);
       , so macro e_fun_1 is "RegisterProc(", e_fun2 is ")" and e_cm is ",@"

 **********************************************************************}

e_pro_1 {$ifndef header} 05 e_cm {$endif}AddLogOK  e_pro_2 {$ifdef header}(); stdcall{$endif};
  
e_fun_1 {$ifndef header} 07 e_cm {$endif}GetModNum e_fun_2 {$ifdef header}(): integer; stdcall{$endif};
e_fun_1 {$ifndef header} 08 e_cm {$endif}GetModName e_fun_2 {$ifdef header}(num: integer): PAnsiChar; stdcall{$endif};

e_fun_1 {$ifndef header} 10 e_cm {$endif}GetGLProcAddress e_fun_2 {$ifdef header}(ProcName: PAnsiChar): Pointer; stdcall{$endif};

e_fun_1 {$ifndef header} 12 e_cm {$endif}GetGLEXTProcAddress e_fun_2 {$ifdef header}(ProcName: PAnsiChar): Pointer; stdcall{$endif};
e_pro_1 {$ifndef header} 13 e_cm {$endif}ValidateTypesets e_pro_2{$ifdef header}(i, n: integer); stdcall{$endif};
e_pro_1 {$ifndef header} 14 e_cm {$endif}RequestExit e_pro_2{$ifdef header}(); stdcall{$endif};

e_pro_1 {$ifndef header} 16 e_cm {$endif}DecodePic e_pro_2{$ifdef header}(OutBuff: Pointer); stdcall{$endif}; //Output buffer must be allocated by the caller!
e_pro_1 {$ifndef header} 17 e_cm {$endif}EncodePic e_pro_2{$ifdef header}(FileName: PAnsiChar; Image: pointer; width, height: integer; mode: TImageMode); stdcall{$endif};
e_pro_1 {$ifndef header} 18 e_cm {$endif}ValidateVersion e_pro_2{$ifdef header}(m, n, b: integer); stdcall{$endif};
e_fun_1 {$ifndef header} 19 e_cm {$endif}GetBaseDir e_fun_2{$ifdef header}(): PWideChar; stdcall{$endif};
e_fun_1 {$ifndef header} 20 e_cm {$endif}CreateContainer e_fun_2{$ifdef header}(Name: PAnsiChar; Size: integer): pointer; stdcall{$endif};
e_fun_1 {$ifndef header} 21 e_cm {$endif}GetContainer e_fun_2{$ifdef header}(Name: PAnsiChar): pointer; stdcall{$endif};
e_fun_1 {$ifndef header} 22 e_cm {$endif}GetContainerSize e_fun_2{$ifdef header}(Name: PAnsiChar): integer; stdcall{$endif};
e_pro_1 {$ifndef header} 23 e_cm {$endif}DeleteContainer e_pro_2{$ifdef header}(Name: PAnsiChar); stdcall{$endif};
e_pro_1 {$ifndef header} 24 e_cm {$endif}StoreContainerToFile e_pro_2 {$ifdef header} (Name, FileName: PAnsiChar); stdcall{$endif};
e_fun_1 {$ifndef header} 25 e_cm {$endif}CreateContainerFromFile e_fun_2 {$ifdef header}(Name, FileName: PAnsiChar; var Size: integer): pointer; stdcall{$endif};
e_fun_1 {$ifndef header} 26 e_cm {$endif}InFullScreenMode e_fun_2 {$ifdef header}(): boolean; stdcall{$endif};
e_pro_1 {$ifndef header} 27 e_cm {$endif}SwitchToWindowedMode e_pro_2{$ifdef header}(); stdcall{$endif};
e_fun_1 {$ifndef header} 28 e_cm {$endif}SwitchToFullscreenMode e_fun_2 {$ifdef header}(width, height, hertz: integer): boolean; stdcall{$endif};
e_fun_1 {$ifndef header} 29 e_cm {$endif}DisplayWidth e_fun_2 {$ifdef header}(): integer; stdcall{$endif};
e_fun_1 {$ifndef header} 30 e_cm {$endif}DisplayHeight e_fun_2 {$ifdef header}(): integer; stdcall{$endif};
e_pro_1 {$ifndef header} 31 e_cm {$endif}CgeSwapBuffers e_pro_2{$ifdef header}(); stdcall{$endif};
e_fun_1 {$ifndef header} 35 e_cm {$endif}
{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}
e_fun_2 {$ifdef header}(): longint; stdcall{$endif};
e_pro_1 {$ifndef header} 36 e_cm {$endif}PrepareToDecodePic e_pro_2 {$ifdef header}(ContainerName: PAnsiChar; var width, height: integer; var mode: TImageMode); stdcall{$endif};
e_pro_1 {$ifndef header} 37 e_cm {$endif}CgeBuildAlphaMipmaps e_pro_2 {$ifdef header}(Width, Height: integer; Data: pointer); stdcall{$endif};

e_fun_1 {$ifndef header} 39 e_cm {$endif}
{$ifdef cgekernel}_exp_NowDying{$else}NowDying{$endif}
e_fun_2 {$ifdef header}(): boolean; stdcall{$endif};
e_fun_1 {$ifndef header} 40 e_cm {$endif}
{$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif}
e_fun_2 {$ifdef header}(): PWideChar; stdcall{$endif};


e_pro_1 {$ifndef header} 43 e_cm {$endif}DbgSayA e_pro_2 {$ifdef header}(Yell: PAnsiChar); stdcall{$endif};
e_pro_1 {$ifndef header} 44 e_cm {$endif}HostDieW e_pro_2 {$ifdef header}(txt: PWideChar); stdcall{$endif};
e_pro_1 {$ifndef header} 45 e_cm {$endif}HostLogW e_pro_2 {$ifdef header}(txt: PWideChar); stdcall{$endif};
e_fun_1 {$ifndef header} 46 e_cm {$endif}HostMsg  e_fun_2 {$ifdef header}(M: TMessageId): PWideChar; stdcall{$endif};
e_fun_1 {$ifndef header} 47 e_cm {$endif}GetIsInDeveloperMode e_fun_2  {$ifdef header}(): boolean; stdcall{$endif};
e_fun_1 {$ifndef header} 48 e_cm {$endif}GetIsLogVerbose  e_fun_2 {$ifdef header}(): boolean; stdcall{$endif};

e_pro_1 {$ifndef header} 49 e_cm {$endif}OpenCGEFileForWrite e_pro_2 {$ifdef header}(TargetName: PAnsiChar; version: AnsiChar); stdcall{$endif};
e_pro_1 {$ifndef header} 50 e_cm {$endif}OpenCGEFileForRead e_pro_2 {$ifdef header}(SourceName: PAnsiChar; var version: AnsiChar); stdcall{$endif};
e_fun_1 {$ifndef header} 51 e_cm {$endif}ReadFromCGEFile e_fun_2 {$ifdef header}(var BufferLen: integer): pointer; stdcall{$endif};
e_fun_1 {$ifndef header} 55 e_cm {$endif}AllocCGefileWriteBuffer e_fun_2 {$ifdef header}(var BufferLen: integer): pointer; stdcall{$endif};
e_pro_1 {$ifndef header} 52 e_cm {$endif}WriteToCGEFile e_pro_2 {$ifdef header} (BufferLen: integer); stdcall{$endif};
e_pro_1 {$ifndef header} 53 e_cm {$endif}CloseCGEFile e_pro_2 {$ifdef header} (FlushToFile: boolean; FileName: PAnsiChar); stdcall{$endif};
e_fun_1 {$ifndef header} 69 e_cm {$endif}GetCGEFileSessionId e_fun_2 {$ifdef header}(): int64; stdcall{$endif};

e_fun_1 {$ifndef header} 71 e_cm {$endif}CgeFileExists e_fun_2 {$ifdef header}(name: PAnsiChar): boolean; stdcall{$endif};
e_pro_1 {$ifndef header} 72 e_cm {$endif}CgeFileRename e_pro_2 {$ifdef header} (fFrom, fTo: PAnsiChar); stdcall{$endif};


e_fun_1 {$ifndef header} 54 e_cm {$endif}GetIsRussian e_fun_2 {$ifdef header}(): boolean; stdcall{$endif};
e_fun_1 {$ifndef header} 56 e_cm {$endif}FrameBufferHasAlphaComponent e_fun_2 {$ifdef header}(): boolean; stdcall{$endif};
e_fun_1 {$ifndef header} 57 e_cm {$endif}GetCurrentSessionID e_fun_2 {$ifdef header}(): int64; stdcall{$endif};
e_pro_1 {$ifndef header} 58 e_cm {$endif}NewSessionID e_pro_2 {$ifdef header} (); stdcall{$endif};
e_pro_1 {$ifndef header} 59 e_cm {$endif}_SetConfigInt e_pro_2 {$ifdef header} (section, id: PAnsiChar; Value: integer); stdcall{$endif};
e_fun_1 {$ifndef header} 60 e_cm {$endif}_GetConfigInt e_fun_2 {$ifdef header} (section, id: PAnsiChar): integer; stdcall{$endif};
e_fun_1 {$ifndef header} 68 e_cm {$endif}_GetConfigIntCh e_fun_2 {$ifdef header} (section, id: PAnsiChar; min, max: integer): integer; stdcall{$endif};

e_fun_1 {$ifndef header} 61 e_cm {$endif}CgeGenTexture e_fun_2 {$ifdef header} (var texture: glUint): int64; stdcall{$endif};
e_fun_1 {$ifndef header} 62 e_cm {$endif}UpdateTextureToken e_fun_2 {$ifdef header} (texture: glUint): int64; stdcall{$endif};
e_pro_1 {$ifndef header} 63 e_cm {$endif}UnclaimTexture e_pro_2 {$ifdef header} (texture: glUint; token: int64); stdcall{$endif};
e_fun_1 {$ifndef header} 64 e_cm {$endif}ClaimTexture e_fun_2 {$ifdef header} (texture: glUint; token: int64): longbool; stdcall{$endif};
e_pro_1 {$ifndef header} 65 e_cm {$endif}ClearUnclaimedTexturesList e_pro_2 {$ifdef header} (); stdcall{$endif};
e_pro_1 {$ifndef header} 66 e_cm {$endif}DeleteUnclaimedTextures e_pro_2 {$ifdef header} (); stdcall{$endif};
e_pro_1 {$ifndef header} 67 e_cm {$endif}CgeDeleteTexture e_pro_2 {$ifdef header} (texture: glUint; token: int64); stdcall{$endif};

e_fun_1 {$ifndef header} 70 e_cm {$endif}CTimer e_fun_2 {$ifdef header} (): float; stdcall{$endif};
