{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the complex typer processing procedures.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
(*

    NOTE:
      Since the reading and writing is always performed
      in 32-bit words, AND it is assumed that *anything*
      is aligned to the 32-bit boundary,
      the data types whose size isn't a multiply of 4
      are a big bad no-no.
      Be especially watchful for the packed records.

 **************************************************************
*)


(*

//Procedure template:

procedure RP_ (PField: pointer; OP: TFieldOperation); typeprocscall;
begin
  case op of
    fio_Load:
    fio_Save:
    fio_Skip:
  end;
end;


*)

procedure RP_Pointer (PField: pointer; OP: TFieldOperation); register;
begin
  //Pointer in CGE isn't a saveable type...
  case op of
    fio_Load, fio_Save: Die(MI_ERROR_PROGRAMMER_NO_BAKA, [
      RuEn('     -   .',
           'Attempt to save a pointer type field - slipped the parsing.')]);
    fio_Skip: //do nothing;
  end;
end;

procedure RP_Dyna (PField: pointer; OP: TFieldOperation); register;
var
  o: TDyna;
begin
  case op of
    fio_Load: TDyna(PField^):=ReadDyna();
    fio_Save: WriteDyna(TDyna(PField^));
    fio_Skip: begin
                o:=ReadDyna(); //load it and destroy it. The fate is cruel.
                o.Free;
              end;
  end;
end;


procedure RP_Persistent (PField: pointer; OP: TFieldOperation); register;
var
  o: TTrulyPersistent;
begin
  case op of
    fio_Load: ReadPersistent(TTrulyPersistent(PField^));
    fio_Save: WritePersistent(TTrulyPersistent(PField^));
    fio_Skip: begin
                ReadPersistent(o); //..load it..
                MemoryLeakSuspected:=Yes;
                //..And do NOTHING.
                //  All the persistent objects are stored in the special array
                //    and dealt with special alghorithm.
              end;
  end;
end;


procedure RP_AnsiString (PField: pointer; OP: TFieldOperation); register;
begin
  case op of
    fio_Load: AnsiString(PField^):=ReadAnsiString();
    fio_Save: WriteAnsiString(AnsiString(PField^));
    fio_Skip: SkipAnsiString;
  end;
end;

procedure RP_Enum (PField: pointer; OP: TFieldOperation); register;
begin
  case op of
    fio_Load: LoadEnum(LocalTI, PField);
    fio_Save: WriteDword(PField);
    fio_Skip: SkipDword;
  end;
end;

procedure RP_WideString (PField: pointer; OP: TFieldOperation); register;
begin
   case op of
    fio_Load: WideString(PField^):=ReadWideString();
    fio_Save: WriteWideString(WideString(PField^));
    fio_Skip: SkipWideString;
  end;
end;

procedure RP_ArrayOfDWORD (PField: pointer; OP: TFieldOperation); register;
// since it works with binary data, it should work
//   with *any* type whose size is equal to 32 bits:
//   cardinal, integer, single, glUint, gl float, et cetera.
//
type
  _A = array of dword;
var
  s: integer;
begin
  case op of
    fio_Load: begin
        s:=ReadInt();
        SetLength(_A(PField^), s);
        if s > 0
     //need to check, since an empty dynamic array is in fact a nil pointer.
          then ReadBin(@(_A(PField^)[0]), s);
      end;
    fio_Save: begin
        s:=Length(_A(PField^));
        WriteInt(s);
        if s > 0 then WriteBin(@(_A(PField^)[0]), s);
      end;
    fio_Skip: begin
        SkipBin(ReadInt());
      end;
  end;
end;

{$ifndef fpc}
procedure RP_LONGBOOL (PField: pointer; OP: TFieldOperation); register;
begin
  case op of
    fio_Load: begin
        if ReadInt() = 0 then longbool(PField^):=false
                         else longbool(PField^):=false;
      end;
    fio_Save: begin
        if longbool(PField^) then WriteInt(1)
                             else WriteInt(0);
      end;
    fio_Skip:
        ReadInt;
  end;
end;
{$endif}

procedure RP_2dArrayOfDword (PField: pointer; OP: TFieldOperation); register;
var
  s, i: integer;
begin
  case op of
    fio_Load: begin
        s:=ReadInt();
        SetLength(T2dArrayofDword(PField^), s);
        for i:=0 to s - 1 do begin
          s:=ReadInt();
          SetLength(T2dArrayofDword(PField^)[i], s);
          if s > 0
            then ReadBin(@(T2dArrayofDword(PField^)[i][0]), s);
        end;
      end;
    fio_Save: begin
        s:=Length(T2dArrayofDword(PField^));
        WriteInt(s);
        for i:=0 to s - 1 do begin
          s:=Length(T2dArrayofDword(PField^)[i]);
          WriteInt(s);
          if s > 0 then WriteBin(@(T2dArrayofDword(PField^)[i][0]), s);
        end;
      end;
    fio_Skip: begin
        s:=ReadInt();
        for i:=0 to s - 1 do begin
          s:=ReadInt();
          if s > 0
            then SkipBin(s);
        end;
      end;
  end;
end;

