{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the TTrulyPersistent class methods.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}


  {$include mo_scenario.inc}

  procedure TTrulyPersistent.SaveSelf();
  var
    i, j: integer;
    v: TCustomTypeProcessingProc;
  begin
    BeforeSaving;
    i:=_ScenarioIndex() + 1;
    //Always by scenario
    For j:=1 to Scenario[i - 1] do begin
      v:= TCustomTypeProcessingProc(Scenario[i]);
      if Assigned (v)
        then begin
          v(pointer(cardinal(self) + Scenario[i + 1]), fio_Save)
        end
        else WriteBin(pointer(cardinal(self) + Scenario[i + 1]), Scenario[i + 2]);
      inc(i, 3);
    end;
  end;

  procedure TTrulyPersistent.LoadSelf();
  var
    i, j: integer;
    v: TCustomTypeProcessingProc;
  begin
    i:=_ScenarioIndex();
    if i >=0 then begin
      //Load by scenario
      inc(i);
      For j:=1 to Scenario[i - 1] do begin
        v:= TCustomTypeProcessingProc(Scenario[i]);
        if Assigned (v)
          then begin
            v(pointer(cardinal(self) + Scenario[i + 1]), fio_Load)
          end
          else ReadBin(pointer(cardinal(self) + Scenario[i + 1]), Scenario[i + 2]);
        inc(i, 3);
      end;
    end
    else begin
      // Scenario cannot be built for this class.
      //   Either the field list has changed, or some enumerated type has changed.

      // Load using the old routine, featuring a total, per-field conversion.
      for i:=0 to TFieldsList(LocalFieldsList()).High do begin
        With TFieldsList(LocalFieldsList())[i] do begin
          if Skip then Continue; //Skipped at saving. Nothing to do.
          if RFind >= 0 then begin
          //load the field
            With Types[Tind] do
              if Assigned(proc)
                 then begin
                   LocalTI:= tind;
                   proc(pointer(cardinal(self) + TFieldsList(FieldsList())[RFind].offset), fio_Load)
                 end
                 else ReadBin(pointer(cardinal(self) + TFieldsList(FieldsList())[RFind].offset), SizeToBufferIndex(Size));
          end
          else begin
            //Skip this field, it doesn't exist in current implementation or its type had changed.
            With Types[Tind] do
              if Assigned(proc)
                then proc(nil, fio_Skip)
                else SkipBin(SizeToBufferIndex(Size));
          end;
        end;
      end;
    end;
  end;

{$ifdef fpc}
{ class function TObject.NewInstance : tobject;
  var
    p : pointer;
  begin
    getmem(p, InstanceSize);
    if p <> nil then
      InitInstance(p);
    NewInstance:=TObject(p);
  end;}

  class function TTrulyPersistent.NewInstance : tobject;
  var
    p : pointer;
  begin
    getmem(p, InstanceSize);//ToDo: replace with custom memory manager.
    if p <> nil then
      InitInstance(p); //ToDo: replace with custom procedure.
    NewInstance:=TObject(p);
  end;
{$endif}

  procedure TTrulyPersistent.RegisterFields;
  begin
    //do nothing
  end;

  procedure TTrulyPersistent.AfterConstruction;
  begin
    //do nothing
  end;

  procedure TTrulyPersistent.AfterLoading;
  begin
    //do nothing
  end;
  
  procedure TTrulyPersistent.BeforeSaving;
  begin
    //do nothing
  end;

  constructor TTrulyPersistent.Register;
  {
     To calculate the field offsets we need an instance first!
     Thus, this constructor: it creates a temporary instance
       and registers the fields. Called from RegClass() procedure.
  }
  begin
    inherited Create;
    RegBegin(Self);
    RegisterFields;
    RegEnd;
    //Free;
  end;

  constructor TTrulyPersistent.Generate;
  {
     We neeed to avoid the usual initialization routines
     when we load the instance. So here is a special
     constructor for this. It does nothing,
     not even calls AfterConstruction.
  }
  begin
  end;
  destructor TTrulyPersistent.TechnicalDestroy;
  begin
    inherited Destroy;
  end;
  
  {stubs for the "class fields" implemented via fake virtual methods}
    procedure TTrulyPersistent._MyClassIndex(); begin AddLog('a'); end;
    procedure TTrulyPersistent._MyScenarioIndex(); begin AddLog('b'); end;
    procedure TTrulyPersistent._MyFieldsList(); begin AddLog('c'); end;
    procedure TTrulyPersistent._MyLocalFieldsList(); begin AddLog('d'); end;
    procedure TTrulyPersistent._MyLOcalClassIndex(); begin AddLog('e'); end;

  {$ifndef fpc}
    procedure AllowWriteToMemory(addr: pointer);
    var
      MBI: MEMORY_BASIC_INFORMATION;
      stub: dword;
    begin
      if not IsBadWritePtr(addr, sizeof(pointer) * 5) then Exit;
      if VerboseLog then AddLog(
        'Class VMT is write-protected. Removing the protection at %0...',[addr]);
      if (VirtualQuery(addr, MBI, SizeOf(MBI)) <> SizeOf(MBI))
      or not VirtualProtect(MBI.BaseAddress, MBI.RegionSize, PAGE_EXECUTE_READWRITE, @stub)
        then Die(PervertedFormat(RuEn(
          '        %0.',
          'Failed to gain write access rights for memory at address %0.'), [addr]));
      if VerboseLog then AddLog('Success. Gained write access for %1 bytes at %0.',
        [MBI.AllocationBase, MBI.RegionSize]);
    end;
  {$endif}

  class procedure TTrulyPersistent._SetMyFieldsList(F: TObject);//TFieldsList);
  begin
    TFieldsList(pointer(Cardinal(Self)+vmtMyFieldsList)^):= TFieldsList(F);
  end;

  class function TTrulyPersistent.FieldsList(): TObject;//TFieldsList;
  begin
    Result:=TFieldsList(pointer(Cardinal(Self)+vmtMyFieldsList)^)
  end;

  class procedure TTrulyPersistent.SetLocalFieldsList(F: TObject);//TFieldsList);
  begin
    TFieldsList(pointer(Cardinal(Self)+vmtMyLocalFieldsList)^):= TFieldsList(F);
  end;

  class function TTrulyPersistent.LocalFieldsList(): TObject;//TFieldsList;
  begin
    Result:=TFieldsList(pointer(Cardinal(Self)+vmtMyLocalFieldsList)^)
  end;

  class function TTrulyPersistent.ClassIndex(): integer;
  begin
    Result:=integer(pointer(Cardinal(Self)+vmtMyClassIndex)^);
   {$ifdef safeloading}
    if Result = InvalidClassIndex then Result:= 0;
   {$endif}
  end;

  class procedure TTrulyPersistent._RegisterMyIndex(index: integer);
  var p: pointer;
  begin
    p:=pointer(Cardinal(Self)+vmtMyClassIndex);
    {$ifndef fpc}
     AllowWriteToMemory(p);
    {$endif}
    integer(p^):= index;
  end;

  class function TTrulyPersistent.LocalClassIndex(): integer;
  begin
    Result:=integer(pointer(Cardinal(Self)+vmtMyLocalClassIndex)^)
  end;

  class procedure TTrulyPersistent.SetLocalClassIndex(i: integer);
  begin
    integer(pointer(Cardinal(Self)+vmtMyLocalClassIndex)^):= i;
  end;

  class procedure TTrulyPersistent._SetScenarioIndex(index: integer);
  begin
    integer(pointer(Cardinal(Self)+vmtMyScenarioIndex)^):= index;
  end;

  class function TTrulyPersistent._ScenarioIndex(): integer;
  begin
    Result:=integer(pointer(Cardinal(Self)+vmtMyScenarioIndex)^)
  end;
  
