{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the TTrulyPersistent class methods.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}



{  Scenario format: <number of entries>, (<procedure>, <offset>, <size>)}

  class procedure TTrulyPersistent.BuildsavingScenario();
  var
    proc: TCustomTypeProcessingProc;
    i, ii, sizeind: integer;
    lastisbinary: boolean;
    function AddToScenario(d: dword): integer; inline;
    begin
      SetLength(Scenario, Length(Scenario) + 1);
      Result:=High(Scenario);
      Scenario[Result]:=d;
    end;
  begin
    ii:=AddToScenario(0);
    lastisbinary:=No;
    For i:=0 to TFieldsList(FieldsList).High do
      With TFieldsList(FieldsList)[i] do begin
        if Skip then begin
          lastisbinary:=no;
          Continue;
        end;
        if Assigned(Types[tind].proc) and (Types[tind].Kind <> fk_Enum) then begin
          //complex field:
          lastisbinary:=No;
          AddToScenario(dword(@Types[tind].proc));
          AddToScenario(offset);
          AddToScenario(0);
          inc(Scenario[ii]);
        end
        else begin
          //binary field:
          if lastisbinary then begin //merge(!) with previous.
            inc(Scenario[sizeind], SizeToBufferIndex(Types[tind].size));
          end
          else begin //add normally
            lastisbinary:=Yes;
            AddToScenario(0);
            AddToScenario(offset);
            sizeind:=AddToScenario(SizeToBufferIndex(Types[tind].size));
            inc(Scenario[ii]);
          end;
        end;
      end;
    _SetScenarioIndex(ii);
  end;

  class procedure TTrulyPersistent.BuildLoadingScenario();
  var
    i: integer;
  begin
    if TFieldsList(FieldsList).High <> TFieldsList(LocalFieldsList).High
      //number of fields had changed
    then begin
      _SetScenarioIndex(-1); //no scenario could be built for this class
//AddLog( '@@@@ %0  %1', [TFieldsList(FieldsList).High, TFieldsList(LocalFieldsList).High]);
      BasketWarnings.Add(
               MsgFormat(MI_BASKET_CONVERSION, [UpperCase(ClassName())]));
      Exit;
    end;
    For i:=0 to TFieldsList(LocalFieldsList).High do
      With TFieldsList(LocalFieldsList)[i] do
        if (RFInd <> i) //the order of the fields had changed
        or ((Types[Tind].Kind = fk_Enum) and not EnumIdentic[Tind]) //there are
                                  //  enumerated types that need to be converted
        then begin
          _SetScenarioIndex(-1); //no scenario could be built for this class
          BasketWarnings.Add(
               MsgFormat(MI_BASKET_CONVERSION, [UpperCase(ClassName())]));
          Exit;
        end;
    //else build the saving scenario - because they are identic, in fact.
    BuildSavingScenario();
  end;

