{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the indexer class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$ifdef fpc}
  {$mode delphi}
{$endif}
{$longstrings on}
{$minenumsize 4}


unit mo_indexer;
interface
  uses un_typedefs, mo_hub, mo_classes;
  
Type
  TIndexer = class(TTrulyPersistent)
  private
    f_d: TArrayOfTrulyPersistent;
    f_FreeList, f_Reference_Count: TAOI;
    function GetD(ind: integer): TTrulyPersistent;
  public
    procedure RegisterFields; override;
    constructor Create;
    destructor Destroy; override;

    property D[i: integer]: TTrulyPersistent read GetD; default;
    function AddRef(o: TTrulyPersistent): integer; overload;
    procedure AddRef(ind: integer); overload;
    procedure ImDead(ind: integer);
    procedure Release(ind: integer);
    function ReferenceCount(ind: integer): integer;
  end;
  
  
  
implementation

    procedure TIndexer.RegisterFields;
    begin
      RegField('f_d', @f_d, TypeInfo(TArrayOfTrulyPersistent));
      RegField('f_FreeList', @f_FreeList, TypeInfo(TAOI));
      RegField('f_Reference_Count', @f_Reference_Count, TypeInfo(TAOI));
    end;

    constructor TIndexer.Create;
    begin
      f_d:=TArrayOfTrulyPersistent.Create;
      f_d.Container:=No;
      f_FreeList:=TAOI.Create;
      f_Reference_Count:=TAOI.Create;
    end;

    destructor TIndexer.Destroy;
    begin
      f_Reference_Count.Free;
      f_FreeList.Free;
      f_d.Free;
    end;

    function TIndexer.GetD(ind: integer): TTrulyPersistent;
    begin
      Result:=f_d[ind];
    end;
    
    function TIndexer.AddRef(o: TTrulyPersistent): integer;
    begin
      if f_freeList.Length > 0 then begin
        Result:=f_FreeList.Last;
        f_FreeList.Decrement;
      end
      else begin
        Result:=f_d.Add(o);
        f_Reference_Count.Length:=f_d.Length;
      end;
      f_Reference_Count[Result]:=f_Reference_Count[Result] + 1;
    end;
    
    procedure TIndexer.AddRef(ind: integer);
    begin
      f_Reference_Count[ind]:= f_Reference_Count[ind] - 1;
    end;

    procedure TIndexer.ImDead(ind: integer);
    begin
      f_d[ind]:=nil;
    end;

    procedure TIndexer.Release(ind: integer);
    begin
      f_Reference_Count[ind]:= f_Reference_Count[ind] - 1;
      if f_Reference_Count[ind] = 0 then begin
        f_d[ind]:=nil;
        f_FreeList.Add(ind);
      end;
    end;

    function TIndexer.ReferenceCount(ind: integer): integer;
    begin
      Result:=f_Reference_Count[ind];
    end;
end.
