{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004 - 2006 by Anton Rzheshevski (chebmaster@mail.ru),
     and contains the log/error processing routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
//Temporary. To be incorporated later into the module body.


  function VarRecToWide(V: TVarRec): WideString;
  begin
    Case V.Vtype of
      vtInteger:    Result := IntToStr(V.VInteger);
      vtBoolean:    Result := AnsiToWide(BoolChars(V.VBoolean));
      vtChar:   Result := AnsiToWide(V.VChar);
      vtWideChar:   Result:=V.VWideChar;
      vtExtended:   Result := FloatToStr(V.VExtended^);
      vtAnsiString: Result := AnsiString(V.VAnsiString);
      vtWideString: Result := WideString(V.VWideString);
      vtPChar:  Result := AnsiToWide(PCharToString(V.VPChar));
      vtPWideChar:  Result := PWideCharToWideString(V.VPWideChar);
      vtObject:     Result := V.VObject.ClassName;
      vtClass:      Result := V.VClass.ClassName;
      vtPointer: begin
        if Assigned(V.VPointer) then Result:= Format('%Ph',[V.VPointer])
                                else Result:='NIL';
      end;

      //not supported in the FreePascal 1.0.6:
      vtCurrency:   Result := CurrToStr(V.VCurrency^);
      vtVariant:    Result := string(V.VVariant^);

      vtInt64:      Result := IntToStr(V.VInt64^);
    else
      Result:='?unknown VarRec type?';
    end;
  end;

  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
  var
    j: integer;
    R, b, e: WideString;
  begin
    e:='';
    For j:=0 to High(p) do begin
      b:=VarRecToWide(P[j]);
      if WidePos('%' + IntToStr(j), U) < 1
        then e:=e + '  [' + b + ']  '
        else u:=WideReplace(u, '%' + IntToStr(j), b);
    end;
    if e <> '' then begin
      e:=' +FORMAT ERROR!! ' + e;
    end;
    Result:=u + e;
  end;
  
  function StrOrUndefined(U: WideString): WideString;
  begin
    if U='' then Result:=PWideCharToWideString(HostMsg(MI_UNDEFINED))
            else Result:=U;
  end;

 {$ifdef win32}
  function Win32LastError: WideString;
  var
    M: Cardinal;
    u: WideString;
  begin
    M:=GetLastError;
    if M = ERROR_SUCCESS then Result:=''
    else begin
      u:=AnsiToWide(SysErrorMessage(M));
      Result:=#10#13 + Result + #10#13 + PervertedFormat(
        PWideCharToWideString(HostMsg(MI_WIN32_EXPLAINS)),
        [IntToHex(M, 8), u]);
    end;
  end;
 {$endif}

    var _dyell: WideString;

    function ExceptObjectisException: boolean;
    begin
      Try
        Result:=ExceptObject is Exception;
      Except
        Result:=No;
      End;
    end;

  procedure CheckForGenericDyingYells;
  begin
    Try
      if not NowDying() and (ExceptObject <> nil) and ExceptObjectisException()
      then begin
        _dyell:=_dyell + #10#13#10#13 + ToldException(ExceptObject as Exception);
      {$ifdef win32}
        //..  
        //   WinAPI GetLastEror (  Win32LastEror)
        _dyell:= _dyell + Win32LastError;
      {$endif}
      end;
      {$ifdef win32}
        SetLastError(0);
      {$endif}
    Except
      _dyell:=_dyell + #10#13'!Crashed accessing Exception object!';
    End;
  end;

  Procedure Die(YellID :TMessageID; Param: array of const);
  begin
    _dyell:=MsgFormat(YellID, Param);
    CheckForGenericDyingYells;
    HostDieW(PWideChar(_dyell));
  end;
  
  Procedure Die(u: WideString; Param: array of const);
  begin
    _dyell:=PervertedFormat(u, Param);
    CheckForGenericDyingYells;
    HostDieW(PWideChar(_dyell));
  end;

  
  Procedure Die(AnsiYell: AnsiString);
  begin
    Die(AnsiToWide(AnsiYell), [])
  end;

  Procedure Die(YellID :TMessageID);
  begin
    Die(YellId, []);
  end;
  
  Procedure Die(AnsiYell: AnsiString; param: array of const);
  begin
    Die(AnsiToWide(AnsiYell), param);
  end;
  
  Procedure Die(u: WideString);
  begin
    Die(u, []);
  end;

  Procedure AddLog(S: Ansistring; Param: array of const);
  begin
    AddLog(AnsiToWide(S), Param);
  end;

    var _2log: WideString;
  Procedure AddLog(U: WideString; Param: array of const);
  begin
    _2log:=PervertedFormat(u, Param);
    HostLogW(PWideChar(_2log));
  end;

  Procedure AddLog(mID: TMessageID; Param: array of const);
  begin
    _2log:=MsgFormat(mID, Param);
   HostLogW(PWideChar(_2log));
  end;

  Procedure AddLog(mID: TMessageID);
  begin
    AddLog(mID, []);
  end;

  Procedure AddLog(S: AnsiString);
  begin
    AddLog(AnsiToWide(S), []);
  end;

  Procedure AddLog(U: WideString);
  begin
    AddLog(U, []);
  end;

