{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004 - 2006 by Anton Rzheshevski (chebmaster@mail.ru),
     and contains the main unit for the game modules.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$ifdef fpc}
  {$include mo_fpc_pl_chk.h}
{$endif}

{$include mo_globaldefs.h}

{$ifdef fpc}
  {$IFDEF Win32}
    {$DEFINE extdecl := stdcall }
  {$ELSE}
    {$DEFINE extdecl := cdecl }
    {$LINKLIB c}
  {$ENDIF}
{$endif}

unit mo_hub;

interface
uses
  SysUtils,
  un_typedefs
  {$ifdef win32}
  ,Windows
  {$else}
  ,dllfuncs, dl
  {$endif};

  procedure GrandInitialize(m,n,b: integer);

  {$include un_texsages.h}
    //custom message IDs go here
  );

  {$include un_gl.h}

  {$include un_unicode.h}

type
  TRegisterProc = procedure(n: integer; var p: pointer); safecall;

var
  BaseDir: WideString;
  VerboseLog, DeveloperMode, Russian: boolean;


  RegisterProc: TRegisterProc;
{$ifdef fpc}
 {$include mo_eh_freepascal.h}
{$else}
  {$include mo_eh_delphi.inc}
{$endif}

  function PervertedFormat(U: WideString; P: array of const): WideString;
  function MsgFormat(M: TMessageId; Param: array of const): WideString;
  function MsgRaw(M: TMessageId): WideString;

  function RuEn(Ru, En: AnsiString): AnsiString;
  function StrOrUndefined(U: WideString): WideString;

  function PCharToString(P: PAnsiChar): AnsiString;
  function PWideCharToWideString(P: PWideChar): WideString;

  Procedure Die(YellID :TMessageID; Param: array of const); overload;
  Procedure Die(AnsiYell: AnsiString); overload;
  Procedure Die(AnsiYell: AnsiString; param: array of const); overload;
  Procedure Die(YellID :TMessageID); overload;
  Procedure Die(u: WideString; Param: array of const);  overload;
  Procedure Die(u: WideString);  overload;

  Procedure AddLog(U: WideString); overload;
  Procedure AddLog(S: AnsiString); overload;
  Procedure AddLog(mID: TMessageID); overload;
  Procedure AddLog(mID: TMessageID; Param: array of const); overload;
  Procedure AddLog(U: WideString; Param: array of const); overload;
  Procedure AddLog(S: Ansistring; Param: array of const); overload;
  
  procedure SetConfigInt (section, id: AnsiString; Value: integer);
  function GetConfigInt (section, id: AnsiString): integer;
  
  function VersionToStr(major, minor, build: integer): AnsiString;

  

//OpenGL:
  procedure ClearProcAddresses;
  procedure InitProcAddresses;
  //function glext_LoadExtension(ext: String): Boolean;

implementation

uses
    mo_classes;


  {$include un_gl.inc}

  {$include mo_talesteller.inc}

  {$include mo_hub_1.inc}

  {$include un_unicode.inc}

  {$ifdef fpc}
    {$define e_fun_1 := RegisterProc( }
    {$define e_fun_2 := ) }
    {$define e_pro_1 := RegisterProc( }
    {$define e_pro_2 := ) }
    {$define e_cm := ,@ }
  {$else}
    {$include mo_ee_delphi.inc}
  {$endif}


  procedure GrandInitialize(m,n,b: integer);
  var
    Mm: TMemoryManager;
  begin
    ClearProcAddresses; //OpenGL;
   {$ifdef win32}
     Set8087CW($133F);
     //Disable FPU exceptions (it will ignore divisions by zero and such)
   {$else}
     //how to do it in unix?..
   {$endif}

   {$ifdef fpc}
     GetMemoryManager(Mm);
     Mm.NeedLock:=false;   //does it help?.. I do not use any threads...
     SetMemoryManager(Mm);
    {$endif}
    
    InitUnicode;

    {$ifdef fpc}
      {$include un_exported_func.h}
    {$else}
      InitExportProcsDelphi;
    {$endif}

    ValidateVersion(m, n, b);
    ValidateTypesets(ord(MI_CORE_MIDs_END), 0);
    ValidateTypesets(ord(Re_Stub), 1);

    BaseDir:=PWideCharToWideString(GetBaseDir);

    DeveloperMode:=GetIsInDeveloperMode();
    VerboseLog:=GetIsLogVerbose();
    Russian:=GetIsRussian();
    
    ClassesRegistrationStart;
    
    InitProcAddresses;//OpenGL
    
  end;

  function MsgRaw(M: TMessageId): WideString;
  begin
    if M > MI_CORE_MIDs_END then begin

      //Ask the custom message manager

    end
    else
      Result:=PWideCharToWideString(HostMsg(M));
  end;

  function MsgFormat(M: TMessageId; Param: array of const): WideString;
  begin
    Result:=PervertedFormat(MsgRaw(M), param);
  end;


  function PCharToString(P: PAnsiChar): AnsiString;
  var
    i: integer;
    p2: PAnsiChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i);
    end;
  end;

  function PWideCharToWideString(P: PWideChar): WideString;
  var
    i: integer;
    p2: PWideChar;
  begin
    if not Assigned(p) then Result:=''
    else begin
      p2:=p;
      i:=0;
      While p2^ <> #0 do begin
        inc(p2);
        inc(i);
      end;
      SetLength(Result, i);
      Move(p^, Result[1], i*2);
    end;
  end;
  
  procedure SetConfigInt (section, id: AnsiString; Value: integer);
  begin
    _SetConfigInt(PAnsiChar(section), PAnsiChar(id), value);
  end;
  
  function GetConfigInt (section, id: AnsiString): integer;
  begin
    Result:=_GetConfigInt(PAnsiChar(section), PAnsiChar(id));
  end;

  function VersionToStr(major, minor, build: integer): AnsiString;
  begin
    Result:=format('%d.%.2d.%.4d' ,[Major, minor, build]);
  end;

  function RuEn(Ru, En: AnsiString): AnsiString;
  begin
    if Russian then Result:=Ru else Result:=En;
  end;
end.
