{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
{$include mo_dyna_1template.inc}

function type2name._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function type2name._Read(ind: cardinal): type1name;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind) < s), 'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=type1name(a[ind]);
end;

procedure type2name._Write(ind: cardinal; p: type1name);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure type2name._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin type1name(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(type1name.Create);
//WriteLn('*** 3');
end;

function type2name._ReadLast: type1name;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=type1name(a[s-1]);
end;

procedure type2name._WriteLast(z: type1name);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure type2name.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure type2name.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

procedure type2name.Save();
var i: integer;
begin
  WriteInt(Self.Length);
  For i:=0 to Self.High do
    Self[i].Save;
end;

procedure type2name.Load();
var i: integer;
begin
  Self.Length:=ReadInt();
  For i:=0 to Self.High do
    Self[i].Load;
end;

{$ifndef hasnoproc}
  procedure type2procname (PField: pointer; OP: TFieldOperation); register;
  var
    o: type2name;
  begin
    case op of
      fio_Load: if PeekInt() < 0 then begin
                  pointer(PField^):=nil;
                  ReadInt;
                end
                else begin
                  type2name(PField^):=type2name.Create;
                  type2name(PField^).Load;
                end;
      fio_Save: if Assigned(pointer(PField^))
                  then type2name(PField^).Save
                  else WriteNil;
      fio_Skip: if PeekInt() >= 0 then begin
                  o:=type2name.Create; //load it and destroy it. The fate is cruel.
                  o.Load;
                  o.Free;
                end
                else ReadInt;
    end;
  end;

{$endif}


