{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{$include mo_dyna_1template.h}

  type2name = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of type1name;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" - like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(

    function _Read(ind: cardinal): type1name;
    procedure _Write(ind: cardinal; p: type1name);
    function _ReadLast: type1name;
    procedure _WriteLast(z: type1name);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    procedure Save(); override;
    procedure Load(); override;
    property D[index: cardinal]:type1name read _Read write _Write; DEFAULT;
    property Last:type1name read _ReadLast write _WriteLast;
  End;


