{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
 
  type1name = Class(TDyna)
    Function Add(i: typeofit): integer; virtual;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of typeofit
    {$endif};
    function _Read(ind: cardinal): typeofit;
    procedure _Write(ind: cardinal; p: typeofit);
    function _ReadDPTR: pointer; override;
    function _ReadLast: typeofit;
    function _ReadNext: typeofit;
    function _ReadFirst: typeofit;
    procedure _WriteLast(p: typeofit);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    procedure Save(); override;
    procedure Load(); override;
    property D[index: cardinal]:typeofit read _Read write _Write; DEFAULT;
    property Last:typeofit read _ReadLast write _WriteLast;
    property First: typeofit read _ReadFirst;
    property Next: typeofit read _ReadNext;
  End;


