{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}


{$define cl_stringtype}
{$define cl_ansistringtype}

{$define typeofit := AnsiString}
{$define type1name := TAOS}
{$define type2name := T2DAOS}
{$define type1procname := RP_TAOS }
{$define type2procname := RP_T2DAOS }

  {$include mo_dyna_2template.inc}
  
{$undef cl_ansistringtype}

{$define typeofit := WideString}
{$define type1name := TAOW}
{$define type2name := T2DAOW}
{$define type1procname := RP_TAOW }
{$define type2procname := RP_T2DAOW}
  {$include mo_dyna_2template.inc}

{$undef cl_stringtype}

{$define typeofit := float}
{$define type1name := TAOF}
{$define type2name := T2DAOF}
{$define type1procname := RP_TAOF}
{$define type2procname := RP_T2DAOF}
  {$include mo_dyna_2template.inc}


{$define typeofit := cardinal}
{$define type1name := TAOC}
{$define type2name := T2DAOC}
{$define type1procname := RP_TAOC }
{$define type2procname := RP_T2DAOC }
  {$include mo_dyna_2template.inc}

{$define typeofit := integer}
{$define type1name := TAOI}
{$define type2name := T2DAOI}
{$define type1procname := RP_TAOI }
{$define type2procname := RP_T2DAOI }
  {$include mo_dyna_2template.inc}

{ TDyna }

constructor TDyna.Create;
begin
  inherited;
  s:=0;
  sm:=0;
  es:=4;
end;

procedure TDyna.Decrement;
begin
  Assert(s > 0,'attempt to decrement TDyna, which length is zero');
  ReSize(s - 1);
end;

destructor TDyna.Destroy;
begin
  resize(0);
  inherited;
end;

function TDyna.GetHigh: integer;
begin
  Result:=s-1;
end;

function TDyna.GetSize: integer;
begin
  Result:=s;
end;

procedure TDyna.Increment;
begin
  ReSize(s+1);
end;

procedure TDyna.Resize(newLen: integer);
var t, n: integer;
begin
 { if sm=0 then begin
    if newLen=0 then Exit
    else begin
      sm:=NewLen;
    end;
  end
  else begin
    if newLen=0 then begin
      sm:=0;
    end
    else begin
      if NewLen > sm then begin
        sm:=((NewLen shr 3) + 1) shl 3;
      end
      else begin
        t:=sm shr 3;
        if (sm - NewLen > t) then begin
          sm:=NewLen;
        end;
      end;
    end;
  end; }
  sm:=NewLen;
  _Resize(NewLen);
  s:=NewLen;
end;

procedure TDYNA.SetRect(a, b: integer);
begin
  Assert(b = 1, 'TDyna: attempt to set second dimension of the one-dimensional array');
  Resize(a);
end;

  Procedure SafeFree(var o: TObject);
  begin
    if Assigned(o) then o.Free;
    pointer(o):=nil;
  end;

