{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the persistency system essentials.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
{$include mo_globaldefs.h}
{$rangechecks off}
{$ifdef fpc}
  {$ifopt C+} //if assertions are turned on...
    {$define safeloading} //..compile with all the safeguards included
  {$else}
    {$undef safeloading} //..compile without safeguards.
  {$endif}        // Will raise a plain, unexplained AVs on corupted data files.
{$endif}
{$TYPEINFO ON}

unit mo_classes;

interface
  uses SysUtils, Classes, un_Typedefs, typinfo,
       {$ifndef fpc}
         Windows,
       {$endif}
       {$ifdef cge}
         mo_hub;
       {$else}
         mo_file_stub
         {$ifdef fpc}
           , md5
         {$endif}
        ;
       {$endif}

type
  TTrulyPersistent = class(TObject)
  published
    { These aren't methods. These are a dirty trick to store integer values
        directly in the class VMT.
        (Why the hell aren't there such things as "class fields"?..)
      Them being not abstract is a candy for compiler crying about
             "constructing a class with abstract methods".}
    procedure _MyClassIndex(); virtual;
    procedure _MyScenarioIndex(); virtual;
    procedure _MyFieldsList(); virtual;
    procedure _MyLocalFieldsList(); virtual;
    procedure _MyLOcalClassIndex(); virtual;
  protected
    // **** No user-serviceable parts inside
    _BasketIndex: integer; //Must be the first field.
    class procedure _RegisterMyIndex(index: integer);
    class procedure _SetScenarioIndex(index: integer);
    class function _ScenarioIndex(): integer;
    class procedure _SetMyFieldsList(F: TObject);//TFieldsList);
    constructor Register;
    constructor Generate;
    destructor TechnicalDestroy;
    class procedure BuildsavingScenario();
    class procedure BuildLoadingScenario();
  {$ifdef fpc}
    class function NewInstance() : tobject; override;
  {$endif}
    class function FieldsList(): TObject;//TFieldsList;
    class function LocalFieldsList(): TObject;//TFieldsList;
    class procedure SetLocalFieldsList(F: TObject);//TFieldsList);
    class procedure SetLocalClassIndex(i: integer);
    class function ClassIndex(): integer;
    class function LocalClassIndex(): integer;
    procedure SaveSelf(); virtual;
    procedure LoadSelf(); virtual;
    procedure AfterConstruction(); override;
  public
    // **** Truly public stuff. For the users of Cheper.
    procedure RegisterFields; virtual;
    procedure BeforeSaving(); virtual;
    procedure AfterLoading(); virtual; //is called after the object is loaded.
  end;

  CTrulyPersistent = class of TTrulyPersistent;

// **************** SAVING / LOADING ROUTINES **********************

  procedure SaveGame(o: TObject; {$ifdef cge}m: TMessageId;{$endif} version: AnsiChar; TargetName: AnsiString);
  function LoadGame({$ifdef cge}m: TMessageId;{$endif} SourceName: AnsiString; ClassName: WideString): TObject;

  procedure PrepareToSave(TargetName: String; version: AnsiChar; Signature: WideString);
  procedure PrepareToLoad(SourceName: String; Signature: WideString);
  procedure DoneSaving(FlushToFile: boolean; FileName: AnsiString);
  procedure DoneLoading();
  
var
 //could be '0' (basic), 's' (safe, with md5 check) or 'p' (packed).
  VersionOfLoadedFile: AnsiChar;

  {$ifndef cge}
    {$include mo_tmid_public.h}
  {$endif}

type
  {$ifdef fpc}
    {$include mo_dyna.h}
  {$else}
    {$include mo_dyna_h_delphi.inc}
  {$endif}

type
  TFieldOperation = (fio_Load, fio_Save, fio_Skip);
  TCustomTypeProcessingProc = procedure
        (PField: pointer; Op: TFieldOperation); register;

// ****************** INIT PROCEDURES ********************************
  procedure ClassesRegistrationStart;
//!!!  procedure ClassesRegistratonEnd;

{   RegClass must be called for each descendant of TTrulyPersistent.
      The best place to do it is the initialization procedure of the module.
      Automatically calls the "Register" constructor of a class.
}
  procedure RegClass(C: CTrulyPersistent);

// ****************** FIELD PROCEDURES *********************************

{
    These intended to be called only and only from within the
    "Register" constructor of TTrulyPersistent descendants.
       (Why didn't I make them its methods...?)
    Types should be registered first.   )
}
  procedure RegField(name: string; Pf: pointer; PI: PTypeInfo); overload;
{ example: RegField('Merry rabbits', @bunnies, TypeInfo(TBunnies));
    -- where "bunnies" is a field of type TBunnies}

  //for types thad do not have RTTI (namely, static arrays in Delphi)
  procedure RegField(name: string; Pf: pointer; TypeString: string); overload;

  //Skipped fields: for texture ids, and other stuff that
  //  cannot be safely restored from the save.
  procedure RegSkip(name: string; Pf: pointer; PI: PTypeInfo); overload;
  procedure RegSkip(name: string; Pf: pointer; TypeString: string); overload;
  //For pointers and non-registrable classes (technically, pointers too)
  procedure RegSkipPtr(name: string; Pf: pointer);

// ****************** TYPE PROCEDURES ************************************

{   These could be called from anywhere after the classes registration started.
      Even from the "Register" constructor.}

{   This bunny registers binary types (i.e. ones that could be
      dumped into a stream directly, without caring about their structure).
      ...I wish TypeInfo or TypeData structures had a size field
      so that pointing it manually would be unnecessary. Dreams, dreams... :(  }
  procedure RegType(Info: PTypeInfo; Size: Integer);  overload;
  
{   This bunny acts the same as the one above, with two following exceptions:
      A). It assumes type size is equal to pointer size (4 bytes), and
      B). It could be used to register enumeration types which need
          a special approach (saved as DWORDs, loaded either as
          DWORDs or via special converting routine - depending on the
          parsing results).
        (Do NOT forget to use the $MINENUMSIZE 4 compiler directive!)}
  procedure RegType(Info: PTypeInfo);  overload;

{   This bunny registers array types.
      Since the lack of RTTI it goes via string IDs.}
  procedure RegType(StringID: ansistring; Info: PTypeInfo; Size: Integer);  overload;

{   This bunny allows to deal with complex types like strings,
      dynamic arrays - even non-persistent objects! - by introducing
      a custom processing procedure (see template in mo_typeprocs.inc).
    Its only limitation is that it assumes base type to be a pointer,
      so field size is always pointer-sized (4 bytes on 32-bit platform).}
  procedure RegType(Info: PTypeInfo; Proc: TCustomTypeProcessingProc); overload;

{   These bunnies register types of corresponding classes.
      Note, that persistent classes are registered automatically
      when RegClass() is called. So you need to evoke
      RegType(C: CTrulyPersistent) manually only in cases of
      cross-reference (while class A has fields of type B,
      and class B - fields of type A)}
  procedure RegType(C: CTrulyPersistent);  overload;

// *********** FIELD SAVING / LOADING ROUTINES **********************
{   These can be used in the custom processing procedures}
  Function SizeToBufferIndex(s: integer): integer; {$ifdef fpc}inline;{$endif}
  procedure WriteInt(i: integer); {$ifdef fpc}inline;{$endif}
  function ReadInt: integer; {$ifdef fpc}inline;{$endif}
  function PeekInt: integer; {$ifdef fpc}inline;{$endif} //read value but not remove it from buffer

//Don't forget! !!! len is not in bytes but in 32-bit words!
  procedure WriteBin(p: pointer; len: integer); {$ifdef fpc}inline;{$endif}
  procedure ReadBin(p: pointer; len: integer); {$ifdef fpc}inline;{$endif}
  procedure SkipBin(len: integer); {$ifdef fpc}inline;{$endif}
// These three work for anything 32-bit: glFloat, cardinal, integer...
  procedure WriteDword(p: pointer); {$ifdef fpc}inline;{$endif}
  procedure ReadDWord(p: pointer); {$ifdef fpc}inline;{$endif}
  procedure SkipDword(); {$ifdef fpc}inline;{$endif}

//resizes the string prior to writing, to align its size to 32-bit boundary.
//  probably, can cause a memory re-allocation call.
  procedure WriteAnsiString(v: AnsiString); {$ifdef fpc}inline;{$endif}

//doesn't need the abovementioned trick, because of the additional
//  trailing zero (PWideChar compatibility). This extra character
//  (two bytes) isn't counted, and in the worst case scenario
//  it'll be all that will be rewritten.
  procedure WriteWideString(v: WideString); {$ifdef fpc}inline;{$endif}

  procedure SkipAnsiString; {$ifdef fpc}inline;{$endif}
  procedure SkipWideString; {$ifdef fpc}inline;{$endif}
  function ReadWideString(): WideString; {$ifdef fpc}inline;{$endif}
  function ReadAnsiString(): AnsiString; {$ifdef fpc}inline;{$endif}
  procedure WriteNil; {$ifdef fpc}inline;{$endif}

  procedure ReadPersistent(var o: TTrulyPersistent); register;
  procedure WritePersistent(o: TTrulyPersistent);


{$include mo_cla_hdr.inc}

implementation

{$include mo_cla_body.inc}

end.
