{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the persistency system essentials.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}


//       "NO USER SERVICEABLE PARTS BELOW THIS POINT"

type
  TFieldKind =
  //do NOT change the order, or the *.cge files will become incompatible!
  (fk_notsupported, fk_binary, fk_integer, fk_float, fk_string, fk_set
    , fk_enum, fk_Class, fk_Dyna, fk_8bit_string, fk_CustomClass, fk_Array);

  TFieldInfo = packed record
    offset: integer;
    name: smallint; //formerly integer;
    HasPP: byte;   //a new field
    Reserved1: byte; //a new field
    Tind: integer;
    Skip: LongBool;
    RFind: integer;
  end;
  PFieldInfo = ^TFieldInfo;

  TTypeRecord = packed record
    name: integer;
    size: integer;
    Info: PTypeInfo;
    Data: PTypeData;
    Proc: TCustomTypeProcessingProc;
    case byte of
      0: (ClassName: Integer;
          _class: CTrulyPersistent;
          Kind: TFieldKind;
          );
      1: (BaseTypeInd, Length: integer;
          );
  end;

  procedure _RegisterField(name: string; Pf: pointer; PI: PTypeInfo; SkipIt: boolean);
  procedure _RegEnum(T: TTypeRecord);
  procedure DieTypeFailed(T: TTypeRecord; reason: string);
  procedure RegBegin(C: TObject);
  procedure RegEnd;
  function ClassIndex(C: TClass): integer;


type
  { TNameSpace }

  TNameSpace = class (TAOS)
  public
    Alias: array of integer;
    function Ind (s: string): integer;
    function Translate(RegNS: TNameSpace): TAOI;
    function Add (s: string): integer; overload; override;
    function Add(s1, s2: string): integer; overload;
  end;

  {$ifdef fpc}
    {$include mo_classes_1_freepascal.h}
  {$else}
    {$include mo_classes_h_1_delphi.inc}
  {$endif}

  //{ TBasket }

  // Basket structure:
  // * Signature (wide string)
  // * Name space
  // * Type names - for type sizes check
  // * Type sizes - see above
  // * Class names
  // * Field lists (per class) - name/type only,
  //            , offset and "skippiness" are stored but not used.
  // * Classes themselves


 // TBasket = class (TAbstractBasket) // "lukoshko"

  procedure LogWarnings();
//  private
  procedure DieInvalidContainer(nng: string);
  procedure DieIncompatible(M: TMessageId; Param: array of Const);
  procedure Parse();

  procedure LoadEnum(tyi: integer; p: pointer);
   //making it "inline"
   // causes a complete . Sorry for my French.
   // Note to self: report as a FreePascal bug.

//  procedure SaveEnum(ti: integer; p: pointer); {$ifdef fpc}inline;{$endif}  //obsolete
  function NumObjects: integer; //_readonum(): integer;//property NumObjects: integer read _readOnum;
//  end;

  { TTrulyPersistentTester }

type
  T2dArrayofDword = array of array of dword;

  TKikimora = array[0..5] of integer;

  TTrulyPersistentTester = class (TTrulyPersistent)
  public
    StubA: string;
    G: TKiKimora;
    StubB: integer;
    StubC: float;
    StubD: TTrulyPersistentTester;
    procedure RegisterFields; override;
  end;

var
  BasketWarnings: TAOW;

(*
   //   This porn must be consistent with the structure of TObject and
   //     the corresponding constants in <FPC sources>/rtl/inc/objpash.inc
   //   Will screw up if the language standard change by adding
   //     any new virtual methods to TObject!}
  const
    vmtMyClassIndex = vmtDefaultHandlerStr + sizeof(pointer);
    vmtMyScenarioIndex = vmtMyClassIndex + sizeof(pointer);
    vmtMyFieldsList = vmtMyScenarioIndex + sizeof(pointer);
    vmtMyLocalFieldsList = vmtMyFieldsList + sizeof(pointer);
    vmtMyLocalClassIndex = vmtMyLocalFieldsList + sizeof(pointer);*)
  var
    vmtMyClassIndex,
    vmtMyScenarioIndex,
    vmtMyFieldsList,
    vmtMyLocalFieldsList,
    vmtMyLocalClassIndex: integer;
   procedure InitializeVmtxxxConsts;

