{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  implementation of the message manager class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}



procedure TMessageContainer.R(mID: TMessageID; mIDstr: AnsiString);
begin
  MS[mID]:=UpperCase(mIDstr);
  E[mID]:='';
end;


destructor TMessageContainer.Destroy;
begin
  inherited;
end;

function TMessageContainer._e(index: TMessageID): WideString;
begin
  Result:=E[index];
end;

function TMessageContainer._ms(index: TMessageID): AnsiString;
begin
  Result:=MS[index]
end;


  procedure TMessageContainer.Load(languageID: AnsiString);
  var
    il: TFileList;
    j, i, k: integer;
    ua: TAOW;
    u: WideString;
    d: TMessageId;
    s: AnsiString;
  begin
    LanguageID:=Uppercase(languageID);
    missing:='';
    il:=nil;
    try
      il:=TFileList.Create(OptiFileName(ModulesBasePath + 'cge/text/*.txt'));
      il.SortByDate;
      if il.Count = 0 then Raise Exception.Create(' ');
    except
      raise Exception.Create('We have no access rights to folder "' + OptiPath(ModulesBasePath + 'cge/text/') + '" or it doesn''t contain any *.txt files');
    end;
    missing:='';
    extra:='';
    For j:=il.Count - 1 downto 0 do begin
      ua:=LoadUnicodeText(il.Names[j]);
      For k:=0 to ua.High do ua[k]:=TrimWideString(ua[k]);
      k:=0;
      While k <= ua.High do begin
        if (ua[k] <> '') and (ua[k][1] = _AnsiToUniTable['#']) then begin
          s:=WideToAnsi(ua[k]);
          s:=UpperCase(Copy(s, 2, Length(s) - 1));
          i:=0;
          While i <= ord(High(TMessageId)) do begin
            if MS[TMessageId(i)] = s then begin
              inc(k);
              While (k <= ua.High) and (UpperCase(WideToAnsi(ua[k])) <> '~'+LanguageID) do inc(k);
              if k > ua.High then Break;
              inc(k);
              if k > ua.High then Break;
              u:=ua[k];
              inc(k);
              while (k < ua.High) do begin
                if (ua[k]<>'') and (ua[k][1] = _AnsiToUniTable['~']) then Break;
                if (ua[k]<>'') and (ua[k][1] = _AnsiToUniTable['#']) then begin
                  dec(k);
                  Break;
                end;
                if (ua[k]<>'') and (ua[k][1] <> _AnsiToUniTable[';']) then begin
                  u:=u + #10#13;
                  u:=u + ua[k];
                end;
                inc(k);
              end;
              if (E[TMessageId(i)]='') then E[TMessageId(i)]:=u;
              Break;
            end;
            inc(i);
          end;
          if i > ord(High(TMessageId)) then extra:=extra + '  ' + s;
        end;
        inc(k);
      end;
      ua.Free;
    end;
    il.Free;
    For d:=Low(TMessageId) to High (TMessageId) do
      if (E[d]='') and (d <> MI_CORE_MIDs_END)
        then missing:=missing + MS[d] + '  ';
 end;

procedure TMessageContainer.Reload(languageID: AnsiString);
var d: TMessageId;
begin
//  For
end;

constructor TMessageContainer.Create(languageID: AnsiString);
var
  i: TMessageId;
  subLang, Sn: string;
  strict: boolean;
  ti: PTypeInfo;
begin
  inherited Create;
  //try
    LID:=UpperCase(languageID);
    sublang:=Config.Str[LID, 'SubstituteLanguage'];
    strict:=Config.Bool[LID, 'StrictMessageChecks'];
    ti:=TypeInfo(TMessageId);
    i:=MI_CGE_TITLE;
    while i < MI_CORE_MIDs_END do begin
      Sn:=GetEnumName(ti, Ord(i));
      Sn:=Copy(Sn, 4, Length(Sn) - 3);
      R(i, Sn);
      inc(i);
    end;
    extra:='';
    Load(LID);
    if (missing <> '') and (not strict) and (subLang <>'') then Load(sublang);
    if missing <> '' then missing:=PIYMIssingMIDS + PIYLang +  LID + '": '#10#13 + missing;
    if extra <> '' then
      if missing <> ''
        then extra:=PIYExtraMIDsShort + extra
        else extra:=PIYExtraMIDs + PIYLang +  LID + '": '#10#13 + extra;
    if (missing <>'') or (extra <>'')
      then PreInitDie(PIYMesManCrash + missing + extra);
 { except
    if ExceptObject is Exception
      then PreInitDie('Program crashed at initialization of message manager with exception "'+ (ExceptObject as Exception).Message+'" at address '+ IntToHex(cardinal(ExceptAddr),8))
      else PreInitDie('Program crashed at initialization of message manager because of invalid operation at address ' + IntToHex(cardinal(ExceptAddr),8));
  end;}
end;
