{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains class for reading/writing *.tar.gz archives.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$mode delphi}
{$macro on}

unit cl_tar_gz;

interface

uses
  Classes, SysUtils; 
  
type
  TTarChunkHeader = class;
  TTarSubfile = class;
  TTarFile = class(TStream)
  
  
  end;

implementation

type
  TarHeaderRecord = packed record
    NameLow: array[0..99] of AnsiChar;
    Stub1: array[0..23] ob byte; //mode, user id, group id - not supported in Windows
    Size: array[0..11] of AnsiChar;
    ModifyTime: array[0..12] of AnsiChar;
    Checksum: array[0..7] of AnsiChar;
    Typeflag: AnsiChar;
    Linkname: array[0..99] of AnsiChar;
    UstarMagick: array[0..5] of AnsiChar;
    UstarVersion: array[0..1] of AnsiChar;
    Stub2: array[0..79] of AnsiChar; //user name, group name, device number
    NameHigh: array[0..154] of AnsiChar;
  end;
  
  TTarChunkHeader = class
  private
    rec: TarHeaderRecord;
  public
  
  end;


end.

