{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  exception explaining routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

  {$ifdef win32} 
  //function VirtualQuery(adr, buffer: LPCVOID; dwLength:DWORD):DWORD; external 'kernel32' name 'VirtualQuery';
  {$endif}




(*
  function ToldMemRgn(ptr: pointer): WideString;
 
 {$IFNDEF WIN32}
  begin
    Result:=AnsiToWide('ChebLib''s tale-telling memory regions is implemented only for 32-bit Micro$oft Windows.');
  end;
 {$ELSE WIN32}
  var
    S: WideString;
    mm, ml, mr: _MEMORY_BASIC_INFORMATION;
    A: CARDINAL;

    function DescMemProp(AB, Protect, State, _Type: integer): WideString;
    var TST: array[0..Max_Path] of char;
    begin
      Case State of
       MEM_RESERVE: Result:=MessageContainer[MI_ET_MEM_RESERVE];
       MEM_FREE: Result:=MessageContainer[MI_ET_MEM_FREE];
       MEM_COMMIT: begin
          if GetModuleFileName(THandle(AB), TST, SizeOf(TST)) <> 0 then
            Result:=PervertedFormat(MessageContainer[MI_ET_MEM_COMMIT], [ExtractFileName(PChar(@TST))]);
          If (_Type <> MEM_PRIVATE) then
            Result:=PervertedFormat(MessageContainer[MI_ET_MEM_SHARED], [Result]);
          If (Protect and PAGE_NOCACHE > 0) then
            Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_NOCACHE], [Result]);
          If (Protect and PAGE_GUARD > 0) then
            Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_GUARD], [Result]);
          Protect:= Protect and not (PAGE_NOCACHE + PAGE_GUARD);
          case Protect of
            PAGE_READONLY: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_READONLY], [Result]);//S:=s+'    ';
            PAGE_READWRITE: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_READWRITE], [Result]);//S:=s+'  ';	// Enables both read and write access to the committed region of pages.
            PAGE_WRITECOPY: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_WRITECOPY], [Result]);//S:=s+',    ,      (copy-on-write)';	// Gives copy-on-write access to the committed region of pages.
            PAGE_EXECUTE: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_EXECUTE], [Result]);//S:=s+'  ,    ';	// Enables execute access to the committed region of pages. An attempt to read or write to the committed region results in an access violation.
            PAGE_EXECUTE_READ: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_EXECUTE_READ], [Result]);//S:=s+' ';	// Enables execute and read access to the committed region of pages. An attempt to write to the committed region results in an access violation.
            PAGE_EXECUTE_READWRITE: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_EXECUTE_READWRITE], [Result]);//S:=s+'  '; //	Enables execute, read, and write access to the committed region of pages.
            PAGE_EXECUTE_WRITECOPY: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_EXECUTE_WRITECOPY], [Result]);//S:=s+',    ,      (copy-on-write),     ';
                                //	Enables execute, read, and write access to the committed region of pages. The pages are shared read-on-write and copy-on-write.
            PAGE_NOACCESS: Result:=PervertedFormat(MessageContainer[MI_ET_PAGE_NOACCESS], [Result]);//S:=s+'  '; //	Disables all access to the committed region of pages. An attempt to read from, write to, or execute in the committed region
                                                        //results in an access violation exception, called a general protection (GP) fault.
          else
            result:=PervertedFormat(MessageContainer[MI_ET_UNKNOWN_ACCESS], [Result]);//S:=S+'  !';
          end;
        end;
      end;
    end;
  begin
    Result:='';
    A:=cardinal(ptr);
    if VirtualQuery(Pointer(A), @mm, SizeOf(mm)) <> SizeOf(mm)then Exit;
    {if (cardinal(mm.BaseAddress) >= 0) then}
      if VirtualQuery(Pointer(cardinal(mm.BaseAddress)-1), @ml, SizeOf(ml))
      = SizeOf(ml)
      then
        Result:=PervertedFormat(AnsiToWide('%0h..%1h (%2K) - %3;'#10#13),
          [IntToHex(Cardinal(ml.BaseAddress),8),
           IntToHex(Cardinal(ml.BaseAddress)+ ml.RegionSize-1,8),
           ml.RegionSize div 1024,
           DescMemProp(cardinal(ml.AllocationBase), ml.Protect,ml.State, ml._Type) ]);
    Result:=Result + '%0h..%1h (%2K) - %3;'#10#13;
    PervertedFormat(Result,
          [IntToHex(Cardinal(mm.BaseAddress),8),
           IntToHex(Cardinal(mm.BaseAddress)+ mm.RegionSize-1,8),
           mm.RegionSize div 1024,
           DescMemProp(cardinal(mm.AllocationBase),mm.Protect, mm.State, mm._Type) ]);
    if (cardinal(mm.BaseAddress) - 1 + mm.RegionSize  < $FFFFFFFE) then
      if VirtualQuery(Pointer(cardinal(mm.BaseAddress) + mm.RegionSize), @mr, SizeOf(mr)) = SizeOf(mr)
      then begin
        Result:=Result + '%0h..%1h (%2K) - %3;'#10#13;
        PervertedFormat(Result,
          [IntToHex(Cardinal(mr.BaseAddress),8),
           IntToHex(Cardinal(mr.BaseAddress)+ mr.RegionSize-1,8),
           mr.RegionSize div 1024,
           DescMemProp(cardinal(mr.AllocationBase), mr.Protect,mr.State,mr._Type)] );
      end;
    Result:=Result + '.';
  end;
 {$ENDIF WIN32}
  *)

 {$IFDEF WIN32}
const
  //oops.. missing in the FreePascal RTL..
  EXCEPTION_IN_PAGE_ERROR = $C0000006;
  EXCEPTION_ILLEGAL_INSTRUCTION = $C000001D;
 {$ENDIF WIN32}


  function ToldException(E: Exception): WideString;
  var
    S, A: String;
    AU, tr: WideString;
   {$IFDEF WIN32}
    TST: array[0..Max_Path] of char;
    EA: pointer;
    Tmm: TMemoryBasicInformation;
   {$ENDIF}
  begin
    //yeah, yeah. No detailed information for exceptions under Linux yet.
    Result:='';
    If not (E is Exception) then Exit;
   If E is EAbstractERROR then begin
     Result:=MessageContainer[MI_EABSTRACT_EXPLAIN];
   end
   else begin

    {$IFDEF WIN32} (*
    if E is EExternal then begin
Dbgsay('**');
      if (VirtualQuery(pointer(EExternal(E).ExceptionRecord^.ExceptionAddress), @Tmm, SizeOf(Tmm)) = SizeOf(Tmm))
      then begin
        IF (Tmm.State = MEM_COMMIT) then begin
          if (GetModuleFileName(THandle(Tmm.AllocationBase), TST, SizeOf(TST))<>0)
          then A:=PChar(@TST)
          else A:=ParamStr(0);
          AU:=PervertedFormat(MessageContainer[MI_ET_IN_MODULE],[A])
        end
        else
          AU:=MessageContainer[MI_ET_AT_NON_EXISTENT_ADDRESS];
      end
      else begin
        AU:=PervertedFormat(MessageContainer[MI_ET_IN_UNKNOWN_MODULE],[AU]);
      end;
      case EExternal(E).ExceptionRecord^.ExceptionCode of
        EXCEPTION_ACCESS_VIOLATION: begin
          Result:=PervertedFormat(MessageContainer[MI_ET_EXCEPTION_ACCESS_VIOLATION],[AU]);
          EA:=pointer(EExternal(E).ExceptionRecord^.ExceptionInformation[1]);
          if EExternal(E).ExceptionRecord^.ExceptionInformation[0] = 0
          then
            Result:=PervertedFormat(MessageContainer[MI_ET_O_READING],[Result])
          else
            Result:=PervertedFormat(MessageContainer[MI_ET_O_WRITING],[Result]);
          if EA >= pointer($FFFFFFFC)
          then
            Result:=PervertedFormat(MessageContainer[MI_ET_BEYOND_ADDR_SPACE], [Result])
          else begin
            Tr:=ToldMemRgn(EA);
            if not Empty(Tr) then
              Result:=PervertedFormat(MessageContainer[MI_ET_AT_ADDR_PLUS_TOLD_MR],[Result, EA, Tr])
            Else
              Result:=PervertedFormat(MessageContainer[MI_ET_AT_INVALID_ADDRESS], [Result, EA]);
          end;
        end;
        EXCEPTION_IN_PAGE_ERROR:
          Result:=PervertedFormat(MessageContainer[MI_ET_EXCEPTION_IN_PAGE_ERROR],[AU]);
        EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
          Result:=PervertedFormat(MessageContainer[MI_ET_EXCEPTION_ARRAY_BOUNDS_EXCEEDED],[AU]);
        EXCEPTION_STACK_OVERFLOW:
          Result:=PervertedFormat(MessageContainer[MI_ET_EXCEPTION_STACK_OVERFLOW],[AU]);
        EXCEPTION_ILLEGAL_INSTRUCTION:
          Result:=PervertedFormat(MessageContainer[MI_ET_EXCEPTION_ILLEGAL_INSTRUCTION],[AU]);
        else
          Result:=AnsiToUni(E.Message);
      end;
Dbgsay('>>>');
    end
    else  *)
      Result:=PervertedFormat(MessageContainer[MI_SIMPLE_EXCEPTION_TALE], [trim(E.ClassName), AnsiToWide(E.Message)]);
   {$ELSE WIN32}
      Result:=PervertedFormat(MessageContainer[MI_SIMPLE_EXCEPTION_TALE], [trim(E.ClassName), AnsiToWide(E.Message)]);
   {$ENDIF WIN32}
   end;
  end;

