{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the splash screen handling routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$ifdef fpc}
  {$mode delphi}
{$endif}  

unit cl_splashscreen;

//  -,   ,   WinAPI.
//-    ,     (.. BMP)
//   ,   
                                            //   

interface
Uses SysUtils, {$IFDEF WIN32} Windows, {$ENDIF} Classes;

Procedure CreateSplashWindow;
procedure ResetSplashWindow;
procedure KillSplashWindow;

implementation
uses cl_hub;

//NOTE: THE SPLASH SCREEN FOR UNIX IS AN STANDALONE LAZARUS APPLIOCATION!

{$IFDEF UNIX}

Type
  TSplashThread = class(TThread);
  protected
    procedure Execute; override;
  end;
Var
  SplashThread: TSplashThread;

  procedure TSplashThread.Execute;
  begin
    ExecuteProcess(
       Config.Path['splashscreen','UnixAppPath'] + 'splash', [
       Config.Path['splashscreen','path'] + 'splash'+ IntToStr(random(Config['splashscreen','numvariants'])) + '.bmp',
       Config.Path['splashscreen','UnixMutexPath'] + 'splashmutex']);
  end;
  

Procedure CreateSplashWindow;
var f: file;
begin
  AssignFile(f, Config.Path['splashscreen','UnixMutexPath'] + 'splashmutex']);
  Rewrite(f);
  CloseFile(f);
  SplashThread:=TSplashThread.Create(false);
end;

procedure KillSplashWindow;
var f: file;
begin
  Try
    AssignFile(f, Config.Path['splashscreen','UnixMutexPath'] + 'splashmutex']);
    Erase(f);
    if Assigned(SplashThread) then SplashThread.Terminate;
    SplashThread:=nil;
  Except End;
end;

procedure ResetSplashWindow;
begin
  //stub
end;


{$ELSE}
{$IFDEF WIN32}
    var
      h_DC : HDC;
      exists: boolean = false;
      WindowHandle, BitmapHandle: THandle;
      width, height: integer;
      _pic: string = '';


    Procedure DrawSplash;
    var
      BM: Tbitmap;
      hdcMem: HDC;
      hbmOld: HBitmap;
      ps: TPaintStruct;
    begin
       h_dc:=BeginPaint(WindowHandle, ps);
       hdcMem:= CreateCompatibleDC(h_dc);
       hbmOld:= SelectObject(hdcMem, BitmapHandle);
       GetObject(BitmapHandle, sizeof(bm), @bm);
       BitBlt(h_dc, 0,0, bm.bmWidth, bm.bmHeight, hdcMem, 0, 0, SRCCOPY);
       SelectObject(hdcMem, hbmOld);
       DeleteDC(hdcMem);
       EndPaint(WindowHandle, ps);
    end;

 {$ifndef fpc}
  Const
    WM_PAINT = 15;
 {$endif}

    function WndProc(hWnd: HWND; Msg: UINT;  wParam: WPARAM;  lParam: LPARAM): LRESULT; stdcall;
    begin
      if Msg = wm_paint then begin
        DrawSplash;
      end
      else
        Result := DefWindowProc(hWnd, Msg, wParam, lParam);    // Default result if nothing happens
    end;


    Procedure ProcessMessages;
    var msg: TMsg;
    begin
      While PeekMessage(msg, 0, 0, 0, PM_REMOVE) do
      begin
        TranslateMessage(msg);
        DispatchMessage(msg);
      end;
    end;

    var r: integer = -1;

  Procedure CreateSplashWindow;
  var
    wndClass : TWndClass;
    dwStyle : DWORD;
    dwExStyle : DWORD;
    xpos, ypos: integer;
    BM: TBitmap;
    t: integer;
  begin
    //if DeveloperMode or DebugMode then Exit;
    VerboseLog('Creating splash screen...');
    if r < 0 then r:=random(Config['splashscreen','numvariants']);
    if _pic='' then _pic:=Config.Path['splashscreen','path'] + 'splash'+IntToStr(r)+'.bmp';
    BitmapHandle:=LoadImage(0, PChar(_pic), IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
    if BitmapHandle=0 then exit;
    GetObject(BitmapHandle, sizeof(bm), @bm);
    width:=bm.bmWidth;
    height:=bm.bmHeight;
    xpos:=(GetSystemMetrics(SM_CXSCREEN) - width) div 2;
    ypos:=(GetSystemMetrics(SM_CYSCREEN) - height) div 2;
    ZeroMemory(@wndClass, SizeOf(wndClass));
    with wndClass do
    begin
      style:= CS_HREDRAW or CS_VREDRAW or CS_OWNDC;
      lpfnWndProc   := @WndProc;
      hInstance     := {$ifdef fpc}System.HInstance{$else}SysInit.HInstance{$endif};
      lpszClassName := PChar(AppNick+'_Splash_WND');
    end;
    if (Windows.RegisterClass(wndClass) = 0) then exit;
    dwStyle := WS_POPUP;
    dwExStyle := WS_EX_TOPMOST + WS_EX_TOOLWINDOW;
    WindowHandle:= CreateWindowEx(dwExStyle, PChar(AppNick+'_Splash_WND'), //   
      PChar('CGE'), dwStyle, xpos, ypos, Width, Height, 0, 0, hInstance, nil);
    if WindowHandle = 0 then exit;
    exists:=true;
    SetWindowPos(WindowHandle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW or SWP_NOACTIVATE);
    t:=GetTickCount;
    repeat ProcessMessages until GetTickCount - t > 100;
  end;

  procedure KillSplashWindow;
  begin
    if not exists then exit;
    DestroyWindow(WindowHandle);
    Windows.UnRegisterClass(PChar(AppNick+'_Splash_WND'), hInstance);
    exists:=false;
  end;

  procedure ResetSplashWindow;
  begin
    if not exists then exit;
    KillSplashWindow;
    CreateSplashWindow;
  end;

{$ENDIF}
{$ENDIF}

end.
