{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the picture codec classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
unit cl_piccodec;

interface

uses un_typedefs, Classes, cl_container;

  Type TImageCodec = class
    Procedure PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode); VIRTUAL; ABSTRACT;

    Procedure Decode(OutBuff: Pointer); VIRTUAL; ABSTRACT;
    //Output buffer must be allocated by the caller!
  
  Procedure Encode(Output: TContainer; Image: pointer; width, height: integer; mode: TImageMode); VIRTUAL; ABSTRACT;
  protected
    FMode: TImageMode;
    FHeight, FWidth: integer;
  protected
    _In: TContainer;
  end;


  TTgaCodec = class(TImageCodec)
    Procedure PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode); OVERRIDE;
    Procedure Decode(OutBuff: Pointer); OVERRIDE;
  end;
  
  TBmpCodec = class(TImageCodec)
    Procedure PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode); OVERRIDE;
    Procedure Decode(OutBuff: Pointer); OVERRIDE;
  end;

  TPcxCodec = class(TImageCodec)
    Procedure PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode); OVERRIDE;
    Procedure Decode(OutBuff: Pointer); OVERRIDE;
  end;
  
  TLbmCodec = class(TImageCodec)
    Procedure PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode); OVERRIDE;
    Procedure Decode(OutBuff: Pointer); OVERRIDE;
  end;

implementation

Procedure TTgaCodec.PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode);
begin

end;


Procedure TTgaCodec.Decode(OutBuff: Pointer);
begin

end;



Procedure TPcxCodec.PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode);
begin

end;


Procedure TPcxCodec.Decode(OutBuff: Pointer);
begin

end;

Procedure TLbmCodec.PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode);
begin

end;


Procedure TLbmCodec.Decode(OutBuff: Pointer);
begin

end;

Procedure TBmpCodec.PrepareToDecode(Input: TContainer; var width, height: integer; var mode: TImageMode);
begin

end;

Procedure TBmpCodec.Decode(OutBuff: Pointer);
begin

end;

end.
