{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains thr page allocation code.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{
    Memory allocation by whole virtual pages, Win32 platform.
}

 unit un_page_malloc;
 interface
   uses
     SysUtils
     {$ifdef win32}
     ,Windows
     {$endif}
     ;
 
   function PM_GetMem(size: integer): pointer;
   procedure PM_FreeMem(p: pointer);
 
 
 implementation
  {$ifdef win32}
    var PageIndex: array [0..$1FFFF] of Cardinal; //bit flags array
  {$endif}

//function VirtualAlloc(lpAddress:LPVOID; dwSize:DWORD; flAllocationType:DWORD; flProtect:DWORD):LPVOID; external 'kernel32' name 'VirtualAlloc';
//function VirtualFree(lpAddress:LPVOID; dwSize:DWORD; dwFreeType:DWORD):WINBOOL; external 'kernel32' name 'VirtualFree';


   function PM_GetMem(size: integer): pointer;
   {$ifdef win32}
   var
     pi, pbi: cardinal;
   {$endif}
   begin
     {$ifdef win32}
     if size = 4096 then begin
       Result:=VirtualAlloc(nil, 1, MEM_COMMIT, PAGE_READWRITE);
       dword(Result^):=0; //access it once, forcing system to allocate actual physical storage
       pi:=cardinal(Result) shr (12 + 5); //4096 bytes per page, 32 pzge states per array element
       pbi:=(cardinal(Result) shr 12) - (pi shl 5); //bit index
       PageIndex[pi] := PageIndex[pi] or (1 shl pbi);
       Exit;
     end;
     {$endif}
     Result:=GetMem(size);
   end;
   
   procedure PM_FreeMem(p: pointer);
   {$ifdef win32}
   var
     pi, pbi: cardinal;
     pp: pointer
   {$endif}
   begin
     {$ifdef win32}
     if (cardinal(p) shr 12) shl 12 = cardinal(p) //aligned to page
     then begin
       pi:=cardinal(Result) shr (12 + 5); //4096 bytes per page, 32 pzge states per array element
       pbi:=(cardinal(Result) shr 12) - (pi shl 5); //bit index
       if (PageIndex[pi] and (1 shl pbi)) > 0  then begin
         VirtualFree(p, 1, MEM_FREE);
         Exit
       end;
     end;
     {$endif}
     FreeMem(p);
   end;
 
{$ifdef win32}
   var i, j: integer;
 initialization
   FillChar(PageIndex, SizeOf(PageIndex), 0);
 finalization
   For i:=0 to $1FFFF do
     if PageIndex[i] > 0 then begin
       For j:=0 to 31 do
         if PageIndex[i] and (1 shl j) > 0
           then VirtualFree(pointer((i shl (12 + 5)) + (j shl 12)), 1, MEM_FREE);
     end;
{$endif}
 end.
 
 
