{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the classes for working with the pack files.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

unit cl_packfile;

{$mode delphi}

//now it is just a stub, to allow to easily add support
// for modules in packed format in the future

interface

uses
  Classes, SysUtils, cl_filelist, cl_typedefs;

Type
  TPackFile = class
  protected
    FList: TStringList;
  public
    property List: TStringList read Flist;
    function OpenFile(name: string): TStream; virtual; abstract;
  end;
  
  { TDirPack }

  TDirPack = class(TPackFile)
  protected
    FBasePath: string;
  public
    Constructor Create(path, name: string);
    Destructor Destroy; override;
    function OpenFile(name: string): TStream; override;
  end;
  
  { TRealPack }

  TRealPack = class(TPackFile)
    Constructor Create(path, name: string);
    //put GZ stuff 'ere.
  end;

implementation

{ TDirPack }

constructor TDirPack.Create(path, name: string);
var
  L: TFullFileList;
  c: integer;
begin
  FBasePath:=path + slash + name + slash;
  L:=TFullFileList.Create(FBasePath);
  L.SortByName;
  FList:=TStringList.Create;
  For c:=0 to L.Count - 1 do
    FList.Add(L.RelativeNames[c]);
  L.Free;
end;

destructor TDirPack.Destroy;
begin
  FList.Free;
  inherited Destroy;
end;

function TDirPack.OpenFile(name: string): TStream;
begin
  Result:=TFileStream.Create(FBasePath + name, fmOpenRead);
end;

{ TRealPack }

constructor TRealPack.Create(path, name: string);
begin
  //&&&&&&&&
end;

end.

