{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains classes for working with files.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

 {$longstrings on}
unit cl_file_io;

interface
uses
  SysUtils, un_typedefs, classes;

Type
  //currently a stub, but this one will HANDLE ALL ERROR MESSAGES (using ty..except..die blocks).

  { TCGEStream }

  TCGEStream = class (TFileStream)


  public
    Constructor CreateForRead(name: AnsiString);
    Constructor CreateForWrite(name: AnsiString);
  end;


implementation
uses cl_hub;
{ TCGEStream }

{     procedure DiePack(name, packname: ansistring);
     begin
       Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['CGE v.'+VersionString+' doesn''t yet support the pack files! (name "'+name+'", pack "'+PackName+'")']);
     end;
}
  constructor TCGEStream.CreateForRead(name: AnsiString);
  begin
    if FileExists(StartDir + name)
      then inherited Create(StartDir + name, fmOpenRead)
      else Die(MI_ERROR_FILE_NOT_FOUND, [name]);
  end;

  constructor TCGEStream.CreateForWrite(name: AnsiString);
  begin
    inherited Create(StartDir + name, fmCreate);
  end;

end.
