// THIS FILE IS GENERATED AUTOMATICALLY,
// DO NOT EDIT IT!
// Make your modifications to "cl_dyna_freepascal.inc" ,
//   then run ConvertForDelphi.exe
//
//
//
{$define cl_stringtype}

 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOS = Class(TDyna)
    Function Add(i: string): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of string
    {$endif};
    function _Read(ind: cardinal): string;
    procedure _Write(ind: cardinal; p: string);
    function _ReadDPTR: pointer; override;
    function _ReadLast: string;
    procedure _WriteLast(p: string);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:string read _Read write _Write; DEFAULT;
    property Last:string read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOS.Add(i: string):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOS.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOS._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOS._Read(ind: cardinal): string;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=string(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOS._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOS._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOS._ReadLast: string;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= string(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOS._Write(ind: cardinal; p: string);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOS._WriteLast(p: string);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOS = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOS;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOS;
    procedure _Write(ind: cardinal; p: TAOS);
    function _ReadLast: TAOS;
    procedure _WriteLast(z: TAOS);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOS read _Read write _Write; DEFAULT;
    property Last:TAOS read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOS._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOS._Read(ind: cardinal): TAOS;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOS(a[ind]);
end;

procedure T2DAOS._Write(ind: cardinal; p: TAOS);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOS._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOS(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOS.Create);
//WriteLn('*** 3');
end;

function T2DAOS._ReadLast: TAOS;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOS(a[s-1]);
end;

procedure T2DAOS._WriteLast(z: TAOS);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOS.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOS.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOW = Class(TDyna)
    Function Add(i: WideString): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of WideString
    {$endif};
    function _Read(ind: cardinal): WideString;
    procedure _Write(ind: cardinal; p: WideString);
    function _ReadDPTR: pointer; override;
    function _ReadLast: WideString;
    procedure _WriteLast(p: WideString);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:WideString read _Read write _Write; DEFAULT;
    property Last:WideString read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOW.Add(i: WideString):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOW.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOW._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOW._Read(ind: cardinal): WideString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=WideString(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOW._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOW._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOW._ReadLast: WideString;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= WideString(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOW._Write(ind: cardinal; p: WideString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOW._WriteLast(p: WideString);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOW = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOW;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOW;
    procedure _Write(ind: cardinal; p: TAOW);
    function _ReadLast: TAOW;
    procedure _WriteLast(z: TAOW);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOW read _Read write _Write; DEFAULT;
    property Last:TAOW read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOW._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOW._Read(ind: cardinal): TAOW;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOW(a[ind]);
end;

procedure T2DAOW._Write(ind: cardinal; p: TAOW);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOW._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOW(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOW.Create);
//WriteLn('*** 3');
end;

function T2DAOW._ReadLast: TAOW;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOW(a[s-1]);
end;

procedure T2DAOW._WriteLast(z: TAOW);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOW.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOW.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


  {$undef cl_stringtype}

 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOF = Class(TDyna)
    Function Add(i: float): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of float
    {$endif};
    function _Read(ind: cardinal): float;
    procedure _Write(ind: cardinal; p: float);
    function _ReadDPTR: pointer; override;
    function _ReadLast: float;
    procedure _WriteLast(p: float);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:float read _Read write _Write; DEFAULT;
    property Last:float read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOF.Add(i: float):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOF.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOF._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOF._Read(ind: cardinal): float;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=float(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOF._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOF._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOF._ReadLast: float;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= float(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOF._Write(ind: cardinal; p: float);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOF._WriteLast(p: float);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOF = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOF;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOF;
    procedure _Write(ind: cardinal; p: TAOF);
    function _ReadLast: TAOF;
    procedure _WriteLast(z: TAOF);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOF read _Read write _Write; DEFAULT;
    property Last:TAOF read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOF._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOF._Read(ind: cardinal): TAOF;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOF(a[ind]);
end;

procedure T2DAOF._Write(ind: cardinal; p: TAOF);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOF._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOF(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOF.Create);
//WriteLn('*** 3');
end;

function T2DAOF._ReadLast: TAOF;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOF(a[s-1]);
end;

procedure T2DAOF._WriteLast(z: TAOF);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOF.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOF.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOP = Class(TDyna)
    Function Add(i: pointer): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of pointer
    {$endif};
    function _Read(ind: cardinal): pointer;
    procedure _Write(ind: cardinal; p: pointer);
    function _ReadDPTR: pointer; override;
    function _ReadLast: pointer;
    procedure _WriteLast(p: pointer);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:pointer read _Read write _Write; DEFAULT;
    property Last:pointer read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOP.Add(i: pointer):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOP.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOP._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOP._Read(ind: cardinal): pointer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=pointer(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOP._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOP._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOP._ReadLast: pointer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= pointer(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOP._Write(ind: cardinal; p: pointer);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOP._WriteLast(p: pointer);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOP = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOP;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOP;
    procedure _Write(ind: cardinal; p: TAOP);
    function _ReadLast: TAOP;
    procedure _WriteLast(z: TAOP);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOP read _Read write _Write; DEFAULT;
    property Last:TAOP read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOP._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOP._Read(ind: cardinal): TAOP;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOP(a[ind]);
end;

procedure T2DAOP._Write(ind: cardinal; p: TAOP);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOP._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOP(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOP.Create);
//WriteLn('*** 3');
end;

function T2DAOP._ReadLast: TAOP;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOP(a[s-1]);
end;

procedure T2DAOP._WriteLast(z: TAOP);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOP.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOP.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOC = Class(TDyna)
    Function Add(i: cardinal): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of cardinal
    {$endif};
    function _Read(ind: cardinal): cardinal;
    procedure _Write(ind: cardinal; p: cardinal);
    function _ReadDPTR: pointer; override;
    function _ReadLast: cardinal;
    procedure _WriteLast(p: cardinal);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:cardinal read _Read write _Write; DEFAULT;
    property Last:cardinal read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOC.Add(i: cardinal):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOC.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOC._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOC._Read(ind: cardinal): cardinal;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=cardinal(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOC._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOC._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOC._ReadLast: cardinal;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= cardinal(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOC._Write(ind: cardinal; p: cardinal);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOC._WriteLast(p: cardinal);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOC = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOC;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOC;
    procedure _Write(ind: cardinal; p: TAOC);
    function _ReadLast: TAOC;
    procedure _WriteLast(z: TAOC);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOC read _Read write _Write; DEFAULT;
    property Last:TAOC read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOC._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOC._Read(ind: cardinal): TAOC;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOC(a[ind]);
end;

procedure T2DAOC._Write(ind: cardinal; p: TAOC);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOC._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOC(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOC.Create);
//WriteLn('*** 3');
end;

function T2DAOC._ReadLast: TAOC;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOC(a[s-1]);
end;

procedure T2DAOC._WriteLast(z: TAOC);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOC.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOC.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOI = Class(TDyna)
    Function Add(i: integer): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of integer
    {$endif};
    function _Read(ind: cardinal): integer;
    procedure _Write(ind: cardinal; p: integer);
    function _ReadDPTR: pointer; override;
    function _ReadLast: integer;
    procedure _WriteLast(p: integer);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:integer read _Read write _Write; DEFAULT;
    property Last:integer read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOI.Add(i: integer):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOI.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOI._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOI._Read(ind: cardinal): integer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=integer(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOI._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOI._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOI._ReadLast: integer;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= integer(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOI._Write(ind: cardinal; p: integer);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOI._WriteLast(p: integer);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOI = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOI;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOI;
    procedure _Write(ind: cardinal; p: TAOI);
    function _ReadLast: TAOI;
    procedure _WriteLast(z: TAOI);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOI read _Read write _Write; DEFAULT;
    property Last:TAOI read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOI._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOI._Read(ind: cardinal): TAOI;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOI(a[ind]);
end;

procedure T2DAOI._Write(ind: cardinal; p: TAOI);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOI._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOI(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOI.Create);
//WriteLn('*** 3');
end;

function T2DAOI._ReadLast: TAOI;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOI(a[s-1]);
end;

procedure T2DAOI._WriteLast(z: TAOI);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOI.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOI.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}

  
 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOB = Class(TDyna)
    Function Add(i: longbool): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of longbool
    {$endif};
    function _Read(ind: cardinal): longbool;
    procedure _Write(ind: cardinal; p: longbool);
    function _ReadDPTR: pointer; override;
    function _ReadLast: longbool;
    procedure _WriteLast(p: longbool);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:longbool read _Read write _Write; DEFAULT;
    property Last:longbool read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOB.Add(i: longbool):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOB.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOB._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOB._Read(ind: cardinal): longbool;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=longbool(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOB._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOB._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOB._ReadLast: longbool;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= longbool(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOB._Write(ind: cardinal; p: longbool);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOB._WriteLast(p: longbool);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOB = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOB;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOB;
    procedure _Write(ind: cardinal; p: TAOB);
    function _ReadLast: TAOB;
    procedure _WriteLast(z: TAOB);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOB read _Read write _Write; DEFAULT;
    property Last:TAOB read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOB._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOB._Read(ind: cardinal): TAOB;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOB(a[ind]);
end;

procedure T2DAOB._Write(ind: cardinal; p: TAOB);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOB._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOB(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOB.Create);
//WriteLn('*** 3');
end;

function T2DAOB._ReadLast: TAOB;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOB(a[s-1]);
end;

procedure T2DAOB._WriteLast(z: TAOB);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOB.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOB.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOI64 = Class(TDyna)
    Function Add(i: int64): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of int64
    {$endif};
    function _Read(ind: cardinal): int64;
    procedure _Write(ind: cardinal; p: int64);
    function _ReadDPTR: pointer; override;
    function _ReadLast: int64;
    procedure _WriteLast(p: int64);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:int64 read _Read write _Write; DEFAULT;
    property Last:int64 read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOI64.Add(i: int64):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOI64.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOI64._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOI64._Read(ind: cardinal): int64;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=int64(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOI64._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOI64._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOI64._ReadLast: int64;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= int64(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOI64._Write(ind: cardinal; p: int64);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOI64._WriteLast(p: int64);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOI64 = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOI64;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOI64;
    procedure _Write(ind: cardinal; p: TAOI64);
    function _ReadLast: TAOI64;
    procedure _WriteLast(z: TAOI64);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOI64 read _Read write _Write; DEFAULT;
    property Last:TAOI64 read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOI64._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOI64._Read(ind: cardinal): TAOI64;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOI64(a[ind]);
end;

procedure T2DAOI64._Write(ind: cardinal; p: TAOI64);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOI64._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOI64(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOI64.Create);
//WriteLn('*** 3');
end;

function T2DAOI64._ReadLast: TAOI64;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOI64(a[s-1]);
end;

procedure T2DAOI64._WriteLast(z: TAOI64);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOI64.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOI64.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}


{$define cl_objecttype}
 
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAOO = Class(TDyna)
    Function Add(i: TObject): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of TObject
    {$endif};
    function _Read(ind: cardinal): TObject;
    procedure _Write(ind: cardinal; p: TObject);
    function _ReadDPTR: pointer; override;
    function _ReadLast: TObject;
    procedure _WriteLast(p: TObject);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:TObject read _Read write _Write; DEFAULT;
    property Last:TObject read _ReadLast write _WriteLast;
  End;

{$else header}

function TAOO.Add(i: TObject):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAOO.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAOO._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAOO._Read(ind: cardinal): TObject;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=TObject(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAOO._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAOO._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAOO._ReadLast: TObject;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= TObject(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAOO._Write(ind: cardinal; p: TObject);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAOO._WriteLast(p: TObject);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}


{$ifdef header}
  T2DAOO = Class(TDyna)
    procedure SetRect(z, b: integer); OVERRIDE;
    procedure ClearMem; OVERRIDE;
  Protected
    //m: array of TAOO;
    a: array of pointer;
      // Compiler bug?..: any atempt to use
      //  "array of TObject" like constructs causes
      //  "invalid pointer operation" (Read: memory manager crash)
      //  when you call "SetLngth(<array>, 0)" on them.
      // Solution: to define "array of pointer" and use
      //  direct type conversions everytime you need to access it... %(
    function _Read(ind: cardinal): TAOO;
    procedure _Write(ind: cardinal; p: TAOO);
    function _ReadLast: TAOO;
    procedure _WriteLast(z: TAOO);
    function _ReadDPTR: pointer; override;
    procedure _Resize(L: integer); override;
  Public
    property D[index: cardinal]:TAOO read _Read write _Write; DEFAULT;
    property Last:TAOO read _ReadLast write _WriteLast;
  End;

{$else header}

function T2DAOO._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of a two-dimensional TDyna descendant');
  Result:=nil;
end;

function T2DAOO._Read(ind: cardinal): TAOO;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind)>=0) and (integer(ind)<s),
    'reading from two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  Result:=TAOO(a[ind]);
end;

procedure T2DAOO._Write(ind: cardinal; p: TAOO);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to two-dimensional TDyna descendant: invalid first index, out of array boundaries');
  a[ind]:=pointer(p);
end;

procedure T2DAOO._Resize(L: integer);
var j, ol: integer;
begin
//WriteLn('*** L=', L, ' s=',s, ' sm=',sm,' length=',system.length(a));
  if L < s then For j:=L to s - 1 do begin TAOO(a[j]).Free; a[j]:=nil end;
//WriteLn('*** 1  ', System.Length(m));
//if System.Length(m)>0 then WriteLn(IntToHex(cardinal(pointer(m[0])),8));
//if system.length(m) = sm then Exit;
//if sm=0 then Exit;
  SetLength(a, sm);
//WriteLn('*** 2');
  if L > s then For j:=s to L - 1 do a[j]:= pointer(TAOO.Create);
//WriteLn('*** 3');
end;

function T2DAOO._ReadLast: TAOO;
begin
  Assert(s > 0, 'reading from two-dimensional TDyna descendant, which length is zero');
  Result:=TAOO(a[s-1]);
end;

procedure T2DAOO._WriteLast(z: TAOO);
begin
  Assert(s > 0, 'writing to two-dimensional TDyna descendant, which length is zero');
  a[s - 1]:= pointer(z);
end;

procedure T2DAOO.SetRect(z, b: integer);
var
  x: integer;
begin
  Length:=z;
  For x:=0 to High do D[x].Length:=b;
end;

procedure T2DAOO.ClearMem;
var j: integer;
begin
  For j:=0 to High do D[j].ClearMem;
end;

{$endif header}

{$undef cl_objecttype}

 {$define cl_objecttype}
 
 
{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
{$ifdef header}
  TAoIni = Class(TDyna)
    Function Add(i: TMemIniFile): integer;
    procedure ClearMem; override;
  Protected
    {$ifdef cl_objecttype}
    a: array of pointer
    {$else}
    m: packed array of TMemIniFile
    {$endif};
    function _Read(ind: cardinal): TMemIniFile;
    procedure _Write(ind: cardinal; p: TMemIniFile);
    function _ReadDPTR: pointer; override;
    function _ReadLast: TMemIniFile;
    procedure _WriteLast(p: TMemIniFile);
    procedure _Resize(L: integer); override;
  Public
    {$ifdef cl_objecttype}
    Container: boolean;
    {$endif}
    property D[index: cardinal]:TMemIniFile read _Read write _Write; DEFAULT;
    property Last:TMemIniFile read _ReadLast write _WriteLast;
  End;

{$else header}

function TAoIni.Add(i: TMemIniFile):integer;
begin
  Increment;
  Last:=i;
  Result:=High;
end;

procedure TAoIni.ClearMem;
var j: integer;
begin
  For j:=0 to High do
  {$ifdef cl_objecttype}
    begin
      if Container and Assigned(a[j]) then TObject(a[j]).Free;
      a[j]:= NIL;
    end;
  {$else}
    {$ifdef cl_stringtype}
       m[j]:='';
    {$else}
       FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;

procedure TAoIni._Resize(L: integer);
var j, os: integer;
begin
  {$ifdef cl_objecttype}
    if (L < s) and Container then For j:=L to s - 1 do begin
      if Assigned(D[j]) then begin
        TObject(D[j]).Free;
        D[j]:=nil;
      end;
    end;
    SetLength(a, sm);
  {$else}
    {$ifdef cl_stringtype}
      if L < s then For j:=L to s - 1 do D[j]:='';
    {$endif}
    SetLength(m, sm);
  {$endif}
  os:=s;
  s:=L;
  if L > os then
  {$ifdef cl_objecttype}
    For j:=os to L - 1 do D[j]:= NIL;
  {$else}
    {$ifdef cl_stringtype}
      For j:=os to L - 1 do D[j]:='';
    {$else}
      For j:=os to L - 1 do FillChar(m[j], SizeOf(m[0]), 0);
    {$endif}
  {$endif}
end;


function TAoIni._Read(ind: cardinal): TMemIniFile;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'reading from one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
    Result:=TMemIniFile(a[ind]);
  {$else}
    Result:=m[ind];
  {$endif}
end;

{$ifndef cl_stringtype}
function TAoIni._ReadDPTR: pointer;
begin
  if s=0 then Result:=nil else result:=@({$ifdef cl_objecttype}a{$else}m{$endif}[0]);
end;
{$else}
function TAoIni._ReadDPTR: pointer;
begin
  Assert(False, 'attempt to read DPTR property of one-dimensional TDyna descendant which is a string array');
  Result:=nil;
end;
{$endif}


function TAoIni._ReadLast: TMemIniFile;
begin
  Assert(s > 0, 'reading from one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  Result:= TMemIniFile(a[s-1]);
  {$else}
  Result:=m[s-1];
  {$endif}
end;

procedure TAoIni._Write(ind: cardinal; p: TMemIniFile);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  Assert((integer(ind) >= 0) and (integer(ind) < s),
    'writing to one-dimensional TDyna descendant: invalid index, out of array boundaries');
  {$ifdef cl_objecttype}
  a[ind]:=pointer(p);
  {$else}
  m[ind]:=p;
  {$endif}
end;

procedure TAoIni._WriteLast(p: TMemIniFile);
begin
  Assert(s > 0, 'writing to one-dimensional TDyna descendant, which length is zero');
  {$ifdef cl_objecttype}
  a[s-1]:=pointer(p);
  {$else}
  m[s-1]:=p;
  {$endif}
end;


{$endif header}

 {$undef cl_objecttype}

