{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}



//    ,  FreePascal 1.06  
//  ,  ,   1.9.2 - , 
//     (Add, Last, SetRect,  ..)
//   ,    ...

{$ifdef fpc}
  {$MACRO ON}
  {$MODE DELPHI}
{$endif}
{$RANGECHECKS OFF}

unit cl_Dyna;

interface
Uses SysUtils, {cl_Classes,} un_typedefs, IniFiles;

Type
{
  TAOP = array of pointer;
  TAOC = array of cardinal;
  TAOI = array of integer;
  TAOS = array of string;
  TAOB = array of LongBool;
  TAOO = array of TObject;
  T2DAOI = array of array of Integer;
  T2DAOS = array of array of String;
  T2DAOO = array of array of TObject;
}

  TDyna = Class(TObject)
    Constructor Create;
    Destructor Destroy; Override;
    procedure Resize(NewLen: integer);
    procedure Increment;
    procedure Decrement;
    procedure ClearMem; virtual; abstract;
    procedure SetRect(a, b: integer); virtual;
  Protected
    s, sm, es: integer;
    function GetSize: integer;
    function GetHigh: integer;
    procedure _Resize(L: integer); virtual; abstract;
    function _ReadDPTR: pointer; virtual; abstract;
  Public
    property High: integer read GetHigh;
    property Length: integer read s write Resize;
    property DPTR:pointer read _ReadDPTR;
  End;

// Gee! Look, people! Now you can use templates in Pascal!
// (though, in somewhat perverted way - through macros and compiler
//  directives - but it works nevertheless!..)

{$ifdef fpc}
  {$include cl_dyna_freepascal.h}
{$else}
  //Delphi, such an asshole, doesn't support macros!
  //use CFDD to utility to auto-convert
  //  cl_dyna_freepascal.h into cl_dyna_delphi.h.
  {$include cl_dyna_h_delphi.inc}
{$endif}


implementation

{$ifdef fpc}
  {$include cl_dyna_freepascal.inc}
{$else}
  //Delphi, such an asshole, doesn't support macros!
  //use CFDD to utility to auto-convert
  //  cl_dyna_freepascal.h into cl_dyna_delphi.h.
  {$include cl_dyna_delphi.inc}
{$endif}

{ TDyna }

constructor TDyna.Create;
begin
  inherited;
  s:=0;
  sm:=0;
  es:=4;
end;

procedure TDyna.Decrement;
begin
  Assert(s > 0,'attempt to decrement TDyna, which length is zero');
  ReSize(s - 1);
end;

destructor TDyna.Destroy;
begin
  resize(0);
  inherited;
end;

function TDyna.GetHigh: integer;
begin
  Result:=s-1;
end;

function TDyna.GetSize: integer;
begin
  Result:=s;
end;

procedure TDyna.Increment;
begin
  ReSize(s+1);
end;

procedure TDyna.Resize(newLen: integer);
var t, n: integer;
begin
 { if sm=0 then begin
    if newLen=0 then Exit
    else begin
      sm:=NewLen;
    end;
  end
  else begin
    if newLen=0 then begin
      sm:=0;
    end
    else begin
      if NewLen > sm then begin
        sm:=((NewLen shr 3) + 1) shl 3;
      end
      else begin
        t:=sm shr 3;
        if (sm - NewLen > t) then begin
          sm:=NewLen;
        end;
      end;
    end;
  end; }
  sm:=NewLen;
  _Resize(NewLen);
  s:=NewLen;
end;

procedure TDYNA.SetRect(a, b: integer);
begin
  Assert(b = 1, 'TDyna: attempt to set second dimension of the one-dimensional array');
  Resize(a);
end;

end.
