{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the high-resolution timer routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

const
  ctRDTSCFreqEstimationPeriod
    = {$ifdef win32} 5.0 {$else} 20.0 {$endif};
  ctFreqCheckPeriod
    = {$ifdef win32} 2.0 {$else} 5.0 {$endif};
  ctFreqDeviationTolerancy
    = {$ifdef win32} 0.05 {$else} 0.2 {$endif};
    //because I don't know how to raise thread priority in unix,
    //  so error marign should be much wider.

var
  ctInitialized: boolean = No;
  ctUseRDTSC: boolean = Yes;
  ctRDTSCFreq: float = 0;
  ctDualProcessorDetected: boolean = No;
  ctFirstTimeStamp,
  ctPrevTimeStamp,
  ctCheckTimeStamp: int64;
  ctPrevNow, ctCheckNow, ctFirstNow: TDateTime;
  ctAccum: float;

  function GetTimeStamp: int64; forward;


  procedure InitCTimer;
  begin
    {$ifdef win32}
    SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
    {$endif}
    ctPrevNow:= Now();
    ctFirstTimeStamp:=GetTimeStamp;
    {$ifdef win32}
    SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
    {$endif}
    ctCheckTimeStamp:=ctFirstTimeStamp;
    ctCheckNow:=ctPrevNow;
    ctFirstNow:=ctPrevNow;
    ctAccum:=0;
  end;

  function CTimer(): float; stdcall;
  //time in seconds since the last call.
  var
    c: int64;
    n: TDateTime;
    currentFreq: float;
  begin
    if ctUseRDTSC and (ctRDTSCFreq <> 0) then begin
      c:=GetTimeStamp;
      if ctDualProcessorDetected then begin
        ctUseRDTSC:=False;
        Warning(MI_DUAL_PROCESSOR_TIMER_ROLLBACK);
        Result:=0;
        ctPrevNow:=Now();
        Exit;
      end;
      Result:=(c - ctPrevTimeStamp) / ctRDTSCFreq;
      ctPrevTimeStamp:=c;
      if (ctAccum > ctRDTSCFreqEstimationPeriod) and (ctAccum > ctFreqCheckPeriod) then begin
        {$ifdef win32}
        SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
        {$endif}
        c:=GetTimeStamp;
        n:=Now();
        {$ifdef win32}
        SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
        {$endif}
        currentFreq:=(c - ctCheckTimeStamp) / ((n - ctCheckNow) * 86400.0);
        if abs (currentFreq - ctRDTSCFreq) > (ctRDTSCFreq * ctFreqDeviationTolerancy)
        then begin
          ctUseRDTSC:=False;
          Warning(MI_FREQ_UNSTABLE_TIMER_ROLLBACK);
          Result:=0;
          ctPrevNow:=Now();
          Exit;
        end;
        ctCheckTimeStamp:=c;
        ctCheckNow:=n;
        ctAccum:=0;
      end;
    end
    else begin
      n:=Now();
      Result:=(n - ctPrevNow) * 86400.0;
      ctPrevNow:=n;
      if ctUseRDTSC and (ctAccum > ctRDTSCFreqEstimationPeriod)
      then begin
        {$ifdef win32}
        SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);
        {$endif}
        c:=GetTimeStamp;
        n:=Now();
        {$ifdef win32}
        SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_NORMAL);
        {$endif}
        ctRDTSCFreq:=(c - ctFirstTimeStamp) / ((n - ctFirstNow) * 86400.0);
        AddLog(RuEn(
          '   .  RDTSC = %0 .',
          'High resolution timer engaged. RDTSC frequency = %0 MHz'),[format('%.6f', [ctRDTSCFreq/1000000])]);
      end;
    end;
    ctAccum:=ctAccum + Result;
  end;

