{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the data file processing routines.

    See the file COPYING.CPS, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}



//********  CGE  FILE  FUNCTIONS  ********************

//One at time, kids! No multi-threading, no interruption.

{

NOTE #1: why use containers instead of memory streams.
     unlike a stream, the container can accept an already allocated
     memory block (for example, the compression routine output),
     thus eliminating unnecessary copying.
   The Cge-file may potentially be a few dozen megabytes in size,
     so this measure is more to decrease  the  memory consumption
     than to increase the speed.
   Cuz swapping is BAD, and there is always not enough memory to avoid it,
     this should be included into the Murphy laws list.

NOTE #2: When reading from a file, the Md5 sum checking
     is always performed before any reading
     from the stream could occur. This effectively means loading
     entire file into a temporary container.
     Probably, I should consider the OS caching mechanism and
     eliminate this step...?


FORMATS:
   0 - the basic format, without any compression or MD5 checking
   s - the same as 0, but calculates MD5 sum. increases save/load time by 75%.
   p (not implemented yet) - compressed format.
}

  Const
    CGEFileDefaultChunkSize = {$ifdef win32} 4096 {$else} 1024*100 {$endif};
  Type
    PCGEHeader = ^TCGEHeader;
    TCGEHeader = packed record
      case integer of
        0: (
          sign: packed array [0..2] of AnsiChar;
          ver: AnsiChar;
          stub0, StreamSize: int64;
          glUintSize,
          glFloatSize,
          PointerSize,
          AlignGranularity: shortint;
          {$ifdef fpc}
            Md5Digest: TMD5Digest;
          {$else}
            Stub3: packed array[0..15] of byte;
          {$endif}
          SessionId: int64);
        1: (Stub1: packed array[0..31] of DWORD;) //128 bytes size
    end;

  var C: record
      Header: PCGEHeader;
     {$ifdef fpc}
      Md5Context: TMd5Context;
      Md5Digest: TMd5Digest;
     {$endif}
      F: TCGEStream;
     {$ifdef cge}
      Chunks: TAOP;
      ChunkSizes: TAOI;
     {$endif}
      DoMd5: boolean;
      Compression: (cfc_None);
     {$ifdef cge}
      Container: TContainer;
     {$endif}
      Read: boolean;
      Opened: boolean;
      TemporaryContainer: boolean;
      FN: AnsiString;
      Buffer: pointer;
      ReadSessionId: int64;
    end;

   {$ifdef cge}
    function ContainerByname(Name: AnsiString): TContainer;
    var i: integer;
    begin
      i:= Containers.IndexOf(name);
      if i >= 0 then Result:= Containers.Objects[i] as TContainer
      else begin
        Result:= TContainer.Create(0);
        Containers.AddObject(Name, Result);
      end;
    end;
   {$endif}

    procedure CgeFilePropByType(t: AnsiChar; name: PAnsiChar);
    begin
      C.Header^.sign:='CGE';
      {$ifndef fpc}
        if t='s' then t:='0';
      {$endif}
      Case t of
        '0': with C do begin
            Compression:=cfc_None;
            DoMd5:=No;
          end;
        's': with C do begin
            Compression:=cfc_None;
            DoMd5:=Yes;
          end;
      else
        Die(MI_CGEFILE_UNSUPPORTED, [Name, 'CGE' + t])
      end;
    end;

  procedure OpenCGEFileForWrite (TargetName: PAnsiChar; version: AnsiChar); stdcall;
  begin
    New(C.Header);
    FillChar(C.Header^, SizeOf(C.Header^), 0);
    C.Header^.sign:='CGE';
    {$ifndef fpc}
      if version='s' then version:='0';
    {$endif}
    C.Header^.ver:=version;
    {$ifdef cge}
    C.Header^.SessionId:=GetCurrentSessionId;
    {$endif}

    CgeFilePropByType(version, TargetName);
    C.FN:=TargetName;

    {
      For future use (64-bit-platform support).
      It's the far future, and I am not sure of the strategy yet.
      Should cge-files, maybe, have a fixed format,
         where integer is always 32-bit, and so on?..}
    C.Header^.glUintSize:=SizeOf(glUint);
    C.Header^.glFloatSize:=SizeOf(glFloat);
    C.Header^.PointerSize:=SizeOf(pointer);
    C.Header^.AlignGranularity:=AlignGranularity;
    {$ifdef fpc}
      if C.DoMd5 then  MD5Init(C.Md5Context);
    {$endif}
    Try
     {$ifdef cge}
      if C.FN[1] = '$' then begin
        C.Container:=ContainerByName(C.FN);
        C.Container.Size:=0;
        C.Container.InsertChunk(C.Header, SizeOf(C.Header^)); //voila. We can add anything later (like MD5 sum or stream size)
      end
      else begin
        C.Container:=nil;
       {$endif}
        C.F:=TCGEStream.CreateForWrite(C.FN);
        C.F.Write(C.Header^, SizeOf(C.Header^));//it's not ready. We just reserve a place for now.
     {$ifdef cge}
      end;
     {$endif}
    Except
      Die(MI_CGEFILE_ERROR_WRITE, [TargetName]);
    End;
    C.Opened:=Yes;
    C.Read:=No;
  end;

  procedure OpenCGEFileForRead  (SourceName: PAnsiChar; var version: AnsiChar); stdcall;
  var
    s, o: integer;
    p: pointer;
  begin
    C.FN:=SourceName;
    GetMem(C.Buffer, CGEFileDefaultChunkSize);
    C.TemporaryContainer:=No;
    Try
     {$ifdef cge}
      if C.FN[1] = '$' then begin
        if Containers.IndexOf(C.FN) < 0
          then Die(MI_CONTAINER_DOESNT_EXIST, [SourceName]);
        C.Container:=ContainerByName(SourceName);
        C.Container.PrepareToRead;
        C.Header:=C.Container.NextChunk(s);
        if s <> SizeOf(C.Header^)
          then Die(MI_CGEFILE_CORRUPT, [SourceName, 'Container''s header chunk size mismatch']);
      end
      else begin
        C.Container:=nil;
     {$endif}
        C.F:=TCGEStream.CreateForRead(SourceName);
        New(C.Header);
        C.F.Read(C.Header^, SizeOf(C.Header^));
     {$ifdef cge}
      end;
     {$endif}
      //format checking
      if C.Header^.sign <> 'CGE'
        then Die(MI_CGEFILE_CORRUPT, [SourceName
               , RuEn(' ', 'Wrong signature')]);
      CgeFilePropByType(C.Header^.ver, SourceName);
      C.ReadSessionId:=C.Header^.SessionId;

      //size checking
     {$ifdef cge}
      if Assigned(C.Container) then s:=C.Container.Size - SizeOf(C.Header^)
                               else {$endif}
                                    s:=C.F.Size - SizeOf(C.Header^);
      if s <> C.Header^.StreamSize
        then Die(MI_CGEFILE_CORRUPT, [SourceName
               , RuEn('  ', 'Size mismatch')]);

      // Type sizes conversion checking (between 64/32bit/little-endian platforms)
      // **** NOT IMPLEMENTED YET
      {$ifdef fpc}
        if C.DoMd5 then MD5Init(C.Md5Context);


        //files with md5 sum are loaded into containers for checking:
        if {$ifdef cge}not Assigned(C.Container) and{$endif} C.DoMd5 then begin
         {$ifdef cge}
          C.Container:=ContainerByName('$$CGEFILE');
          C.Container.Clear;
          //note, the stream position is already post header:
          C.Container.LoadFromStream(C.F, CGEFileDefaultChunkSize);
          C.F.Free;
          C.TemporaryContainer:=Yes;
          //now do the md5 check:
          C.Container.PrepareToRead;
          repeat
            p:=C.Container.NextChunk(s);
            if not Assigned(p) then break;
            MD5Update(C.Md5Context,  p^, s);
          until false;
         {$else}
          o:=C.F.position;
          p:=GetMem(C.F.Size - o);
          C.F.Read(p^, C.F.Size - o);
          MD5Update(C.Md5Context,  p^, C.F.Size - o);
          FreeMem(p);
          C.F.position:=o;
         {$endif}
          MD5Final(C.Md5Context, C.Md5Digest);
          if not Md5match (C.Header^.MD5digest, C.MD5digest)
            then Die(MI_CGEFILE_CORRUPT, [C.FN
                    , RuEn('    MD5', 'MD5 sum mismatch')]);
         {$ifdef cge}
          C.Container.PrepareToRead;
         {$endif}
          C.DoMd5:=No;
        end;
      {$endif}
    Except
      Die(MI_CGEFILE_ERROR_READ, [SourceName]);
    End;
    version:=C.Header^.ver;
    C.Opened:=Yes;
    C.Read:=Yes;
  end;


  function ReadFromCGEFile (var BufferLen: integer): pointer; stdcall;
  begin
    if not C.Opened
      then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to read from cge-file while it wasn''t opened yet.']);
    if not C.Read
      then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to read from cge-file while it is open for writing.']);
   {$ifdef cge}
    if Assigned(C.Container) then begin
      Try
        Result:=C.Container.NextChunk(BufferLen);
      Except
        Die(MI_CGEFILE_ERROR_READ, [C.FN]);
      End;
    end
    else begin
   {$endif}
      Try
        BufferLen:=C.F.Size - C.F.Position;
        if BufferLen > CGEFileDefaultChunkSize then BufferLen:=CGEFileDefaultChunkSize;
        C.F.Read(C.Buffer^, BufferLen);
        Result:=C.Buffer;
      Except
        Die(MI_CGEFILE_ERROR_READ, [C.FN]);
      End;
   {$ifdef cge}
    end;
   {$endif}
    if (BufferLen div AlignGranularity) * AlignGranularity <> BufferLen
      then Die(MI_CGEFILE_CORRUPT, [C.FN
                 , RuEn('     '+IntToStr(AlignGranularity)+' '
                        ,'Data chunk size is not divisible by '+IntToStr(AlignGranularity)+' bytes')]);
    {$ifdef fpc}
      if C.DoMd5 then MD5Update(C.Md5Context, Result^, BufferLen);
    {$endif}
  end;

    var
      _cgf_buf: pointer = nil;
  function AllocCGefileWriteBuffer (var BufferLen: integer): pointer; stdcall;
  begin
    GetMem(_cgf_buf, CGEFileDefaultChunkSize);
    BufferLen:=CGEFileDefaultChunkSize;
    Result:=_cgf_buf;
  end;


  procedure WriteToCGEFile (BufferLen: integer); stdcall;
  var
    p: pointer;
  begin
    if not C.Opened
      then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to write to cge-file while it wasn''t opened yet.']);
    if C.Read then
      Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to write to cge-file while it is open for reading.']);
    if BufferLen <> CGEFileDefaultChunkSize then begin
      p:=_cgf_buf;
      GetMem(_cgf_buf, BufferLen);
      MOVE(p^, _cgf_buf^, BufferLen);
      FreeMem(p);
    end;
    {$ifdef fpc}
      if C.DoMd5  then MD5Update(C.Md5Context, _cgf_buf^, BufferLen);
    {$endif}
   {$ifdef cge}
    if Assigned(C.Container) then begin
      Try
        C.Container.InsertChunk(_cgf_buf, BufferLen);
      Except
        Die(MI_CGEFILE_ERROR_WRITE, [C.FN]);
      End;
    end
    else begin
   {$endif}
      Try
        C.F.Write(_cgf_buf^, BufferLen);
        FreeMem(_cgf_buf);
      Except
        Die(MI_CGEFILE_ERROR_WRITE, [C.FN]);
      End;
   {$ifdef cge}
    end;
   {$endif}
  end;

  procedure CloseCGEFile (FlushToFile: boolean; FileName: PAnsiChar); stdcall;
  begin
    if not C.Opened then Die(MI_ERROR_PROGRAMMER_NO_BAKA, ['Attempt to close the already closed cge-file.']);
    if C.Read then begin
     {$ifdef cge}
      if Assigned(C.Container) then begin
        if C.TemporaryContainer then C.Container.Clear;
      end
      else begin
     {$endif}
        FreeMem(C.Buffer);
        C.F.Free;
     {$ifdef cge}
      end;
      {$ifdef fpc}
        if C.DoMd5 then begin
          MD5Final(C.Md5Context, C.Md5Digest);
          if not Md5match (C.Header^.MD5digest, C.MD5digest)
            then Die(MI_CGEFILE_CORRUPT, [C.FN
                     , RuEn('    MD5', 'MD5 sum mismatch')]);
        end;
      {$endif}
     {$endif}
    end
    else begin
     {$ifdef fpc}
       if C.DoMd5 then MD5Final(C.Md5Context, C.Header^.Md5Digest);
     {$endif}
     {$ifdef cge}
      if Assigned(C.Container) then begin
        //tricky me. The header is already a part of the container!
        C.Header^.StreamSize:=C.Container.Size - SizeOf(C.Header^);
        if FlushToFile then begin
          C.F:=TCGEStream.CreateForWrite(FileName);
          C.Container.WriteToStream(C.F);
          C.F.Free;
        end;
        C.Header:=nil; //do NOT deallocate.
      end
      else begin
     {$endif}
        Try
          C.Header^.StreamSize:=C.F.Size - SizeOf(C.Header^);
          C.F.Position:=0;
          C.F.Write(C.Header^, SizeOf(C.Header^));//return to the beginning and write the correct header.
          C.F.Free;
          Dispose(C.Header); //deallocate it
        Except
          Die(MI_CGEFILE_ERROR_WRITE, [C.FN]);
        End;
     {$ifdef cge}
      end;
     {$endif}
    end;
    C.Opened:=No;
  end;
  
  function GetCGEFileSessionId(): int64; stdcall;
  begin
    Result:=C.ReadSessionId;
  end;
  
{$ifdef cge}
  function CgeFileExists (name: PAnsiChar): boolean; stdcall;
  begin
    Result:=FileExists(WorkingDir + PCharToString(name));
  end;

  
  procedure CgeFileRename (fFrom, fTo: PAnsiChar); stdcall;
  var
    f: file;
    fp, tp: string;
  begin
    fp:=WorkingDir + PCharToString(ffrom);
    tp:=WorkingDir + PCharToString(fto);
    if FileExists(tp) then begin
      Try
        Assign(f, tp);
        Erase(f);
      Except
        Die(MI_ERROR_CANNOT_DESTROY_FILE, [tp]);
      End;
    end;
    RenameFile(fp, tp);
  end;
{$endif}

