program ConvertForDelphi;

{$ifdef fpc}
  {$mode objfpc}{$H+}
{$endif}

uses
  Classes, SysUtils
  { add your units here };
var
  i, j: integer;
  f: text;
  E: TStringList;
  def: array[0..9] of string = ('???', '???', '???', '???', '???', '???', '???', '???', '???', '???');
  
procedure Load(fname: string; p: integer);
var
  e1, e2: TStringList;
  i,j: integer;
  s: string;
begin
  writeln(fname);
  e2:=TStringList.Create;
  assign(f, fname);
  reset(f);
  while not eof(f) do begin
    readln(f, s);
    e2.add(s);
  end;
  close(f);
  e1:=TStringList.Create;
  for i:=0 to p - 1 do e1.add(e[i]);
  for i:=0 to e2.Count - 1 do e1.Add(e2[i]);
  for i:=p + 1 to e.Count - 1 do e1.add(e[i]);
  e.free;
  e:=e1;
  e2.free;
end;

function filterstr(s: string): string;
var i: integer;
begin
  result:='';
  for i:=1 to length(s) do if s[i] <> ' ' then result:=result + s[i];
end;

function isinclude(s: string): boolean;
begin
  Result:=copy(s,1,9) = '{$include';
end;

function includename(s: string): string;
begin
  Result:=copy(s,10,Length(s) - 10);
end;

function checkdefname(s: string): boolean;
begin
  Result:=false;
  if copy(s,1,18) = '{$definetypeofit:=' then begin
    def[0]:=copy(s,19,Length(s) - 19);
    result:=true;
    exit;
  end;
  if copy(s,1,18) = '{$definetypename:=' then begin //cl_*
    def[1]:=copy(s,19,Length(s) - 19);
    result:=true;
    exit;
  end;
  if copy(s,1,19) = '{$definetype1name:=' then begin //mo_*
    def[1]:=copy(s,20,Length(s) - 20);
    result:=true;
    exit;
  end;
  if copy(s,1,19) = '{$definetype2name:=' then begin
    def[2]:=copy(s,20,Length(s) - 20);
    result:=true;
    exit;
  end;
  if copy(s,1,17) = '{$definee_pro_1:=' then begin
    def[3]:=copy(s,18,Length(s) - 18);
    result:=true;
    exit;
  end;
  if copy(s,1,17) = '{$definee_pro_2:=' then begin
    def[4]:=copy(s,18,Length(s) - 18);
    result:=true;
    exit;
  end;
  if copy(s,1,17) = '{$definee_fun_1:=' then begin
    def[5]:=copy(s,18,Length(s) - 18);
    result:=true;
    exit;
  end;
  if copy(s,1,17) = '{$definee_fun_2:=' then begin
    def[6]:=copy(s,18,Length(s) - 18);
    result:=true;
    exit;
  end;
  if copy(s,1,14) = '{$definee_cm:=' then begin
    def[7]:=copy(s,15,Length(s) - 15);
    result:=true;
    exit;
  end;
  if copy(s,1,23) = '{$definetype1procname:=' then begin
    def[8]:=copy(s,24,Length(s) - 24);
    result:=true;
    exit;
  end;
  if copy(s,1,23) = '{$definetype2procname:=' then begin
    def[9]:=copy(s,24,Length(s) - 24);
    result:=true;
    exit;
  end;

  
end;

Function StrReplace (S, zamenjaemoe, zamenjajushee: AnsiString): AnsiString;
var p: integer;
    s2: AnsiString;
begin
  p:=Pos(zamenjaemoe, s);
  While p > 0 do begin
    s:=COPY(s, 1, p - 1) + zamenjajushee + COPY(s, p + Length(zamenjaemoe), Length(s) - p - Length(zamenjaemoe) + 1);
    p:=Pos(zamenjaemoe, s);
  end;
  StrReplace:=s;
end;

procedure Process(fname1, fname2:string);
var
  s: string;
  n: integer;
begin
  e:=TStringList.create;
  e.Add('// THIS FILE IS GENERATED AUTOMATICALLY,');
  e.add('// DO NOT EDIT IT!');
  e.add('// Make your modifications to "'+fname1+'" ,');
  e.add('//   then run ConvertForDelphi.exe');
  e.add('//');
  e.add('//');
  e.add('//');
  e.add('.');
  Load(fname1, 7);
  n:=0;
  while n < e.Count do begin
    writeln(n);
    s:=filterstr(e[n]);
    while isinclude(s) do begin
      Load(includename(s), n);
      s:=filterstr(e[n]);
    end;
    if checkdefname(s) then e[n]:=' ';
    e[n]:=strreplace(e[n], 'typeofit', def[0]);
    e[n]:=strreplace(e[n], 'typename', def[1]);  //cl_*
    e[n]:=strreplace(e[n], 'type1name', def[1]); //mo_*
    e[n]:=strreplace(e[n], 'type2name', def[2]);
    e[n]:=strreplace(e[n], 'e_pro_1', def[3]);
    e[n]:=strreplace(e[n], 'e_pro_2', def[4]);
    e[n]:=strreplace(e[n], 'e_fun_1', def[5]);
    e[n]:=strreplace(e[n], 'e_fun_2', def[6]);
    e[n]:=strreplace(e[n], 'e_cm', def[7]);
    e[n]:=strreplace(e[n], 'type1procname', def[8]);
    e[n]:=strreplace(e[n], 'type2procname', def[9]);

    if (fname2 ='cl_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}') then e[n]:='_exp_Tick';
    if (fname2 ='cl_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}') then e[n]:='_exp_Tick';
    if (fname2 ='cl_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_NowDying{$else}NowDying{$endif}') then e[n]:='_exp_NowDying';
    if (fname2 ='cl_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif}') then e[n]:='_exp_StopDying';
    if (fname2 ='cl_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_NowDying{$else}NowDying{$endif}') then e[n]:='_exp_NowDying';
    if (fname2 ='cl_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif}') then e[n]:='_exp_StopDying';

    if (fname2 ='mo_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}') then e[n]:='Tick';
    if (fname2 ='mo_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_Tick{$else}Tick{$endif}') then e[n]:='Tick';
    if (fname2 ='mo_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_NowDying{$else}NowDying{$endif}') then e[n]:='NowDying';
    if (fname2 ='mo_eh_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif}') then e[n]:='StopDying';
    if (fname2 ='mo_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_NowDying{$else}NowDying{$endif}') then e[n]:='NowDying';
    if (fname2 ='mo_ee_delphi.inc') and (trim(e[n])='{$ifdef cgekernel}_exp_StopDying{$else}StopDying{$endif}') then e[n]:='StopDying';


//    if (fname2 ='') and (trim(e[n])='') then e[n]:='';

    inc(n);
  end;
  Assign(f, fname2);
  rewrite(f);
  for n:=0 to e.Count - 1 do writeln(f, e[n]);
  close(f);
  e.free;
end;


  
begin
  Try
    Process('cl_dyna_freepascal.h', 'cl_dyna_h_delphi.inc');
    Process('cl_dyna_freepascal.inc', 'cl_dyna_delphi.inc');
    Process('cl_eh_freepascal.h', 'cl_eh_delphi.inc');
    Process('cl_ee_freepascal.inc', 'cl_ee_delphi.inc');
    Process('mo_eh_freepascal.h', 'mo_eh_delphi.inc');
    Process('mo_ee_freepascal.inc', 'mo_ee_delphi.inc');
    Process('mo_classes_1_freepascal.h', 'mo_classes_h_1_delphi.inc');
    Process('mo_dyna.h', 'mo_dyna_h_delphi.inc');
    Process('mo_classes_1_freepascal.inc', 'mo_classes_1_delphi.inc');
  Except
    WriteLn((ExceptObject as exception).Message);
    readln;
  end;
end.

