{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains source of the test module #011.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
 
unit _test011_main;
 
interface
 
 uses
  SysUtils,
  cl_typedefs in '../../../core/src/cl_typedefs.pp',
  mo_hub in '../../../core/src/mo_hub.pp';
  
  procedure T11_OnGetFocus;
  procedure T11_OnLoseFocus;
  procedure T11_OnIdle;
  procedure T11_OnCreate;
  procedure T11_OnPress(scancode: integer);
  procedure T11_OnRelease(scancode: integer);
  procedure T11_OnMouseMove(x, y: integer);

implementation

   var
     mx, my, r, g, b, ar, ag ,ab, aa, s: glFloat;

     m: TImageMode;
     w,h, t: integer;
     p: pointer;
     
     texture: glUint;


    procedure T11_OnGetFocus;
    var mode: glUint;
     t:  integer;
    begin
      r:=0.15;
      g:=0.25;
      b:=0.5;
      texture:=CGEHasTexture('Moya tekstura');
      if texture = 0 then begin
        texture:=CGEGenTexture('Moya tekstura');
        AddLogA('Texture is alreadty loaded. Created as %0.', [texture]);
        p:=GetContainer('Konteiner s teksturoi');
        AddLogA('Decoding texture image from container at %0 ...',[p]);
        t:=Tick();
        PrepareToDecodePic ('Konteiner s teksturoi', w, h, m);
        GetMem(p, w * h * ImgModeBpp[m]);
        DecodePic(p);
        AddLogA('Decoding took %0 ms.', [Tick() - t]);
        AddLogA('Deleting the container, freeing %0 Kbytes of memory'
          , [GetContainerSize('Konteiner s teksturoi') div 1024]);
        DeleteContainer('Konteiner s teksturoi');
        texture:=CgeGenTexture('Moya tekstura');

        glBindTexture(GL_TEXTURE_2D, texture);
        if m = Im_RGBA then mode:=GL_RGBA else mode:=GL_RGB;
        t:=tick;
        gluBuild2DMipMaps(GL_TEXTURE_2D, mode , w, h, mode, GL_UNSIGNED_BYTE, p);
        AddLogA('Texture image loaded. gluBuild2DMipMaps() call took %0 ms.',[Tick()-t]);
        FreeMem(p);
      end
      else AddLogA('Texture is alreadty loaded. Its name is %0.', [texture]);

    end;

    procedure T11_OnLoseFocus;
    begin
      r:=1;
      g:=0;
      b:=0;
    end;

    procedure T11_OnMouseMove(x, y: integer);
    begin
      s:=5;
      mx:=x;
      my:=y;
    end;

    procedure T11_OnPress(scancode: integer);
    begin
      case Scancode of
        KEY_WHEEL_UP: aa:=aa + 0.1;
        KEY_WHEEL_DOWN: aa:=aa - 0.1;
        KEY_LEFT_BUTTON: if ar > 0.5 then ar:=0 else ar:=1;
        KEY_RIGHT_BUTTON: if ag > 0.5 then ag:=0 else ag:=1;
        KEY_MIDDLE_BUTTON: if ab > 0.5 then ab:=0 else ab:=1;
        KEY_ESCAPE: RequestExit;
        KEY_ENTER: if InFullScreenMode() then SwitchToWindowedMode
                                         else SwitchToFullscreenMode(800, 600, 0);
        KEY_SPACE: raise Exception.Create('Crash test!')
      else
        g:=g + 0.11;
      end;
    end;

    procedure T11_OnRelease(scancode: integer);
    begin
      if not (scancode in [KEY_WHEEL_DOWN, KEY_WHEEL_UP, KEY_MIDDLE_BUTTON,
        KEY_RIGHT_BUTTON, KEY_LEFT_BUTTON, KEY_ESCAPE, KEY_ENTER])
      then g:=g - 0.11;
    end;

    procedure T11_OnCreate;
    begin
      ar:=1;
      ag:=1;
      ab:=1;
      aa:=0.7;
      s:=10;
      mx:=0;
      my:=0;
    end;

   var ti: longint;

    procedure T11_OnIdle;
    begin
      if aa > 1 then aa:=1;
      if aa < 0 then aa:=0;
      s:=s + 0.01 * (128 - s);
      if s > 128 then s:=128;
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtered
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);	// Linear Filtered
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
      glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
      glEnable(GL_ALPHA_TEST);
      //glDisable(GL_BLEND);
      glEnable(GL_BLEND);
      glAlphaFunc(GL_GREATER, 0);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      glDisable(GL_CULL_FACE);
      glDisable(GL_DEPTH_TEST);
      glViewport(0, 0, DisplayWidth(), DisplayHeight());
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      gluOrtho2d(0, DisplayWidth(), 0, DisplayHeight());
      glClearColor(r, g, b, 0);
      glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
      glDisable(GL_TEXTURE_2D);
      glBegin(GL_QUADS);
        glNormal3f( 0.0, 0.0, 1.0);
        glColor3f(r, g, b);
        glVertex2f(0, 0);
        glVertex2f(0, DisplayHeight());
        glVertex2f(DisplayWidth(), DisplayHeight());
        glVertex2f(DisplayWidth(), 0);
      glEnd;
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D, texture);
      glBegin(GL_QUADS);//GL_TRIANGLES);
        glNormal3f( 0.0, 0.0, 1.0);
        glColor4f(ar, ag, ab , aa);
        glTexCoord2f(0, 0);
        glVertex2f(mx, DisplayHeight() - my);  //top left
        glTexCoord2f(1, 0);
        glVertex2f(mx + s, DisplayHeight() - my);
        glTexCoord2f(1, 1);
        glVertex2f(mx + s, DisplayHeight() - my - s);
        glTexCoord2f(0, 1);
        glVertex2f(mx, DisplayHeight() - my - s);
      glEnd;
 //AddLogA(' ** %0',[IntToStr(Tick - ti)]);
 //ti:=Tick;
     // CgeSwapBuffers();
 //AddLogA(' -- %0',[IntToStr(Tick - ti)]);
 //ti:=Tick;

     {$ifdef unix}
       //delay(15);
     {$else}
       //Sleep(15);
     {$endif}
    end;





end.
