{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains source of the test module #011.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$MACRO ON}
{$MODE Delphi}
{$IFDEF Win32}
  {$DEFINE extdecl := stdcall}
{$ELSE}
  {$DEFINE extdecl := cdecl}
{$ENDIF}

library _test011;

uses
  SysUtils,
  cl_typedefs in '../../../core/src/cl_typedefs.pp',
  mo_hub in '../../../core/src/mo_hub.pp',
  _test011_main, typinfo;

  procedure Initialize; extdecl; export;
  var t, stub: integer;
  begin
    Initialize_MO;

    AddLogA('Loading Texture file into memory...', []);
    T:=Tick();
    if not Assigned(GetContainer('Konteiner s teksturoi'))
       then CreateContainerFromFile('Konteiner s teksturoi'
                  , '', 'modules/_test011/tekstura.png', stub);
    AddLogA('  ..took %0 ms.', [Tick() - T]);

    ClearProcAddresses; //OpenGL;
  end;

var
  FirstRun: boolean = Yes;

  function HandleMessage (msg: TCbMessage; par: array of integer): boolean; extdecl; export;
  var s1, s2: string;
  begin
    Try
      Result:=Yes;
      //raise exception.create('Boo!');
      Case msg of
        Re_OnGetFocus:begin
          ClearProcAddresses;//OpenGL;
          InitProcAddresses;//OpenGL;
          if FirstRun then T11_OnCreate;
          FirstRun:=No;
          T11_OnGetFocus;
          //SwitchToModuleAtExitFromOnIdle(1);
        end;
        Re_OnLoseFocus: begin
          T11_OnLoseFocus;
        end;
        Re_OnMouseMove: T11_OnMouseMove(par[0], par[1]);
        Re_OnIdle: T11_OnIdle;
        Re_OnPress: T11_OnPress(par[0]);
        Re_OnRelease: T11_OnRelease(par[0]);
        Re_OnReloadStart: begin
          T11_OnLoseFocus;
        end;
        Re_OnReloadEnd: begin
          T11_OnGetFocus;
        end;

      else
        Result:=No;
      end;
//Function GetTypeData(TypeInfo : PTypeInfo) : PTypeData;
//Function GetEnumName(TypeInfo : PTypeInfo;Value : Integer) : string;
    Except
      s1:=(ExceptObject as Exception).ClassName;
      s2:=(ExceptObject as Exception).Message;
      Die(MI_CRASHED_IN, [GetEnumName(TypeInfo(TCbMessage), Ord(msg)) + '  message handler'
      ,s1, s2]);
    End;
  end;

  procedure SetGetAddressCallbackFunc(Addr: pointer); extdecl; export;
  begin
    RCFunc:= Addr;
  end;
  
exports
  Initialize name 'CGEMODULEINIT',
  HandleMessage name 'SENDMSG',
  SetGetAddressCallbackFunc name 'SETCALLBACK';
begin

end.
