{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004 - 2006 by Anton Rzheshevski (chebmaster@mail.ru),
     and contains the main unit for the game modules.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$MACRO ON}
{$MODE Delphi}
{$IFDEF Win32}
  {$DEFINE extdecl := stdcall}
{$ELSE}
  {$DEFINE extdecl := cdecl}
  {$LINKLIB c}
{$ENDIF}

unit mo_hub;

interface
uses
  SysUtils,
  cl_typedefs
  {$ifdef win32}
  ,Windows
  {$else}
  ,dllfuncs, dl
  {$endif}
  ;

{$include texsages_list.inc}
{$include cl_gl_header.inc}

var
  BaseDir: WideString;

  RCFunc: function(fNum: integer): pointer;
  Die: procedure (YellID :TMessageID; Param: array of const);
  DieA: procedure (AnsiYell: AnsiString);
  VerboseLogA: procedure (S: AnsiString; Param: array of const);
  AddLogA: procedure (S: AnsiString; Param: array of const);
  AddLog: procedure (mID: TMessageID; Param: array of const);
  AddLogOK: procedure;
  DbgSay: Procedure (Yell: AnsiString);
  GetModNum: function(): integer;
  GetModName: function (num: integer): AnsiString;
//  SwitchToModuleAtExitFromOnIdle: procedure (num: integer);
  GetGLProcAddress: function (ProcName: String): Pointer;
  GetGLUProcAddress: function (ProcName: String): Pointer;
  GetGLEXTProcAddress: function (ProcName: String): Pointer;
  ValidateTypesets: procedure (i, n: integer);
  RequestExit: procedure;
//  PrepareToDecodePic: procedure (DirPack, FileName: AnsiString; var width, height: integer; var mode: TImageMode);
  PrepareToDecodePic: procedure (ContainerName: AnsiString; var width, height: integer; var mode: TImageMode);
  DecodePic: procedure(OutBuff: Pointer); //Output buffer
                                          // must be allocated by the caller!
  EncodePic: procedure(DirPack, FileName: AnsiString; //encoding type is determined
       Image: pointer; width, height: integer; mode: TImageMode); //by file name's extension
  ValidateVersion: procedure(s: AnsiString);
  GetBaseDir: function: WideString;
  CreateContainer: function(Name: AnsiString; Size: integer): pointer;
  GetContainer: function(Name: AnsiString): pointer;
  GetContainerSize: function(Name: AnsiString): integer;
  DeleteContainer: procedure (Name: AnsiString);
  StoreContainerToFile: procedure (Name, PackName, FileName: AnsiString);
  CreateContainerFromFile: function(Name, PackName, FileName: AnsiString; var Size: integer): pointer;
  InFullScreenMode: function(): boolean;
  CgeSwapBuffers: procedure();
  SwitchToWindowedMode: procedure();
  SwitchToFullscreenMode: function(width, height, hertz: integer): boolean;
  DisplayWidth: function(): integer;
  DisplayHeight: function(): integer;
  CgeGenTexture: function (Name: AnsiString): glUint;
  CgeHasTexture: function (Name: AnsiString): glUint;
  CgeDeleteTexture: procedure (Name: AnsiString);
  Tick: function(): longint;

  

procedure Initialize_MO;

//OpenGL:
procedure ClearProcAddresses;
procedure InitProcAddresses;
//function glext_LoadExtension(ext: String): Boolean;


implementation

{$include cl_gl_loadprocs.inc}

//{$include cl_talesteller.inc}

procedure Initialize_MO;
begin
  @Die:= RCFunc(0);
  @DieA:= RCFunc(1);
  @VerboseLogA:= RCFunc(2);
  @AddLogA:= RCFunc(3);
  @AddLog:= RCFunc(4);
  @AddLogOK:= RCFunc(5);
  @DbgSay:= RCFunc(6);
  @GetModNum:= RCFunc(7);
  @GetModName:= RCFunc(8);
//  @SwitchToModuleAtExitFromOnIdle:= RCFunc(9);
  @GetGLProcAddress:= RCFunc(10);
  @GetGLUProcAddress:= RCFunc(11);
  @GetGLEXTProcAddress:= RCFunc(12);
  @ValidateTypesets:= RCFunc(13);
  @RequestExit:=RCFunc(14);
//  @PrepareToDecodePic:=RCFunc(15);
  @DecodePic:=RCFunc(16);
  @EncodePic:=RCFunc(17);
  @ValidateVersion:=RCFunc(18);
  @GetBaseDir:=RCFunc(19);
  @CreateContainer:=RCFunc(20);
  @GetContainer:=RCFunc(21);
  @GetContainerSize:=RCFunc(22);
  @DeleteContainer:=RCFunc(23);
  @StoreContainerToFile:=RCFunc(24);
  @CreateContainerFromFile:=RCFunc(25);
  @InFullScreenMode:=RCFunc(26);
  @SwitchToWindowedMode:=RCFunc(27);
  @SwitchToFullscreenMode:=RCFunc(28);
  @DisplayWidth:=RCFunc(29);
  @DisplayHeight:=RCFunc(30);
  @CgeSwapBuffers:=RCFunc(31);
  @CgeGenTexture:=RCFunc(32);
  @CgeHasTexture:=RCFunc(33);
  @CgeDeleteTexture:=RCFunc(34);
  @Tick:=RCFunc(35);
  @PrepareToDecodePic:=RCFunc(36);
  
  ValidateTypesets(ord(MI_STUB), 0);
  ValidateTypesets(ord(Re_Stub), 1);
  ValidateVersion(VersionString);
  BaseDir:=GetBaseDir;
end;





end.
