{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  the main window class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


 procedure TCGEWindow.OnGetFocus;
 begin
   ModuleManager.InputMessage(Re_OnGetFocus, [DisplayWidth, DisplayHeight]);
   ModuleManager.InputMessage(Re_OnMouseMove, [MouseX, MouseY]);
 end;

 procedure TCGEWindow.OnLoseFocus;
 var i: integer;
 begin
   if WindowExists then i:=0 else i:=1;
   ModuleManager.InputMessage(Re_OnLoseFocus, [i]);
 end;

 procedure TCGEWindow.OnMouseMove;
 begin
   ModuleManager.InputMessage(Re_OnMouseMove, [MouseX, MouseY]);
 end;

    // it's called once at startup, and everytime the window unwraps
    // from the minimized state (even if fullscren mode is used)
    // and each time when window's size was changed.
    // Use DisplayWidth and DisplayHeight to obtain window size.
 procedure TCGEWindow.OnResize;
 begin
   ModuleManager.InputMessage(Re_OnResize ,[DisplayWidth, DisplayHeight]);
 end;

 function TCGEWindow.IsHotkey(scancode: integer; HK: array of integer): boolean;
 var
   i: integer;
 begin
   Result:=No;
   if Length(HK) = 0 then Exit;
   For i:=0 to Length(HK) - 2 do
     if not Pressed[HK[i]] then Exit;
   if HK[Length(HK) - 1] = scancode then Result:=Yes;
 end;

 procedure TCGEWindow.OnPress(scancode: integer);
 begin
   If IsHotKey(scancode, AbortHotKey) then begin
     RequestExit;
     VerboseLog('Hot keys pressed - exit requested.');
     Exit;
   end;
{   If IsHotKey(scancode, MainModuleHotKey) then begin
     ModuleManager._ActiveModuleNum:=0;
     VerboseLog('Hot keys pressed - switching to default module.');
     Exit;
   end;}
   if IsHotKey(scancode, ConsoleToggleHotkey) then begin
     Console.AlwaysVisible:=not(Console.AlwaysVisible);
     Exit;
   end;
   if Console.AlwaysVisible then begin
     if IsHotKey(scancode, ConsoleScrollUpHotkey) then begin
       Console.ScrolledBack:=Console.ScrolledBack + 1;
       Exit;
     end;
     if IsHotKey(scancode, ConsoleScrollDownHotkey) then begin
       Console.ScrolledBack:=Console.ScrolledBack - 1;
       Exit;
     end;

   end;
   ModuleManager.InputMessage(Re_OnPress ,[scancode]);
 end;

 procedure TCGEWindow.OnRelease(scancode: integer);
 begin
   ModuleManager.InputMessage(Re_OnRelease ,[scancode]);
 end;

 procedure TCGEWindow.OnType(input: WideChar);
 begin
   ModuleManager.InputMessage(Re_OnType ,[ord(input)]);
 end;

 procedure TCGEWindow.OnCreate;
 begin
   //ModuleManager.ActiveModule.SendMessage(Re_OnCreate, []);
 end;

 procedure TCGEWindow.OnDestroy;
 var i: integer;
 begin
   if WindowExists then i:=0 else i:=1;
   ModuleManager.InputMessage(Re_OnDestroy ,[i]);
 end;

    // Main cyclic method. Called repeatedly, unless there is anything else to do
 procedure TCGEWindow.OnIdle;
 var
   DidDraw: boolean;
 begin
   ModuleManager.CheckDates;
   DidDraw:=ModuleManager.InputMessage(Re_OnIdle, []);
   Console.Draw(Not DidDraw);
   SwapBuffers;
 end;


