{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains  wide string handling routines.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

 {$ifdef _header}
  type
  {$define header}
 {$endif}
  {$define typeofit := WideString}
  {$define typename := TWideStringArray}
  {$include cl_dyna_1template.inc}
 {$undef header}

 
 {$ifdef _header}
 var
   _UniToAnsiTable: array[0..$FFFF] of AnsiChar;
   _AnsiToUniTable: array[AnsiChar] of WideChar;

 procedure InitUnicode;
 
(* function AnsiToUni(s: AnsiString): TUni;
 function WideToUni(w: WideString): TUni;*)
 function WideToAnsi(u: WideString): AnsiString; OVERLOAD;
 function AnsiToWide(a: AnsiString): WideString;
 function TrimWideString (u: WideString): WideString;
 function WideReplace(u: WideString; a, b: AnsiString): WideString; OVERLOAD;
 function WideReplace(u: WideString; a: AnsiString; b: WideString): WideString; OVERLOAD;
 function WideReplace(u, a, b: WideString): WideString; OVERLOAD;
 function WidePos(a, u: WideString): integer;
 
(* function JoinUnis(a, b: TUni): TUni;
 function Empty(u: TUni): boolean;
 function ArrayToUni(a: TUniArray): TUni;
 function UniToArray(u: TUni): TUniArray;
 function UniPos(a, u: TUni): integer; OVERLOAD;
 function UniPos(a: AnsiString; u: TUni): integer; OVERLOAD;
 procedure UniReplace(u: TUni; a, b: AnsiString); OVERLOAD;
 procedure UniReplace(u: TUni; a: AnsiString; b: TUni); OVERLOAD;
 procedure UniReplace(u, a, b: TUni); OVERLOAD;
 function CopyUni(u: TUni): TUni;
 procedure TrimUni(u: TUni);*)
 
 {$else _header}
{ operator + (a, b: TUni): TUni;
 var j, l: integer;
 begin
   Result:=TUni.Create;
   if Assigned(a) then begin
     Result.Length:=a.Length;
     For j:=0 to a.high do Result[j]:=a.[j];
     a.Free;
   end;
   if Assigned(b) then begin
     l:=Result.Length;
     Result.Length:=l + b.Length;
     For j:=0 to b.high do Result[l + j]:= b[j];
     b.Free;
   end;
 end;}
 
 procedure InitUnicode;
 var
   j: integer;
   a: AnsiChar;
 begin
   For j:=0 to 127 do _UniToAnsiTable[j]:=chr(j);
   For j:=128 to $FFFF do _UniToAnsiTable[j]:='?';
   For j:=$0410 to $044F do _UniToAnsiTable[j]:=chr($C0 + j - $0410); //Russian alphabet
   For a:=#0 to #127 do _AnsiToUnitable[a]:=a;
   For a:=#128 to #$FF do _AnsiToUnitable[a]:='?';
   For a:=#$C0 to #$FF do _AnsiToUnitable[a]:=WideChar($0410 + ord(a) - $C0); //Russian alphabet
 end;
 

(* function AnsiToUni(s: AnsiString): TUni;
 var j: integer;
 begin
   Result:=TUni.Create;
   For j:=1 to Length(s) do Result.Add(_AnsiToUniTable[s[j]]);
 end;

 function WideToUni(w: WideString): TUni;
 var j: integer;
 begin
   Result:=TUni.Create;
   For j:=1 to Length(w) do Result.Add(PWideChar(@w[j])^);
 end;          *)

 
 function WideToAnsi(u: WideString): AnsiString;
 var
   j: integer;
 begin
   Result:='';
   For j:=1 to Length(u) do Result:=Result + _UniToAnsiTable[ord(u[j])];
 end;

 function AnsiToWide(a: AnsiString): WideString;
 var
   j: integer;
 begin
   Result:='';
   For j:=1 to Length(a) do Result:=Result + _AnsiToUniTable[a[j]];
 end;

 function TrimWideString (u: WideString): WideString;
 var j, a, b: integer;
 begin
   Result:='';
   a:=1;
   While (a < length(u)) and (ord(u[a]) <= 32) do inc(a);
   b:=length(u);
   While (b > 1) and (ord(u[a]) <= 32) do dec(b);
   if a > b then exit
   else
     For j:=a to b do Result:=Result + u[j - a + 1];
 end;

 
(* function JoinUnis(a, b: TUni): TUni;
 var j: integer;
 begin
   if Assigned(a) and Assigned(b) then begin
     For j:=0 to b.high do a.Add(b[j]);
     b.Free;
   end;
   Result:=a;
 end;
 
 function Empty(u: TUni): boolean;
 begin
   Result:= (not Assigned(u)) or (u.Length <= 0);
 end;
 
  function ArrayToUni(a: TUniArray): TUni;
  var j, i, s: integer;
  begin
    s:=0;
    For j:=0 to a.High do inc(s, a[j].Length);
    inc(s, 2*(a.Length - 1));
    Result:=TUni.Create;
    Result.Length:=s;
    s:=0;
    For j:=0 to a.High do begin
      For i:=0 to a[j].High do Result[i + s]:=a[j][i];
      if j < a.High then begin
        Result[a[j].Length + s]:=#10;
        Result[a[j].Length + 1 + s]:=#13;
      end;
      inc(s, a[j].Length + 2);
    end;
  end;
  
 function UniToArray(u: TUni): TUniArray;
 var j: integer;
 begin
   Result:=TUniArray.Create;
   Result.Increment;
   j:=0;
   While j <= u.High do begin
     if ord(u[j]) = 13 then Result.Increment;
     if ord(u[j]) >=32 then Result.Last.Add(u[j]);
     inc(j);
   end;
 end;
 
*)
 function WideReplace(u: WideString; a, b: AnsiString): WideString; OVERLOAD;
 begin
   Result:=WideReplace(u, AnsiToWide(a), AnsiToWide(b));
 end;
 
 function WideReplace(u: WideString; a: AnsiString; b: WideString): WideString; OVERLOAD;
 begin
   Result:=WideReplace(u, AnsiToWide(a), b);
 end;


function WideCOPY(s: WideString; pos, len: integer): WideString;
var i: integer;
begin
  Result:='';
  For i:=pos to pos + len - 1 do begin
    if i > Length(s) then Exit;
    Result:=Result + s[i];
  end;
end;

function WideReplace(u, a, b: WideString): WideString; OVERLOAD;
var p: integer;
    s: WideString;
begin
  s:=u;
  p:=WidePos(a, s);
  While p > 0 do begin
    s:=WideCOPY(s, 1, p - 1) + b + WideCOPY(s, p + Length(a), Length(s));
    p:=Pos(a, s);
  end;
  Result:=s;
end;

 function WidePos(a, u: WideString): integer;
 var
   j, i: integer;
 begin
   Result:=-1;
   For j:=1 to length(u) do begin
     i:=1;
     While (i < Length(a) + 1) and (a[i] = u[i + j - 1]) do inc(i);
     if i = (Length(a) + 1) then begin
       Result:=j;
       Exit;
     end;
   end;
 end;

 (*
 function UniPos(a: AnsiString; u: TUni): integer;
 var a2: TUni;
 begin
   a2:=AnsiToUni(a);
   Result:=UniPos(a2, u);
   a2.Free;
 end;

 function CopyUni(u: TUni): TUni;
 var j: integer;
 begin
   Result:=TUni.Create;
   if not Assigned(u) then Exit;
   Result.Length:=u.Length;
   For j:=0 to u.High do Result[j]:=u[j];
 end;
 
 procedure TrimUni(u: TUni);
 var j, a, b: integer;
 begin
   a:=0;
   While (a < u.High) and (ord(u[a]) <= 32) do inc(a);
   b:=u.High;
   While (b > 0) and (ord(u[a]) <= 32) do dec(b);
   if a > b then u.Length:=0
   else begin
     if a > 0 then For j:=a to b do u[j - a]:=u[j];
     u.Length:=b - a + 1;
   end;
 end;*)

 {$endif _header}


