{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the basics of cge core.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}


{$mode delphi}
{$macro on}

unit cl_hub;

{$define cge}

interface
  uses cl_typedefs, SysUtils
        {$ifdef unix} , x, xlib, xutil, dl {$else}, Windows {$endif} , {syncobjs,}
       Classes, cl_preinityells, IniFiles,
       cl_translit, cl_classes, cl_dyna, cl_filelist, cl_strings,
       cl_splashscreen, cl_gl_core, cl_modman, cl_container;


(*Hi, I've had a short look at your files (especialy lua.pas).

1. Don't use libC in unix, use baseunix and unix units instead.
2. Don't use {$IFDEF LINUX} but {$IFDEF UNIX} or {$IFNDEF MSWINDOWS} otherwise BSD and other unices won't work

I haven't been able to get it to compile on my FreeBSD yet due to afforementioned problems but I'll try tomorrow and see what I can see Smile

I'll keep you posted.*)

{$ifdef unix}
  {$define MACROS}
  {$ifdef linux}
    {$define Linked_with_xf86vm} //undefine to link without the video mode switching support
  {$endif}
  {$ifdef Linked_with_xf86vm}
    {$LinkLib Xext}
    {$Linklib Xxf86vm}
  {$endif}
{$endif}

{$define _header}



// ---------=========*******   *******========-------

CONST
  CGEString = 'Cheb''s Game Engine';

  {$INCLUDE texsages_list.inc}

  {$include cl_unicode.inc}

  {$INCLUDE texsages_h.inc}
  

type
  //float = single;
  EFake = class(Exception);
  EDying = class(Exception);

var
  RunningOneShot: boolean;

  MainIni: TMemIniFile;
  StartDir, WorkingDir, AppNick: String;
  DebugMode: boolean = No;
  AbortHotKey, MainModuleHotKey, ConsoleToggleHotkey, ConsoleScrollUpHotkey, ConsoleScrollDownHotkey
     : TIntegerArray;
  CgeStartTime, SecondStageInitTime: TDateTime;
  CgeStartingTick: longint;
  DontWriteALog: boolean;

  WarningQueue: TAOW;

  BoolChars: array[boolean] of string = ('false', 'true');

  function Tick: longint; //miliseconds since CGE start;

  Procedure Die(YellID :TMessageID; Param: array of const); OVERLOAD;
  Procedure Die(YellID :TMessageID); OVERLOAD;
  Procedure Warning(YellID :TMessageID; Param: array of const); OVERLOAD;
  Procedure Warning(YellID :TMessageID); OVERLOAD;
  Procedure ClearWarningQueue;
  Function IsWarningQueueEmpty: boolean;
  Function PullWarningsFromQueue: WideString;

  Procedure Die(AnsiYell: AnsiString); OVERLOAD;

  Procedure PreInitDie(Yell: AnsiString);
  procedure DisplayDyingYells;

  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
//  function PervertedFormat(A: WideStringArray; P: array of const): WideString; OVERLOAD;
  function StrOrUndefined(U: WideString): WideString;

  Procedure AddLog(S: AnsiString); OVERLOAD;
  Procedure VerboseLog(S: AnsiString); OVERLOAD;
  Procedure AddLog(U: WideString); OVERLOAD;
  Procedure AddLog(mID: TMessageID); OVERLOAD;
  Procedure AddLog(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure VerboseLog(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure AddLog(U: WideString; Param: array of const); OVERLOAD;
  Procedure AddLog(mID: TMessageID; Param: array of const); OVERLOAD;
  Procedure AddLogOK;
  Procedure AddLogComment(S: AnsiString; Param: array of const); OVERLOAD;
  Procedure AddLogComment(U: WideString; Param: array of const); OVERLOAD;
  Procedure AddLogComment(mID: TMessageID; Param: array of const); OVERLOAD;
  Procedure AddLogComment(S: AnsiString); OVERLOAD;
  Procedure AddLogComment(U: WideString); OVERLOAD;
  Procedure AddLogComment(mID: TMessageID); OVERLOAD;
  
  Procedure DbgSay(Yell: AnsiString);
  
  Function ExportHostProc(i: integer): pointer;

  function RunningInWindows9x: boolean;
  
  procedure GetHotKeysFromConfig;
  
  function RuEn(Ru, En: string): string;
  function CGEPath(s: string): string;

 {$include cl_conflimits.inc}

 {$include cl_confman_h.inc}

 {$include cl_talesteller.inc}

 {$include cl_winman_h.inc}

 {$include cl_window_h.inc}

 {$undef _header}
 
  //some of the exported functions, to be used by console:
  function CgeGenTexture (Name: AnsiString): glUint;
//  procedure PrepareToDecodePic (DirPack, FileName: AnsiString; var width, height: integer; var mode: TImageMode);
  procedure PrepareToDecodePic (ContainerName: AnsiString; var width, height: integer; var mode: TImageMode);
  procedure DecodePic (OutBuff: Pointer);
  function CreateContainerFromFile (Name, PackName, FileName: AnsiString; var Size: integer): pointer;
  procedure DeleteContainer (Name: AnsiString);


var
  MCInitialized: boolean = No; //is message container initialized yet?..
    
implementation
  uses cl_libpng, cl_piccodec, cl_console;

   {$include cl_exported_func.inc}

  Procedure PreInitDie(Yell: AnsiString);
  //all error messages given before MessageContainer is initialized
  // are in English, so there's no need for unicode...
  begin
   {$ifdef win32}
    MessageBox(0, PChar(Yell), PChar(CGEString + ' crashed at startup!'), MB_ICONERROR + MB_OK);
   {$else}
    WriteLn(#10#13#10#13#10#13 + ExtractFileName(CGEString + ' crashed at startup!'));
    Writeln(#10#13 + Yell + #10#13);
    Writeln('Press Enter to close.');
    ReadLn;
   {$endif}
    Halt(1);
  end;

 {$ifdef win32}
   function MessageBoxA(w1:longint;l1,l2:pointer;w2:longint):longint; stdcall; external 'user32' name 'MessageBoxA'; 
   function MessageBoxW(w1:longint;l1,l2:pointer;w2:longint):longint; stdcall; external 'user32' name 'MessageBoxW';   
 {$endif}  
  
  procedure DisplayDyingYells;
  var
    tit, DyingYell: WideString;
    titA: AnsiString;
    i: integer;
  begin
    DyingYell:='';
    For i:=WarningQueue.High downto 0 do begin
      DyingYell:=DyingYell + WarningQueue[i];
      if i > 0 then DyingYell:=DyingYell + #10#13#10#13;
    end;
    ClearWarningQueue;
    {$ifdef win32}
     tit:=MessageContainer[MI_CGE_TITLE] + #0;
     titA:=WideToAnsi(tit);
     MessageBeep($FFFFFFFF);
     if RunningInWindows9x
       then MessageBoxA(0, PChar(WideToAnsi(DyingYell)), @(titA[1]), MB_ICONERROR + MB_OK)
       else begin
         DyingYell:=DyingYell + #0;
         MessageBoxW(0, @(DyingYell[1]), @(tit[1]), MB_ICONERROR + MB_OK);
       end;
    {$else}
     WriteLn(#10#13#10#13#10#13 + ExtractFileName(ParamStr(0) + ' crashed!'));
     Writeln(#10#13 + WideToAnsi(DyingYell) + #10#13);
     Writeln('Press Enter to close.');
     ReadLn;
    {$endif}
  end;

  function RunningInWindows9x: boolean;
  begin
   {$ifdef win32}
    Result := {(Win32Platform = VER_PLATFORM_WIN32_WINDOWS) and}
      (Win32MajorVersion < 5) {and (WIN32MinorVersion <= 1)}
   {$else}
    Result:=No;
   {$endif}
  end;


  Procedure DbgSay(Yell: AnsiString);
  begin
   {$ifdef win32}
    MessageBox(0, PChar(Yell), PChar(''), MB_ICONINFORMATION + MB_OK);
   {$else}
    Writeln(#10#13 + Yell);
    Writeln('Press Enter.');
    ReadLn;
   {$endif}
  end;

 {$include cl_unicode.inc}

  function LoadUnicodeText(FileName: string): TWideStringArray;
  var
    f: file;
    h: WideChar;
    u: WideString;
  begin
    if not FileExists(FileName) then
      if MCInitialized
        then Die(MI_ERROR_FILE_NOT_FOUND, [FileName])
        else PreInitDie('File "' + Filename + '" does not exist.');
    Try
      Assign(f, FileName);
      Reset(f, 2);
      BlockRead(f, h, 1);
      if ord(h) <> $FEFF then PreInitDie('"' + Filename + PIYTxtNotUtf16);
      Result:=TWideStringArray.Create;
      u:='';
      While not eof(f) do begin
        BlockRead(f, h, 1);
        if (ord(h) > 32) or ((Length(u) > 0) and (ord(h) >= 32)) then u:=u + h;//w + h; //ignore spaces in the beginning
        if ord(h) = 13 then begin
          Result.Add(u);
          u:='';
        end;
      end;
      if u<>'' then Result.Add(u) else u:='';
      Close(f);
    Except
      if MCInitialized
        then Die(MI_ERROR_INVALID_UNICODE_TEXT,[FileName])
        else PreInitDie('"' + Filename + PIYTxtReadFailed);
    End;
  end;

  {$include cl_texsages.inc}

  function VarRecToWide(V: TVarRec): WideString;
  begin
    Case V.Vtype of
      vtInteger:    Result := IntToStr(V.VInteger);
      vtBoolean:    Result := AnsiToWide(BoolChars[V.VBoolean]);
      vtChar:   Result := AnsiToWide(V.VChar);
      vtWideChar:   Result:=V.VWideChar;
      vtExtended:   Result := FloatToStr(V.VExtended^);
      vtAnsiString: Result := AnsiString(V.VAnsiString);
      vtWideString: Result := WideString(V.VWideString);
//      vtPChar:      Result := AnsiToWide(PCharToString(V.VPChar));
      vtObject:     Result := V.VObject.ClassName;
      vtClass:      Result := V.VClass.ClassName;
      vtPointer:    Result := Format('%P',[V.VPointer]);
     {
      //not supported in the FreePascal 1.0.6
      vtCurrency:   Result := CurrToStr(V.VCurrency^);
      vtVariant:    Result := string(V.VVariant^);
      }
      vtInt64:      Result := IntToStr(V.VInt64^);
    else
      Result:='?unknown VarRec type?';
    end;
  end;

{  procedure PervertedFormat(A: WideStringArray; P: array of const);
  var u: WideString;
  begin
    u:=ArrayToUni(A);
    a.Free;
    PervertedFormat(u, p);
    A:=UniToArray(u);
    u.Free;
  end;}

  function PervertedFormat(U: WideString; P: array of const): WideString; //OVERLOAD;
  var
    j: integer;
    R, b, e: WideString;
  begin
    e:='';
    For j:=0 to High(p) do begin
      b:=VarRecToWide(P[j]);
      if WidePos('%' + IntToStr(j), U) < 1
        then e:=e + '  [' + b + ']  '
        else u:=WideReplace(u, '%' + IntToStr(j), b);
    end;
    if e <> '' then begin
      e:=' +FORMAT ERROR!! ' + e;
    end;
    Result:=u + e;
  end;
  
  function StrOrUndefined(U: WideString): WideString;
  begin
    if U='' then Result:=MessageContainer[MI_UNDEFINED]
            else Result:=U;
  end;

 {$ifdef win32}
  function Win32LastError: WideString;
  var
    M: Cardinal;
    u: WideString;
  begin
    M:=GetLastError;
    if M = ERROR_SUCCESS then Result:=''
    else begin
      if RunningInWindows9x
        then u:=AnsiToWide(SysErrorMessage(M))
        else u:=SysErrorMessage(M);
      Result:=#10#13 + Result + #10#13 + PervertedFormat(
        MessageContainer[MI_WIN32_EXPLAINS],
        [IntToHex(M, 8), u]);
    end;
  end;
 {$endif}


  Procedure Die(YellID :TMessageID; Param: array of const);
  var
    U: WideString;
    Ey: AnsiString;
  begin
    U:=PervertedFormat(MessageContainer[YellID], Param);
    if not((ExceptObject as Exception) is EDying) then
      U:=U + #10#13#10#13 + ToldException(ExceptObject as Exception);
    {$ifdef win32}
      //..  
      //   WinAPI GetLastEror (  Win32LastEror)
//      U:= U + Win32LastError;
//      SetLastError(0);
    {$endif}
    AddLog(U);
    Ey:=WideToAnsi(U);
    WarningQueue.Add(U);
    raise EDying.Create(Ey);
  end;
  
  Procedure Die(AnsiYell: AnsiString);
  var
    U: WideString;
    c: integer;
  begin
    U:=AnsiToWide(AnsiYell);
    AddLog(U);
    WarningQueue.Add(U);
    raise EDying.Create(AnsiYell);
  end;

  Procedure Die(YellID :TMessageID);
  begin
    Die(YellId, []);
  end;
  
  Procedure Warning(YellID :TMessageID; Param: array of const); OVERLOAD;
  var
    U: WideString;
  begin
    U:=PervertedFormat(MessageContainer[YellID], Param);
    WarningQueue.Add(U);
  end;
  
  Procedure Warning(YellID :TMessageID); OVERLOAD;
  begin
    Warning(YellID, []);
  end;

  Procedure ClearWarningQueue;
  var c: integer;
  begin
    WarningQueue.Length:=0;
  end;

  Function IsWarningQueueEmpty;
  begin
    Result:=(WarningQueue.Length = 0);
  end;

  Function PullWarningsFromQueue: WideString;
  var
    i: integer;
    r: WideString;
  begin
    r:='';
    For i:=WarningQueue.High downto 0 do begin
      r:=r + WarningQueue[i];
      if i > 0 then r:=r + #10#13#10#13;
    end;
    ClearWarningQueue;
    Result:=r;
  end;


//  function PervertedFormat(U: WideString; P: array of const): WideString;

//  function PervertedFormat(A: WideStringArray; P: array of const): WideString;

{  var
    w, w2: WideString;
    j: integer;
  begin
    Result:=TAOW.Create;
    w:=PervertedFormatStr(S, P);
    j:=1;
    Repeat
      w2:=Strparm(w, j, #13);
      if w2 <> '' then Result.Add(w2);
    until w2='';
    For j:=0 to Result.High - 1 do Result[j]:=Result[j] + #13;
  end;
 }
  Procedure AddLog(S: Ansistring; Param: array of const);
  begin
    AddLog(AnsiToWide(S), Param);
  end;

  Procedure AddLog(U: WideString; Param: array of const);
  var
    j, i: integer;
    h: WideChar;
    f: file of WideChar;
  begin
    U:= PervertedFormat(U, Param) + #10#13;
    AssignFile(f, WorkingDir + 'LOG');
   {$ifdef unix}
    WriteLn(WideToAnsi(U));
   {$endif}
   
    if Assigned(Console) then Console.Add(WideToAnsi(U));

    if DontWriteALog then Exit; //a special case. We don't want to ruin
                                //the log of the already running instance.
    
    if not fileexists(WorkingDir + 'LOG')
      then begin
        Rewrite(f);
        h:=#$FEFF;//unicode utf-16 text signature
        Write(f, h);
      end
      else begin
        Reset(f);
        Seek(f, FileSize(f) - 1);
      end;
    For i :=1 to length(U) do
        write(f, U[i]);
    CloseFile(F);
  end;

  Procedure AddLog(mID: TMessageID; Param: array of const);
  begin
    AddLog(MessageContainer[mID], Param);
  end;

  Procedure AddLog(mID: TMessageID);
  begin
    AddLog(MessageContainer[mID], []);
  end;

  Procedure AddLogComment(S: AnsiString; Param: array of const);
  begin
    AddLogComment(AnsiToWide(S), Param);
  end;

  Procedure AddLogComment(U: WideString; Param: array of const);
  begin
    AddLog('...' + U, Param);
  end;

  Procedure AddLogComment(mID: TMessageID; Param: array of const);
  begin
    AddLogComment(MessageContainer[mID], Param);
  end;

  Procedure AddLogComment(S: AnsiString);
  begin
    AddLogComment(S,[]);
  end;

  Procedure AddLogComment(U: WideString);
  begin
    AddLogComment(U,[]);
  end;


  Procedure AddLogComment(mID: TMessageID);
  begin
    AddLogComment(mID,[]);
  end;


  Procedure AddLogOK;
  begin
    AddLogComment(MessageContainer[MI_LOG_SUCCESS]);
  end;

  Procedure AddLog(S: AnsiString);
  begin
    AddLog(S, []);
  end;

  Procedure AddLog(U: WideString);
  begin
    AddLog(U, []);
  end;

  Procedure VerboseLog(S: AnsiString; Param: array of const);
  begin
    if DebugMode then AddLog(S, Param);
  end;

  Procedure VerboseLog(S: AnsiString);
  begin
    if DebugMode then AddLog(S, []);
  end;
  
  procedure GetHotKeyFromConfig(par: string; var HK: TIntegerArray);
  var
    str: string;
    i: integer;
  begin
    Try
      str:=Config.Str['main', par];
      i:=1;
      While StrParm(str, i, [',']) <> '' do begin
        System.SetLength(HK, i);
        HK[i - 1]:=StrToInt(StrParm(str, i, [',']));
        inc(i);
      end;
    Except
      Die(MI_INVALID_HOST_HOTKEY_RECORD, ['main', par, str]);
    End;
  end;

  procedure GetHotKeysFromConfig;
  begin
    GetHotKeyFromConfig('Abort_Hotkey', AbortHotKey);
    GetHotKeyFromConfig('Main_Module_Hotkey', MainModuleHotKey);
    GetHotKeyFromConfig('Console_Toggle_Hotkey', ConsoleToggleHotkey);
    GetHotKeyFromConfig('Console_Scroll_Up_Hotkey', ConsoleScrollUpHotkey);
    GetHotKeyFromConfig('Console_Scroll_Down_Hotkey', ConsoleScrollDownHotkey);
  end;
  
  function CGEPath(s: string): string;
  begin
    Result:=s;
    if  (Result = '') or ({$ifdef win32} ExtractFileDrive(Result) = ''{$else} Result[1] <> '/'{$endif})
    then Result:=WorkingDir + Result;
    Result:=OptiPath(StrReplace(Result, '{$PLATFORM}', SystemSuffix)) + ExtractFileName(Result);
  end;
  
  function RuEn(Ru, En: string): string;
  begin
    if UpperCase(MessageContainer.Language) = 'RUSSIAN'
      then Result:=Ru
      else Result:=En;
  end;

  function Tick: longint;
  begin
    //{$ifdef Win32}
    // Result:=GetTickCount() - CgeStartingTick;
    //{$else}

     // Rough. Rounds to 15..16 ms.
     Result:=round((Now() - CgeStartTime) * 86400000.0);
    //{$endif}
  end;


  {$i cl_confman.inc}

  {$include cl_winman.inc}
  
  {$include cl_window.inc}

  {$i cl_talesteller.inc}

end.
