{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains header for the message manager class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

type
  TMessageContainer = class
    constructor Create(languageID: AnsiString);
    procedure Reload(languageID: AnsiString);
    destructor Destroy; OVERRIDE;
  protected
    E: array [TMessageID] of WideString;
    MS: array [TMessageID] of AnsiString;
    LID: AnsiString;
//    Translitom: boolean;
    extra, missing: string;
    procedure R(mID: TMessageID; mIDstr: AnsiString);
    function _e(index: TMessageID): WideString;
    function _ms(index: TMessageID): AnsiString;
    procedure Load(languageID: AnsiString);
  public
    Property M[index: TMessageID]: WideString read _e; DEFAULT;
    property Language: AnsiString read LID;
    property IDString[index: TMessageID]: AnsiString read _ms;
  end;
var
  MessageContainer: TMessageContainer;
