{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the functions exported from the engine core
      to the module DLL.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

   //**********
   // Shit! The variables of overloaded functions are not allowed... :(

    Procedure DieE(YellID :TMessageID; Param: array of const);
    begin
      Die(YellId, Param);
    end;
    procedure DieA (AnsiYell: AnsiString);
    begin
      Die(AnsiYell);
    end;
    Procedure VerboseLogA(S: AnsiString; Param: array of const);
    begin
      VerboseLog(S, Param);
    end;
    procedure AddLogA (S: AnsiString; Param: array of const);
    begin
      AddLog(S, Param);
    end;
    procedure AddLogE (mID: TMessageID; Param: array of const);
    begin
      AddLog(mID, Param);
    end;


//********** EXPORTED FUNCTIONS ************************************

  function GetModNum: integer;
  begin
    Result:=ModuleManager.NumLevels;
  end;
  function GetModName(num: integer): AnsiString;
  begin
    Result:=ModuleManager.ModuleName(num);
  end;
  procedure ValidateTypesets(i, j: integer);
  begin
    Case j of
      0: if i <> ord (MI_STUB) then Die(MI_ERROR_TYPESETS_MISMATCH,['TMessageId']);
      1: if i <> ord (Re_Stub) then Die(MI_ERROR_TYPESETS_MISMATCH,['TCbMessage']);
    else
      Die(MI_ERROR_TYPESETS_MISMATCH,['ValidateTypesets()']);
    end;
  end;
  procedure RequestExit;
  begin
    TheWindow.ExitRequested:=Yes;
  end;

     procedure DiePack;
     begin
       Die('CGE v.'+VersionString+' doesn''t yet support the pack files!');
     end;

  var
    CurrentCodec: TImageCodec;
    CurrentStream: TStream;
    CurrentFile, CurrentDirPack: AnsiString;
(*
  procedure PrepareToDecodePic (DirPack, FileName: AnsiString; var width, height: integer; var mode: TImageMode);
  var
    ext, cn: AnsiString;
  begin
    cn:='';
    Try
      if DirPack<>'' then DiePack;
      ext:=UpCase(ExtractFileExt(FileName));
      if Assigned(CurrentCodec) then CurrentCodec.Free;
      if ext='.PNG' then CurrentCodec:=TPngCodec.Create else
{      if ext='.TGA' then CurrentCodec:=TTgaCodec.Create else
      if ext='.BMP' then CurrentCodec:=TBmpCodec.Create else
      if ext='.PCX' then CurrentCodec:=TPcxCodec.Create else
      if ext='.LBM' then CurrentCodec:=TPcxCodec.Create else     }
          Die('CGE v.'+VersionString+' doesn''t support image file format "'+ext+'"!');
      cn:=CurrentCodec.ClassName;
      CurrentStream:=TFileStream.Create(FileName, fmOpenRead);
      CurrentCodec.PrepareToDecode(CurrentStream, width, height, mode);
      CurrentFile:=FileName;
      CurrentDirPack:=DirPack;
    Except
      CurrentStream.Free;
      CurrentStream:=nil;
      Die(MI_CRASHED_DECODING_PIC, [FileName, StrOrUndefined(DirPack), StrOrUndefined(cn)]);
    End;
  end;
*)
  function GetContainerObject (Name: AnsiString): TContainer;
  var
    i: integer;
  begin
    i:=Containers.IndexOf(Name);
    if i < 0 then Result:=nil
    else Result:=Containers.Objects[i] as TContainer;
  end;

  procedure PrepareToDecodePic (ContainerName: AnsiString; var width, height: integer; var mode: TImageMode);
  var
    ext, cn, FileName: AnsiString;
  begin
    cn:='';
    Try
      if Assigned(CurrentCodec) then CurrentCodec.Free;
      CurrentStream:=GetContainerObject(ContainerName);
      FileName:=(CurrentStream as TContainer).FileName;
      ext:=UpperCase(ExtractFileExt(FileName));
      if ext='.PNG' then CurrentCodec:=TPngCodec.Create else
{      if ext='.TGA' then CurrentCodec:=TTgaCodec.Create else
      if ext='.BMP' then CurrentCodec:=TBmpCodec.Create else
      if ext='.PCX' then CurrentCodec:=TPcxCodec.Create else
      if ext='.LBM' then CurrentCodec:=TPcxCodec.Create else     }
          Die('CGE v.'+VersionString+' doesn''t support image file format "'+ext+'"!');
      cn:=CurrentCodec.ClassName;
      CurrentCodec.PrepareToDecode(CurrentStream, width, height, mode);
      CurrentFile:=FileName;
      CurrentDirPack:=ContainerName;
    Except
      CurrentStream.Free;
      CurrentStream:=nil;
      Die(MI_CRASHED_DECODING_PIC, [StrOrUndefined(FileName), StrOrUndefined(ContainerName), StrOrUndefined(cn)]);
    End;
  end;
  
  
  procedure DecodePic (OutBuff: Pointer); //Output buffer
                                    // must be allocated by the caller!
  var
    cn: string;
  begin
    cn:='';
    Try
      cn:=CurrentCodec.ClassName;
      CurrentCodec.Decode(OutBuff);
      //CurrentStream.Free;
      CurrentStream:=nil;
      CurrentCodec.Free;
      CurrentCodec:=nil;
      CurrentFile:='';
    Except
      Die(MI_CRASHED_DECODING_PIC, [StrOrUndefined(CurrentFile),
              StrOrUndefined(CurrentDirPack), StrOrUndefined(cn)]);
    End;
  end;

  procedure EncodePic(DirPack, FileName: AnsiString; Image: pointer; width, height:   //encoding type is determined
                       integer; mode: TImageMode); //by file name's extension
  var
    ext, cn: AnsiString;
    C: TImageCodec;
    S: TStream;
  begin
    FileName:=OptiPath(FileName) + ExtractFileName(FileName);
    cn:='';
    Try
      if DirPack<>'' then DiePack;
      ext:=UpCase(ExtractFileExt(FileName));
      if ext='.PNG' then C:=TPngCodec.Create
        else Die('Writing images in the "'+ext+'" format isn''t supported!');
      cn:=C.ClassName;
      S:=TFileStream.Create(FileName, fmCreate);
      C.Encode(S, Image, width, height, mode);
      C.Free;
      S.Free;
    Except
      Die(MI_CRASHED_ENCODING_PIC, [FileName,
           StrOrUndefined(DirPack), StrOrUndefined(cn)]);
    End;
  end;
  procedure ValidateVersion (s: AnsiString);
  begin
    if s <> VersionString then
      DIE(MI_VERSIONS_MISMATCH, [s, VersionString]);
  end;
  function GetBaseDir: WideString;
  begin
    Result:=StartDir;
  end;

  function CreateContainer(Name: AnsiString; Size: integer): pointer;
  var
    i: integer;
    C: TContainer;
  begin
    i:=Containers.IndexOf(Name);
    if i < 0
      then C:=TContainer.Create
      else C:=Containers.Objects[i] as TContainer;
    C.SetSize(Size);
    Result:=C.Memory;
    if i < 0
      then Containers.AddObject(Name, C);
  end;
  
  function GetContainer (Name: AnsiString): pointer;
  var
    i: integer;
  begin
    i:=Containers.IndexOf(Name);
    if i < 0 then Result:=nil
    else Result:=(Containers.Objects[i] as TContainer).Memory;
  end;
  
  function GetContainerSize (Name: AnsiString): integer;
  var
    i: integer;
  begin
    i:=Containers.IndexOf(Name);
    if i < 0 then Result:=0
    else Result:=(Containers.Objects[i] as TContainer).GetSize;
  end;
  
  procedure DeleteContainer (Name: AnsiString);
  var
    i: integer;
  begin
    i:=Containers.IndexOf(Name);
    if i < 0 then Exit;
    Containers.Objects[i].Free;
    Containers.Delete(i);
  end;
  
  procedure StoreContainerToFile (Name, PackName, FileName: AnsiString);
  var
    i: integer;
    F: TFileStream;
  begin
    if PackName<>'' then DiePack;
    i:=Containers.IndexOf(Name);
    if i < 0 then Die (MI_ERROR_ATTEMPT_TO_STORE_NONEXISTENT_CONTAINER,
      [Name, StrOrUndefined(Packname), FileName]);
    F:=TFileStream.Create(StartDir + Name, fmCreate);
    With (Containers.Objects[i] as TContainer) do
      F.Write(Memory, GetSize);
    F.Free;
  end;
  
  function CreateContainerFromFile (Name, PackName, FileName: AnsiString; var Size: integer): pointer;
  var
    i: integer;
    C: TContainer;
  begin
    if PackName<>'' then DiePack;
    i:=Containers.IndexOf(Name);
    if i < 0
      then begin
        C:=TContainer.Create;//(ModuleManager.ActiveModule.Num)
        C.FileName:=FileName;
      end
      else C:=Containers.Objects[i] as TContainer;
    C.LoadFromFile(StartDir + FileName);
    Result:=C.Memory;
    Size:=C.GetSize;
    if i < 0
      then Containers.AddObject(Name, C);
  end;
  function InFullScreenMode: boolean;
  begin
    Result:=TheWindow.InFullScreenMode;
  end;
  procedure SwitchToWindowedMode;
  begin
    TheWindow.SwitchToWindowedMode;
  end;
  function SwitchToFullscreenMode(width, height, hertz: integer): boolean;
  begin
    Result:=TheWindow.SwitchToFullscreenMode(width, height, hertz);
  end;
  function DisplayWidth: integer;
  begin
    Result:=TheWindow.DisplayWidth;
  end;
  function DisplayHeight: integer;
  begin
    Result:=TheWindow.DisplayHeight;
  end;
  procedure CgeSwapBbuffers;
  begin
    TheWindow.SwapBuffers;
  end;

  function CgeGenTexture (Name: AnsiString): glUint;
  var
    i: integer;
    u: glUint;
  begin
    i:=TexContainer.IndexOf(Name);
    if i < 0
      then glGenTextures(1, @u)
      else u:=glUint(TexContainer.Objects[i]);
    Result:=u;
    if i < 0
      then TexContainer.AddObject(Name, TObject(u));
  end;
  
  function CgeHasTexture (Name: AnsiString): glUint;
  var
    i: integer;
  begin
    i:=TexContainer.IndexOf(Name);
    if i < 0
      then Result:=0
      else Result:=glUint(TexContainer.Objects[i]);
  end;

  procedure CgeDeleteTexture (Name: AnsiString);
  var
    i: integer;
    u: glUint;
  begin
    i:=TexContainer.IndexOf(Name);
    if i < 0 then Exit;
    u:=glUint(TexContainer.Objects[i]);
    glDeleteTextures(1, @u);
    TexContainer.Delete(i);
  end;

  Function ExportHostProc(i: integer): pointer;
  begin
    case i of
      0:  Result:=@DieE;
      1:  Result:=@DieA;
      2:  Result:=@VerboseLogA;
      3:  Result:=@AddLogA;
      4:  Result:=@AddLogE;
      5:  Result:=@AddLogOK;
      6:  Result:=@DbgSay;
      7:  Result:=@GetModNum;
      8:  Result:=@GetModName;
      //9:  Result:=@SwitchToModuleAtExitFromOnIdle;
      10: Result:=@GetGLProcAddress;
      11: Result:=@GetGLUProcAddress;
      12: Result:=@GetGLEXTProcAddress;
      13: Result:=@ValidateTypesets;
      14: Result:=@RequestExit;
      //15: Result:=@PrepareToDecodePic;
      16: Result:=@DecodePic;
      17: Result:=@EncodePic;
      18: Result:=@ValidateVersion;
      19: Result:=@GetBaseDir;
      20: Result:=@CreateContainer;
      21: Result:=@GetContainer;
      22: Result:=@GetContainerSize;
      23: Result:=@DeleteContainer;
      24: Result:=@StoreContainerToFile;
      25: Result:=@CreateContainerFromFile;
      26: Result:=@InFullScreenMode;
      27: Result:=@SwitchToWindowedMode;
      28: Result:=@SwitchToFullscreenMode;
      29: Result:=@DisplayWidth;
      30: Result:=@DisplayHeight;
      31: Result:=@CgeSwapBbuffers;
      32: Result:=@CgeGenTexture;
      33: Result:=@CgeHasTexture;
      34: Result:=@CgeDeleteTexture;
      35: Result:=@Tick;
      36: Result:=@PrepareToDecodePic;
    else
      Die(MI_ERROR_TYPESETS_MISMATCH,['exported functions list (there is no entry #' + IntToStr(i) + ')']);
    end;
  end;


//******************************************************************  
