{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains a template for dynamic array wrapper classes.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}



//    ,  FreePascal 1.06  
//  ,  ,   1.9.2 - , 
//     (Add, Last, SetRect,  ..)
//   ,    ...

{$MACRO ON}
{$MODE DELPHI}
{$RANGECHECKS OFF}

unit cl_Dyna;

interface
Uses SysUtils, cl_Classes, cl_Typedefs;

Type
{
  TAOP = array of pointer;
  TAOC = array of cardinal;
  TAOI = array of integer;
  TAOS = array of string;
  TAOB = array of LongBool;
  TAOO = array of TObject;
  T2DAOI = array of array of Integer;
  T2DAOS = array of array of String;
  T2DAOO = array of array of TObject;
}

  TDyna = Class(TObject)
    Constructor Create;
    Destructor Destroy; Override;
    procedure Resize(NewLen: integer);
    procedure Increment;
    procedure Decrement;
    procedure ClearMem; virtual; abstract;
    procedure SetRect(a, b: integer); virtual;
  Protected
    s, sm, es: integer;
    function GetSize: integer;
    function GetHigh: integer;
    procedure _Resize(L: integer); virtual; abstract;
    function _ReadDPTR: pointer; virtual; abstract;
  Public
    property High: integer read GetHigh;
    property Length: integer read s write Resize;
    property DPTR:pointer read _ReadDPTR;
  End;
  
// Gee! Look, people! Now you can use templates in Pascal!
// (though, in somewhat perverted way - through macros and compiler
//  directives - but it works nevertheless!..)

{$define header}

{$define typeofit := string}
{$define typename := TAOS}
{$define type2name := T2DAOS}
  {$include cl_dyna_2template.inc}
  
{$define typeofit := WideString}
{$define typename := TAOW}
{$define type2name := T2DAOW}
  {$include cl_dyna_2template.inc}


{$define typeofit := float}
{$define typename := TAOF}
{$define type2name := T2DAOF}
  {$include cl_dyna_2template.inc}
  
{$define typeofit := pointer}
{$define typename := TAOP}
{$define type2name := T2DAOP}
  {$include cl_dyna_2template.inc}

{$define typeofit := cardinal}
{$define typename := TAOC}
{$define type2name := T2DAOC}
  {$include cl_dyna_2template.inc}

{$define typeofit := integer}
{$define typename := TAOI}
{$define type2name := T2DAOI}
  {$include cl_dyna_2template.inc}

{$define cl_objecttype}
{$define typeofit := TObject}
{$define typename := TAOO}
{$define type2name := T2DAOO}
  {$include cl_dyna_2template.inc}
{$undef cl_objecttype}

{$undef header}


implementation


{$define cl_stringtype}

{$define typeofit := string}
{$define typename := TAOS}
{$define type2name := T2DAOS}
  {$include cl_dyna_2template.inc}

{$define typeofit := WideString}
{$define typename := TAOW}
{$define type2name := T2DAOW}
  {$include cl_dyna_2template.inc}

{$undef cl_stringtype}

{$define typeofit := float}
{$define typename := TAOF}
{$define type2name := T2DAOF}
  {$include cl_dyna_2template.inc}
  
{$define typeofit := pointer}
{$define typename := TAOP}
{$define type2name := T2DAOP}
  {$include cl_dyna_2template.inc}

{$define typeofit := cardinal}
{$define typename := TAOC}
{$define type2name := T2DAOC}
  {$include cl_dyna_2template.inc}

{$define typeofit := integer}
{$define typename := TAOI}
{$define type2name := T2DAOI}
  {$include cl_dyna_2template.inc}

{$define cl_objecttype}
{$define typeofit := TObject}
{$define typename := TAOO}
{$define type2name := T2DAOO}
  {$include cl_dyna_2template.inc}
{$undef cl_objecttype}

{ TDyna }

constructor TDyna.Create;
begin
  inherited;
  s:=0;
  sm:=0;
  es:=4;
end;

procedure TDyna.Decrement;
begin
  Assert(s > 0,'attempt to decrement TDyna, which length is zero');
  ReSize(s - 1);
end;

destructor TDyna.Destroy;
begin
  resize(0);
  inherited;
end;

function TDyna.GetHigh: integer;
begin
  Result:=s-1;
end;

function TDyna.GetSize: integer;
begin
  Result:=s;
end;

procedure TDyna.Increment;
begin
  ReSize(s+1);
end;

procedure TDyna.Resize(newLen: integer);
var t, n: integer;
begin
 { if sm=0 then begin
    if newLen=0 then Exit
    else begin
      sm:=NewLen;
    end;
  end
  else begin
    if newLen=0 then begin
      sm:=0;
    end
    else begin
      if NewLen > sm then begin
        sm:=((NewLen shr 3) + 1) shl 3;
      end
      else begin
        t:=sm shr 3;
        if (sm - NewLen > t) then begin
          sm:=NewLen;
        end;
      end;
    end;
  end; }
  sm:=NewLen;
  _Resize(NewLen);
  s:=NewLen;
end;

procedure TDYNA.SetRect(a, b: integer);
begin
  Assert(b = 1, 'TDyna: attempt to set second dimension of the one-dimensional array');
  Resize(a);
end;

end.
