{
    This file is part of the Cheb's Game Engine,
    Copyright (c) 2004-2006 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains source of the main program executable.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}

{$mode delphi}
{$ifdef win32}
  {$apptype gui}
{$endif}

{$ifdef win32}
  {$r cge.res} //application icon
{$endif}
(*
 ,       ,
   .      
      {$L resource.o}

,    - "!"   
(  ) -       
,   .
       :
:
type
  LPNOTIFYICONDATA = ^NOTIFYICONDATA;
var
  IconData: NOTIFYICONDATA;
...
Shell_NotifyIcon(NIM_ADD, LPNOTIFYICONDATA(@IconData));
   Delphi   ?*)



program cge;

uses
  Classes, SysUtils, cl_pms, cl_preinityells {$ifdef win32}, Windows {$endif},
  cl_hub, cl_dyna, cl_strings, cl_splashscreen, cl_typedefs,
  cl_libpng, cl_modman, cl_container, cl_console;

var
    f: file;
    EngineObject: TAOO;
    EverythingIsOk: boolean = Yes;
    name: AnsiString;

begin
    // ******** FIRST STAGE INIT:
    Try
      CgeStartTime:=Now();
     {$ifdef Win32}
      CgeStartingTick:=GetTickCount();
     {$endif}
      if not ThisIsAnOnlyInstance then DontWriteALog:=Yes;
     
      InitUnicode;
      WarningQueue:=TAOW.Create;
      EngineObject:=TAOO.Create;
      StartDir:=ExtractFilePath(ParamStr(0));
      AppNick:=UpperCase(ChangeFileExt(ExtractFileName(ParamStr(0)),''));

      Config:=TConfigManager.Create(OptiPath(StartDir {+ '..' + PathSlash}) + ChangeFileExt(ExtractFileName(ParamStr(0)),'.ini'));

      WorkingDir:=Config.Str['main', 'workingdir_' + SystemSuffix];
      if  (WorkingDir = '') or ({$ifdef win32} ExtractFileDrive(WorkingDir) = ''{$else} WorkingDir[1] <> '/'{$endif})
        then WorkingDir:=StartDir + WorkingDir;
      WorkingDir:=OptiPath(WorkingDir);
      SetCurrentDir(WorkingDir);

      DebugMode:=Config.Bool['main','debugmode'];

      MessageContainer:=TMessageContainer.Create(Config.Str['main', 'language']);
      MCInitialized:= Yes;

      if FileExists(WorkingDir + 'LOG') then Try
        AssignFile(f, WorkingDir + 'LOG');
        Erase(f);
      Except
        Raise Exception.Create(PIYCantDeleteOldLog + WorkingDir + 'LOG');
      end;

      Console:=TConsole.Create;

    Except
      //raise exception and die...
      PreInitDie((ExceptObject as Exception).Message);
    End;



    // ******** SECOND STAGE INIT:
    Try
      SecondStageInitTime:=Now();
      VerboseLog('First Stage Init took %0 miliseconds.',[Tick]);
      //AddLog(MessageContainer[MI_LOG_STARTED], [StrCurrentTime, MessageContainer.LID]);

      if DontWriteALog
        then Die(MI_ERROR_MULTIPLE_INSTANCES_NOT_ALLOWED,[MessageContainer[MI_CGE_TITLE]]);

      {$ifdef win32}SetLastError(0);{$endif}
      
      SetCurrentDir(StartDir);

      AddLog(MessageContainer[MI_CGE_TITLE] + ' initialization, stage 2.');
      VerboseLog('Initializing configuration manager...');
      Config.AttachOverrides;

      {$ifdef win32}
      AddLog(MI_MAZDAI_VER, [Win32MajorVersion, Win32MinorVersion]);
      {$endif}

      Randomize;

      CreateSplashWindow;
      
      GetHotKeysFromConfig;
      Containers:=TStringList.Create;
      TexContainer:=TStringList.Create;

      EngineObject.Add(TLibPngLoader.Create);
      LibPngLoader:=EngineObject.Last as TLibPngLoader;

      //resources loading here...
      VerboseLog('Creating the modules manager...');
      EngineObject.Add(TModuleManager.Create);
      ModuleManager:=EngineObject.Last as TModuleManager;

      VerboseLog('Creating the display/input manager...');
      EngineObject.Add(TCLWindowClass(TCGEWindow).Create);
      TheWindow:= EngineObject.Last as TCGEWindow;
      
      VerboseLog('Deleting the splash screen...');
      KillSplashWindow;
      
      Console.InitGL;
      
    Except
      EverythingIsOk:=No;
      Try
        Die(MI_DIED_INITIALIZING, ['CGE']);
      Except
      End;
    End;

    KillSplashWindow;

    // ******** MAIN LOOP:

    if EverythingIsOk then Try
      //VerboseLog('Second Stage Init took %0 seconds.',[(Now() - SecondStageInitTime) * 86400.0]);
      VerboseLog('Second Stage Init took %0 minutes %1 seconds.',[DateTimeToP(Now() - SecondStageInitTime, 0), DateTimeToP(Now() - SecondStageInitTime, 1)]);
      AddLog(MessageContainer[MI_CGE_TITLE] + ' initialized. Entering the main loop...');
      TheWindow.MainLoop;
      VerboseLog('...exited the main loop.');
    Except
        //fake exceptions are required due to the
        // rather paranoidal reaction of X server to closing the window -
        // it yells "fatal error!" and tries to kill our app on the spot...
        // so we will cheat and just won't return from the callback function,
        // but will raise this fake exception instead.
      if not (ExceptObject is EFake) then begin
        EverythingIsOk:=No;
        if not (ExceptObject is EDying) then Try
          Die(MI_ERROR_EXCEPTION);
        Except
        End;
      end;
    End;


    // ******** CLOSING SEQUENCE:
    While EngineObject.Length > 0 do begin
      name:='<Unknown>';
      Try
        name:=EngineObject.Last.ClassName;
        AddLog(MI_LOG_DESTROYING_ENGINE_OBJECT, [EngineObject.Length, name]);
        EngineObject.Last.Free;
      Except
        Try
          Die(MI_ERROR_ENGINE_OBJECT_CRASHED_AT_DESTROYING, [name]);
        Except
        End;
      End;
      EngineObject.Length := EngineObject.Length - 1;
    end;

    AddLog(MessageContainer[MI_CGE_TITLE] + ' final shutdown:');

    if not EverythingIsOk then DisplayDyingYells;

    MessageContainer.Free;
    Config.Free;

    if not EverythingIsOk then Halt(1);
end.

