{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the basic window/OpenGL manager class headers.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    see the the file COPYING_CL.txt included in this distribution,
    for details about the copyright.

    You should have received a copy of the GNU Library General Public
    License along with this source code; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 **********************************************************************}

// TO DO:
// - Under Win98, the "always on top/auto hide" taskbar still pops over my window (should not.)
// - cursor hinding in Unix
// - implement the OnType in Unix


Const
  LeftMouseButton = -1;
  RightMouseButton = -2;
  MiddleMouseButton = -3;
  MouseWheelUp = -4;
  MouseWheelDown = -5; //by thee way these are just negative numbers of mouse
    //buttons in X. (yes, my Windows-sitting friends, Linux considers
    //mouse wheel as buttons #4 and #5...)
  
  MaxKey = 255;


Type
  TCLWindow = class
    _WindowExists: boolean; // do NOT modify. For internal use only.
  protected
   {$ifdef unix}
    display: PDisplay;
    screen: integer;
    context: GLXContext;
    WindowHandle: GLXDrawable;
    Visual: PXVisualInfo;
   {$else}
    display: HDC;          //     
    context : HGLRC;          //   OpenGL (rendering context)
    WindowHandle: HWND;
   {$endif}
    _focus: boolean;
    _DeltaMouse: boolean;
    _textinput: boolean;
    _VidMode16bit: boolean;
    _Visible: boolean;
    _IgnoreLoseFocusCount: integer;
    _FullscreenWidth, _FullscreenHeight: integer;
    GLInitialized,  GLInitializedFirstTime, InDefaultVideoMode: boolean;
    _VidMode: array[0..2] of TStringList; // string format: 4-digits width, 4-digits height,
                            // then list of refresh rates - 3 digits each.
                            // VidModes sorted, refresh rates not.
    _IsFullscreen, _WasFullScreen: boolean;
    _KeyState: array[-5..MaxKey] of boolean;
    _MouseX, _MouseY: integer;
    _HideCursor: boolean;
    WinW, WinH, minW, minH, _RefreshRate: integer;
    HasFocus: Boolean;
    procedure CreateWindow;
//    procedure SetMipFilters;
    procedure InitGL;
    procedure CloseGL;
    Procedure EnumVidModes;
//    procedure CloseDisplay;
    procedure CloseWindow;
    function _readKeyState (i: integer): boolean;
    procedure _SetDeltaMouse(b: boolean);
    procedure _SetHideCursor(b: boolean);
    procedure AddVMToList(bits, width, height, hertz: integer);
    function GetVMNum(width, height: integer): integer; // -1 on not found
    procedure _SetVidMode16bit (b: boolean);
   {$ifdef unix}
    function _SwitchToFullscreenMode(width, height: integer): boolean;
   {$endif}
  public
    // set to true when you want to close app.
    // DO NOT call Free from within of one of the "On<>" methods!!!
    ExitRequested: boolean;
    
    // check this in OnLoseFocus and OnDestroy,
    // and NEVER call ANY OpenGL functions if true!
    // signals that application goes down due to some svere failure.
    EmergencyShutdown: boolean;
    
    // affects all subsequent video mode related function and procedure calls
    // there are two separate video mode lists: for 16 and 24/32-bit video modes)
    // ALWAYS check it after setting - under Unix it is _always_ false (because
    // bit depth switching not supported at all)
    property VidModes16bit: boolean read _VidMode16bit write _SetVidMode16bit;


    property InFullScreenMode: boolean read _IsFullScreen;
    
    // set it when if your class expects text input instead.
    // look about the OnType method.
    property TextInput: boolean read _textinput write _textinput;
    
    // use this if you need to do anything with the rendering context.
    // note: always use this property, don't store it anywhere else -
    // for between the OnIdle calls in some cases OpenGL may be re-loaded
    // and window be re-created, and thus context be changed.
    property RenderingContext: {$ifdef unix} glXContext {$else} HGLRC {$endif} read context;

    // return window client area dimensions
    property DisplayWidth: integer read WinW;
    property DisplayHeight: integer read WinH;

    // current screen refresh rate. if not fullscreen or not supported then zero.
    property RefreshRate: integer read _RefreshRate;

    // tells if the key is held down at the moment.
    // always false for mouse wheel "keys" -4 and -5.
    property Pressed [index: integer]: boolean read _readKeyState;

    //Mouse cursor position, in window client area coordinates
    property MouseX: integer read _MouseX;
    property MouseY: integer read _MouseY;
    
    // does the window exist now?..
    // Check in OnDestroy to determine if it was destroyed prematurely.
    property WindowExists: boolean read _WindowExists;
    
    // check to not draw when window is not visible.
    property WindowVisible: boolean read _Visible;

    Constructor Create; VIRTUAL;
    Destructor Destroy; OVERRIDE;

    // contains the main program cycle
    Procedure MainLoop;
    
    // note that VidModesNum can return zero, if XFree86 does not support
    // corresponding extensions!
    function VidModesNum: integer;
    function VidModeWidth(i: integer): integer;
    function VidModeHeight(i: integer): integer;
    // in some cases may return 0 - means 'not supported by OS'!
    // ChebLib window always uses maximum refresh rate, supported by system.
    function VidModeMaxRefreshRate(i: integer): integer;

    // tells only that video mode is in the "official" list.
    // Under Windows 98 may return false for some modes (like 320x200)
    // but  despite this they can be succesfully set.
    function VidModeSupported(width, height: integer): boolean;
    
    // if called with invalid width&height, will switch to windowed mode
    //  and return false.
    // Always uses maximum refresh rate for given mode.
    // Under Windows tries given parameters anyway (because Windows 9x often
    //  has some "hidden" video modes which it supports, but doesn't report
    //  about when asked for supported modes list (for example, 320x200 and
    //  others below 640x480).
    function SwitchToFullscreenMode(width, height: integer): boolean; OVERLOAD;

    // under Windows tries the Hertz value anyway.
    // under Unix refresh rate is ignored - always uses system default.
    function SwitchToFullscreenMode(width, height, Hertz: integer): boolean; OVERLOAD;
    
    procedure SwitchToWindowedMode;
    
    // in game mode, mouse cursor is hidden, and MouseX/MouseY return
    // relative coordinates. (and outside of OnMouseMove they always return zero!)
    // game mode works regardless of fulscreen/windowed state
    property GameMode: boolean read _DeltaMouse write _SetDeltaMouse;

    // hide cursor in non-game mode. Cursor will be hidden only if it points
    // inside the window client area.
    property HideCursor: boolean read _HideCursor write _SetHideCursor;

    // performs SwapBuffers, nothing more.
    Procedure Flip;
    
    // put your code for setting OpenGL rendering mode defaults here,
    // not in OnCreate - because, as I said above, OpenGL may be reloaded
    // between the OnIdle calls. If such happens, OnGetFocus will be called.
    // OnGetFocus is always called at least once, at startup
    procedure OnGetFocus; VIRTUAL; ABSTRACT;
    
    // always called before shutdown (use WindowExists to check if window
    // still exists at that time)
    procedure OnLoseFocus; VIRTUAL; ABSTRACT;

    // it's called one per every system mouse movement message.
    // use MouseX and MouseY to obtain coordinates.
    procedure OnMouseMove; VIRTUAL; ABSTRACT;

    // it's called once at startup, and everytime the window unwraps
    // from the minimized state (even if fullscren mode is used)
    // and each time when window's size was changed.
    // Use DisplayWidth and DisplayHeight to obtain window size.
    procedure OnResize; VIRTUAL; ABSTRACT;

    // mouse buttons are considered as keys with negative scancodes:
    // -1 - left button, -2 - right one, -3 - middle.
    // mouse wheel is considered as two keys: up (-4) and down (-5).
    // they do receive only OnPress, and Pressed for them is always false.
    //
    //this structure was choosen for sake of simplicity of key binding
    // in the game engine. It also coresponds to the mouse button / wheel
    // numbering in X. But scancodes are in MS-DOS format ("Esc" = 1, and so on)
    procedure OnPress(scancode: integer); VIRTUAL; ABSTRACT;
    procedure OnRelease(scancode: integer); VIRTUAL; ABSTRACT;
    
    // if the TextInput property is set to True, and the pressed keys
    // represent a valid character, then OnType will be called instead
    // of OnPress.
    procedure OnType(input: WideChar);  VIRTUAL; ABSTRACT;

    // called once at startup, after window created and OpenGL initialized.
    procedure OnCreate; VIRTUAL; ABSTRACT;

    // it's called once, at shutdown.
    // GUARANTEED - regardles of the way the window was closed.
    // Check the WindowExists property to determine if window sill exists
    //  or it was already destroyed.
    procedure OnDestroy; VIRTUAL; ABSTRACT;

    // Main cyclic method. Called repeatedly, unless there is anything else to do
    procedure OnIdle; VIRTUAL; ABSTRACT;
  end;

  TCLWindowClass = class of TCLWindow;
  

