{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains the basic window/OpenGL manager class.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    see the the file COPYING_CL.txt included in this distribution,
    for details about the copyright.

    You should have received a copy of the GNU Library General Public
    License along with this source code; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 **********************************************************************}


//Cheb's thanks to:
// 1. Jan Horn - let rest he in peace :( ,
//    for OpenGL Delphi examples - http://www.sulaco.co.za/
// 2. (C) A. Polishchuk, S. Semerikov, for the book
//    "Programmirovaniye X window sryedstvami FreePascal"
//    (published by Ivan Shihalev at http://fpc.by.ru/ )
// 3. Pawel W. Olszta, who created freeglut - for his sources
//    (mainly, freeglut_gamemode.c) I used as reference
//    when studied the video mode handling stuff in XFree86.
// 4. Michalis Kamburelis - looking through his KambiLib brought me some good ideas. 
//    By the way, KambiLib is much better than this result of my
//    humble efforts... but unfortunately, it's under full GNU GPL,
//    also I doubt one could easily add support for Russian there...


function min(a,b:integer):integer; begin if a<b then Result:=a else Result:=b end;

var
 _CLWindow: TCLWindow = nil; // do not modify: for internal use only!

Constructor TCLWindow.Create;
var
  x, y: integer;
  {$ifdef win32} msg: TMSG; {$endif}
begin
  inherited Create;
  For x:=0 to 2 do _VidMode[x]:= TStringList.Create;

  //_IsFullScreen:= Config.Bool['video', 'fullscreen'];

  InDefaultVideoMode:= Yes;

  VerboseLog ('Obtainning video modes list from the system...');
  EnumVidModes;  // note, that for Unix platform "display" field
                 // is initialized in the EnumVidModes method, where
                 // for Win32 platform it is initialized
                 // in the CreateWindow method.


  //    
  minW:=100; minH:=100;
  {$ifdef Win32}
  If _IsFullscreen then begin minW:=640; minH:=480; end;
  {$endif}
  {$ifdef cge}
   WinH:=Config['VIDEO', 'HEIGHT'];
   WinW:=Config['VIDEO', 'WIDTH'];
  {$else}
   WinH:=WindowHeight;
   WinW:=WindowWidth;
  {$endif}

  //  
  CreateWindow;

  HasFocus:=True;
  _focus:=True;
  _Visible:=True;

  InitGL;

  OnCreate;
  OnGetFocus;
  OnResize;


  if not Assigned(_CLWindow) then _CLWindow:=Self
  else Die ('Application can have only ONE object of class TCLWindow or its descendant!');
end;

{$ifdef unix}


var pfd: packed array [0..6] of integer =
  (GLX_RGBA, 1, GLX_DOUBLEBUFFER, 1, GLX_DEPTH_SIZE, 16, 0);

procedure TCLWindow.InitGL;
var
  rr, rg, rb, ra, rd, rs: integer;
begin
  //
  if GLInitialized then Exit;

  {$ifdef cge} AddLog(MI_LOG_OPENGLINIT); {$else} VerboseLog('Initializing OpenGL...'); {$endif}

  //   DLL
  {$ifdef cge}
  InitOpenGL(Config.Str['OpenGL', 'GL_Linux'],
             Config.Str['OpenGL', 'GLU_Linux']);
  {$else}
  InitOpenGL('libGL.so.1', 'libGLU.so.1');
  {$endif}


  VerboseLog('calling glXChooseVisual...');
  Visual:=GlXChooseVisual(Display, screen, @(pfd[0]));

  if not Assigned(Visual) then
  {$ifdef cge}
    Die(MI_ERROR_CANTINITOPENGL,['glXChooseVisual returned NULL!']);
  {$else}
    Die('glXChooseVisual returned NULL!');
  {$endif}

  glXGetConfig(Display, Visual, GLX_RED_SIZE, rr);
  glXGetConfig(Display, Visual, GLX_GREEN_SIZE, rg);
  glXGetConfig(Display, Visual, GLX_BLUE_SIZE, rb);
  glXGetConfig(Display, Visual, GLX_ALPHA_SIZE, ra);
  glXGetConfig(Display, Visual, GLX_DEPTH_SIZE, rd);
  glXGetConfig(Display, Visual, GLX_STENCIL_SIZE, rs);
  {$ifdef cge}
    AddLog(MI_LOG_Choosenpixelformat, [rr, rg, rb, ra, rd, rs]);
  {$else}
    VerboseLog(' Choosen pixel format: R=' + IntToStr(rr) + ', G='+ IntToStr(rg)+ ', B='+ IntToStr(rb)+ ', Alpha='+ IntToStr(ra)+ ', Depth='+ IntToStr(rd)+ ', Stencil='+ IntToStr(rs));
  {$endif}

  VerboseLog('calling glXCreateContext...');
  context:= glXCreateContext(Display, Visual, nil, True);

  if not Assigned(context) then {$ifdef cge} Die(MI_ERROR_CANTINITOPENGL,['glXCreateContext returned NULL!']);
  {$else}Die('glXCreateContext returned NULL!');{$endif}

  if not glXMakeCurrent(Display, Windowhandle, context)
    then {$ifdef cge} Die(MI_ERROR_CANTINITOPENGL,['Cannot make the rendering context current!']);
  {$else}Die('Cannot make the rendering context current!');{$endif}

  glClearColor(1.0, 1.0, 1.0, 0.0); 	   // White Background
  glShadeModel(GL_SMOOTH);                 // Enables Smooth Color Shading
  glDisable(GL_DEPTH_TEST);                // Enable Depth Buffer
  GLInitialized:=Yes;
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);   //Realy Nice perspective calculations

  {$ifdef cge}
   AddLog(MI_LOG_OGLINITIALIZED);
  {$endif}
end;


{$else}
var glob_focus: boolean = True;

procedure TCLWindow.InitGL;
var
  PixelFormat : GLuint;         // Settings for the OpenGL rendering
  pfd : TPIXELFORMATDESCRIPTOR;  // Settings for the OpenGL window
  repeatCount: integer;
label ReDC;
begin

  //    -  .
  if GLInitialized then Exit;

  {$ifdef cge}
  AddLog(MI_LOG_OPENGLINIT);
  {$else}
  VerboseLog('Initializing OpenGL...');
  {$endif}

  //   DLL
  {$ifdef cge}
  InitOpenGL(Config.Str['OpenGL', 'GL_Win32'],
             Config.Str['OpenGL', 'GLU_Win32']);
  {$else}
  InitOpenGL('opengl32.dll','glu32.dll');
  {$endif}

  // 
  if _IsFullScreen then SwitchToFullScreenMode(winW, WinH, _RefreshRate);

  RepeatCount:=0;
ReDC:

  //      
  VerboseLog('Calling GetDC()...');
  display := GetDC(WindowHandle);
  //AddLogComment('%0 ',[display]);
  if (display = 0) then {$ifdef cge}Die(MI_ERROR_CANTINITOPENGL, ['GetDC']);
                        {$else} Die('GetDC() returned zero!');{$endif}

  //  -     
  with pfd do
  begin
    nSize           := SizeOf(TPIXELFORMATDESCRIPTOR); // Size Of This Pixel Format Descriptor
    nVersion        := 1;                    // The version of this data structure
    dwFlags         := PFD_DRAW_TO_WINDOW    // Buffer supports drawing to window
                       or PFD_SUPPORT_OPENGL // Buffer supports OpenGL drawing
                       or PFD_DOUBLEBUFFER;  // Supports double buffering
    iPixelType      := PFD_TYPE_RGBA;        // RGBA color format
    cColorBits      := 32;                   // OpenGL color depth
    cRedBits        := 0;                    // Number of red bitplanes
    cRedShift       := 0;                    // Shift count for red bitplanes
    cGreenBits      := 0;                    // Number of green bitplanes
    cGreenShift     := 0;//8;                // Shift count for green bitplanes
    cBlueBits       := 0;                    // Number of blue bitplanes
    cBlueShift      := 0;//16;               // Shift count for blue bitplanes
    cAlphaBits      := 0;//8;                // Not supported
    cAlphaShift     := 0;//24;               // Not supported
    cAccumBits      := 0;                    // No accumulation buffer
    cAccumRedBits   := 0;                    // Number of red bits in a-buffer
    cAccumGreenBits := 0;                    // Number of green bits in a-buffer
    cAccumBlueBits  := 0;                    // Number of blue bits in a-buffer
    cAccumAlphaBits := 0;                    // Number of alpha bits in a-buffer
    {$ifdef cge}
    cDepthBits      := Config.Int['opengl', 'depth_buffer_bits_win32']; // Specifies the depth of the depth buffer
    {$else}
    cDepthBits      := 24;
    {$endif}
    cStencilBits    := 0;                    // Turn off stencil buffer
    cAuxBuffers     := 0;                    // Not supported
    iLayerType      := PFD_MAIN_PLANE;       // Ignored
    bReserved       := 0;                    // Number of overlay and underlay planes
    dwLayerMask     := 0;                    // Ignored
    dwVisibleMask   := 0;                    // Transparent color of underlay plane
    dwDamageMask    := 0;                    // Ignored
  end;

  {$ifdef cge}
  AddLog(MI_LOG_GETPF);
  {$else}
  VerboseLog('Calling ChoosePixelFormat()...');
  {$endif}
  //    ,   ,
  //     ... -    ,
  //       16 ... :(
  //
  // ..   , ,    Windows 9x,
  //        -     ... :(..

  // in Win98 calling ChoosePixelFormat() often causes a system-wide crash... :(
  PixelFormat := ChoosePixelFormat(display, @pfd);
  if (PixelFormat = 0) then begin
    //   16    (, -, )
    VerboseLog('ChoosePixelFormat failed. Switching to 16-bit depth...');
    pfd.cDepthBits:=16;
    PixelFormat := ChoosePixelFormat(display, @pfd);
    if (PixelFormat = 0) then {$ifdef cge} Die(MI_ERROR_CANTINITOPENGL,['ChoosePixelFormat']);
                              {$else} Die('ChoosePixelFormat() returned zero!'); {$endif}
  end;
  {$ifdef cge}AddLogComment('%0 ',[PixelFormat]);{$endif}

  //     ...
  DescribePixelFormat(display, PixelFormat, sizeof(pfd), pfd);
  {$ifdef cge}
  if (pfd.dwFlags AND PFD_GENERIC_FORMAT) <> 0
    then Die(MI_ERROR_OPENGLNOTACCELERATED);


  AddLog(MI_LOG_Choosenpixelformat, [pfd.cRedBits, pfd.cGreenBits,
            pfd.cBlueBits, pfd.cAlphaBits, pfd.cDepthBits, pfd.cStencilBits]);
  {$else}
  VerboseLog('Choosen pixel format: R=' + IntToStr(pfd.cRedBits) + ', G=' + IntToStr(pfd.cGreenBits)
      + ', B=' + IntToStr(pfd.cBlueBits) + ', Alpha=' + IntToStr(pfd.cAlphaBits) + ', Depth='
      + IntToStr(pfd.cDepthBits) + ', Stencil=' + IntToStr(pfd.cStencilBits));
  {$endif}

  //        
  if (not SetPixelFormat(display, PixelFormat, @pfd)) then begin
    //    16  32     ...
    // , -    ,   
    // ,       .

    // in Win98, at switching between 16- and 32- bit modes this shit often fails.
    // looks like it does not free the device context...
    // Only cure I know is to re-create the window and fully re-start OpenGL... :(
    if RepeatCount=0 then begin
      ReleaseDC(WindowHandle, display);
      CloseWindow;
      CreateWindow;
      Inc(RepeatCount);
      GoTo ReDC;
    end
    //..      ...
    else {$ifdef cge}Die(MI_ERROR_CANTINITOPENGL,['SetPixelFormat']);
         {$else}Die('SetPixelFormat() failed!');{$endif}
  end;

  //    OpenGL..
  {$ifdef cge}
  AddLog(MI_LOG_GETRC);
  {$else}VerboseLog ('Calling wglCreateContext...');{$endif}
  context := wglCreateContext(display);
  if (context = 0) then {$ifdef cge}Die(MI_ERROR_CANTINITOPENGL, ['CreateRC']);
                         {$else}Die('wglCreateContext() returned zero!');{$endif}
  {$ifdef cge}AddLogComment('%0 ',[context]);{$endif}

  // ..   .
  if (not wglMakeCurrent(display, context)) then {$ifdef cge}Die(MI_ERROR_CANTINITOPENGL, ['wglMakeCurrent']);
                                                 {$else}Die('wglMakeCurrent() returned "false"!');{$endif}
  //   ,    -  ,   -
  //   ?..
  ShowWindow(WindowHandle, SW_SHOW);
  SetForegroundWindow(WindowHandle);
  SetFocus(WindowHandle);


  glClearColor(1.0, 1.0, 1.0, 0.0); 	   // White Background
  glShadeModel(GL_SMOOTH);                 // Enables Smooth Color Shading
  glDisable(GL_DEPTH_TEST);                // Enable Depth Buffer
  GLInitialized:=Yes;
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);   //Realy Nice perspective calculations

  {$ifdef cge}
  AddLog(MI_LOG_OGLINITIALIZED);
  {$else}
  VerboseLog('OpenGL initialized!')
  {$endif}


end;

{$endif}


function IntTo4Str(i: integer): string;
begin
  Result:=IntToStr(i);
  While Length(Result) < 4 do Result:='0'+ Result;
end;


Procedure TCLWindow.CloseGL;
var dcresres: integer;
begin
  //    -  .
  if not GLInitialized then Exit;

  SwitchToWindowedMode;

  //DeleteTextures;

  VerboseLog('ClosingOpenGL...');

 {$ifdef unix}

  if WindowExists then GLXDestroyContext(Display, context);

 {$else}
  //      ...
  if WindowExists then begin
    if (not wglMakeCurrent(display, 0)) then
      {$ifdef cge}AddLog(MI_ERROR_CANTCLOSEOPENGL, ['wglMakeCurrent(display, 0) failed']);
      {$else} VerboseLog('wglMakeCurrent(display, 0) failed');{$endif}

  // ...   
    if (not wglDeleteContext(context)) then
    begin
      {$ifdef cge}AddLog(MI_ERROR_CANTCLOSEOPENGL, ['Releasing the rendering context failed']);
      {$else} VerboseLog('Releasing the rendering context failed');{$endif}
      context := 0;
    end;

  //    
    dcresres:=ReleaseDC(WindowHandle, display);
    if (dcresres = 0) and IsWindow(WindowHandle) then begin
      {$ifdef cge}AddLog(MI_ERROR_CANTCLOSEOPENGL, ['releasing the device context failed']);
      {$else} VerboseLog('releasing the device context failed');{$endif}
      display := 0;
    end;
  end;
 {$endif}

  // DLL'
  {$ifdef cge}
  CloseOpenGL;
  AddLogComment('OK');
  {$endif}
  GLInitialized:=No;
end;


{$ifdef Win32}
function TCLWindow.SwitchToFullscreenMode(width, height, Hertz: integer): boolean;
var
  dmScreenSettings : DEVMODE;
  i: integer;
  msg: TMsg;
begin

  if Hertz = 0 then VerboseLog('Switching to video mode '+IntToStr(width)+'x'+IntToStr(height))
               else VerboseLog('Switching to video mode '+IntToStr(width)+'x'+IntToStr(height)+', '+IntToStr(Hertz)+'Hertz');

  Result:=True;
  InDefaultVideoMode:=No;
  //Inc(_IgnoreLoseFocusCount);
  ShowWindow(WindowHandle, SW_SHOWMINNOACTIVE);

  //    .
  //  -,      
  ZeroMemory(@dmScreenSettings, SizeOf(dmScreenSettings));
  with dmScreenSettings do begin
    dmSize       := SizeOf(dmScreenSettings);
    dmPelsWidth  := Width;  // 
    dmPelsHeight := Height; // 
    dmFields     := DM_PELSWIDTH or DM_PELSHEIGHT or DM_BITSPERPEL;
  end;
  if VidModes16bit then  dmScreenSettings.dmBitsPerPel:=16
  else begin
    // 24 or 32?.. that's the question.
    dmScreenSettings.dmBitsPerPel:=32;
    For i:=0 to _VidMode[1].Count - 1 do
      if Copy(_VidMode[1][i], 1, 8) = IntTo4Str(Width) + IntTo4Str(Height)
        then begin dmScreenSettings.dmBitsPerPel:=24; break end;
  end;
  if RefreshRate > 0 then with dmScreenSettings do begin
    dmFields:= DmFields or DM_DISPLAYFREQUENCY;
    dmDisplayFrequency:= RefreshRate;
  end;

  //we need to allow window "to breathe" and also avoid reacttion to losing focus
  // when it minimizes. (Minimization required in order to make OpenGL context
  // react properly...
  While PeekMessage(msg, 0, 0, 0, PM_REMOVE) do begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end;

  //   
  if ChangeDisplaySettings(dmScreenSettings, CDS_FULLSCREEN) = DISP_CHANGE_SUCCESSFUL
  then begin
  //     ,    ,  :
  //   "-- !      !..."
    WinW:=Width;
    WinH:=Height;
    SetWindowLong(WindowHandle, GWL_STYLE, WS_POPUP + WS_CLIPCHILDREN);
    SetWindowLong(WindowHandle, GWL_EXSTYLE, WS_EX_APPWINDOW + WS_EX_TOPMOST);

//    SetWindowPos(WindowHandle, HWND_TOPMOST, 0, 0, WinW, WinH, SWP_SHOWWINDOW);
    ShowWindow(WindowHandle, SW_MAXIMIZE);
    While PeekMessage(msg, 0, 0, 0, PM_REMOVE) do begin
      TranslateMessage(msg);
      DispatchMessage(msg);
    end;
    FillChar(_KeyState[-5], SizeOf(_KeyState), 0);
    _FullScreenWidth:=width;
    _FullScreenHeight:=height;
    _IsFullscreen:=True;
    _Visible:=True;
    OnResize;
  end
  else begin
    Result:=False;
    SwitchToWindowedMode;
  end;
  SetFocus(WindowHandle);
end;

Procedure TCLWindow.SwitchToWindowedMode;
var
  msg: TMSG;
  sf: boolean;
begin
  //    
  if _IsFullscreen then ShowWindow(WindowHandle, SW_SHOWMINNOACTIVE);
  sf:=_IsFullscreen;
  _IsFullscreen:=False;
  SetWindowLong( WindowHandle, GWL_EXSTYLE, WS_EX_APPWINDOW);
  SetWindowLong(WindowHandle, GWL_STYLE, WS_CAPTION + WS_SYSMENU + WS_SIZEBOX + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_CLIPCHILDREN);
  ChangeDisplaySettings(nil, 0);
      //    ,
      //     " ".
      // SetWindowPos(WindowHandle, HWND_BOTTOM, 0, 0, 0, 0, 0 +  SWP_NOACTIVATE);
                {  -     
                           }
  InDefaultVideoMode:=Yes;
  ShowWindow(WindowHandle, SW_SHOWNOACTIVATE);
  ShowWindow(WindowHandle, SW_RESTORE);
  if sf then While PeekMessage(msg, 0, 0, 0, PM_REMOVE) do begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end;
  FillChar(_KeyState[-5], SizeOf(_KeyState), 0);
  ShowWindow(WindowHandle, SW_RESTORE);
  SetFocus(WindowHandle);
  VerboseLog('Switched to default video mode.');
end;
{$endif}



procedure  TCLWindow.CloseWindow;
begin
  if not WindowExists then begin
    VerboseLog('Cannot destroy the window because it was destroyed already.');
    Exit
  end;
 {$ifdef unix}
  XDestroyWindow(Display, WindowHandle);
  XFlush(Display);
 {$else}
  //  
  if (WindowHandle <> 0) and IsWindow(WindowHandle) and not DestroyWindow(WindowHandle)
  then begin
    {$ifdef cge}
    AddLog(MI_ERROR_CANTCLOSEWINDOW);
    {$else}
    VerboseLog('Destroying the window failed!');
    {$endif}
    WindowHandle := 0;
  end;

  //     
  if (not Windows.UnRegisterClass(PChar(AppNick+'_OpenGL_WND'), hInstance))
  then {$ifdef cge} AddLog(MI_ERROR_CANTCLOSEWINDOW);
       {$else} VerboseLog('Destroying the window failed!'); {$endif}

 {$endif}
  VerboseLog('Window destroyed.');
  _WindowExists:=False;
end;

{$ifdef unix}


function GetXErrorString(dpy: PDisplay; code: integer): string;
//XGetErrorText(display, code, buffer_return, length)
//      Display *display;
//      int code;
//      char *buffer_return;
//      int length;
var buf: array[0..10000] of char;
begin
  XGetErrorText(dpy, code, @buf[0], 10000);
  Result:=PCharToStr(buf);
end;

//int (*XSetIOErrorHandler(handler))()
//      int (*handler)(Display *);

function _X_Fatal_Callback(dpy: PDisplay): integer; cdecl; //in CGE never returns!
var j: integer;
begin
  {$ifdef cge}
   AddLog(MI_ERROR_X_SERVER_FATAL, ['']);
  {$else}
   VerboseLog('X server reported a fatal error. Performing emergency shutdown...');
  {$endif}
   With _CLWindow do begin
     EmergencyShutdown:=true;
     OnLoseFocus;
     OnDestroy;
   end;
  {$ifdef cge}
   Raise EFake.Create('');
  {$endif}
  //..when we return from this function, our app will instantly die.
end;

// int (*XSetErrorHandler(handler))()
//       int (*handler)(Display *, XErrorEvent *)

function _X_Error_Callback(dpy: PDisplay; Error: PXErrorEvent): integer; cdecl;
begin
  Result:=0; // Xlib ignores it anyway
  Case Error^.error_code of
    BadAccess:; // A client attempts to grab a key/button combination already grabbed by another client.
    BadWindow: begin //some of the windows became invalid
                     //(probably user closed them via system menus)
      With _CLWindow do begin
        EmergencyShutdown:=true;
        ExitRequested:=True;
      end;
      VerboseLog('X server reported that the window is invalid - closing the window object...')
    end
  else
   {$ifdef cge}
    Die(MI_ERROR_X_SERVER_FATAL, [GetXErrorString(dpy, Error^.error_code)]);
   {$else}
    Die('X server reported an error:' + GetXErrorString(dpy, Error^.error_code))
   {$endif}
  end
end;


(*
* SetWindowManagerHints -    
*    .
*)

procedure SetWindowManagerHints (
 prDisplay : PDisplay; (*   TDisplay *)
 psPrgClass : PChar; (*  *)
 argv : PPChar;   (*  *)
 argc : integer;    (*  *)
 nWnd : TWindow;    (*  *)
         x,     (*   *)
         y,     (*  *)
         nWidth,
         nHeight,  (*    *)
         nMinWidth,
         nMinHeight:integer; (*     *)
 psTitle     : PChar;  (*  *)
 psIconTitle : PChar;    (*   *)
 nIconPixmap : TPixmap    (*  *)
);

var
 rSizeHints : TXSizeHints ; (*   *)
 rWMHints : TXWMHints ;
 rClassHint : TXClassHint ;
 prWindowName, prIconName : TXTextProperty ;
begin

 if ( XStringListToTextProperty (@psTitle, 1, @prWindowName )=0) or
    (XStringListToTextProperty (@psIconTitle, 1, @prIconName )=0 ) then
 begin
  raise Exception.Create('No memory!');
 end;

 rSizeHints.flags := PPosition OR PSize OR PMinSize;
 rSizeHints.min_width := nMinWidth;
 rSizeHints.min_height := nMinHeight;
 rWMHints.flags := StateHint OR IconPixmapHint OR InputHint;
 rWMHints.initial_state := NormalState;
 rWMHints.input := True;
 rWMHints.icon_pixmap := nIconPixmap;

 rClassHint.res_name := argv^;
 rClassHint.res_class := psPrgClass;

 XSetWMProperties ( prDisplay, nWnd, @prWindowName,
  @prIconName, argv, argc, @rSizeHints, @rWMHints,
  @rClassHint );
end;

var
  win_default_border_width: integer = 1;
  DeleteWindowAtom: TAtom;

procedure TCLWindow.CreateWindow;
var attr: TXWindowAttributes;
begin

  // would we not do that - and program would silently die at first error,
  // being not able to call OnDestroy...
  XSetIOErrorHandler(_X_Fatal_Callback);
  XSetErrorHandler(_X_Error_Callback);

  DeleteWindowAtom:=XInternAtom(display, 'WM_DELETE_WINDOW', True);

  // 
  WindowHandle:= XCreateSimpleWindow ( Display,
     XRootWindow (Display, Screen), 0, 0, WinW, WinH, 3,
     XWhitePixel ( Display, Screen), XBlackPixel ( Display, Screen ));//inverted to avoid white flashes
//     XBlackPixel ( Display, Screen), XWhitePixel ( Display, Screen));

 // XSetWMProtocols(Display, WindowHandle, @DeleteWindowAtom, 1);

 //    
  SetWindowManagerHints ( Display, PChar(AppNick), argv, argc, WindowHandle, 0, 0, WinW, WinH, minW, minH, PChar(AppNick), PChar(AppNick), 0 );

 (*  ,   *)
  XSelectInput (Display, WindowHandle, ExposureMask or KeyPressMask
     or KeyReleaseMask or ButtonPressMask or ButtonReleaseMask
     or PointerMotionMask or SubstructureNotifyMask or FocusChangeMask
     or VisibilityChangeMask);

 (*   *)
  XMapWindow ( Display, Windowhandle );
  _WindowExists:=True;

  XGetWindowAttributes(display, WindowHandle, @attr);
  win_default_border_width:=attr.border_width;
end;

Procedure TCLWindow.MainLoop;
var
  Event: TXEvent;
  WinAttr: TXWindowAttributes;
  HadMessages: boolean;
begin
  repeat
    HadMessages:=false;
    While XPending(Display) > 0 do begin
      XNextEvent ( Display, @Event );
      case Event._type of
        FocusIn: begin
          if not HasFocus then begin
            if _WasFullScreen then begin
              SwitchToFullscreenMode(_FullscreenWidth, _FullScreenHeight);
              _Visible:=True;
              _WasFullScreen:=False;
              OnResize;
            end
            else OnGetFocus;
          end;
          HasFocus:=True;
        end;
        FocusOut: begin
          if HasFocus then OnLoseFocus;
          if _IsFullScreen then begin
            _FullScreenWidth:=WinW;
            _FullscreenHeight:=WinH;
            _WasFullScreen:=True;
            SwitchToWindowedMode;
          end;
          HasFocus:=false;
        end;
        KeyPress: begin
          if not _KeyState[(event.xKey.keycode - 8) and $FF] then begin
            _KeyState[(event.xKey.keycode - 8) and $FF]:=true;
            OnPress((event.xKey.keycode - 8) and $FF);
          end;
        end;
        KeyRelease:
          if _KeyState[(event.xKey.keycode - 8) and $FF] then begin
            _KeyState[(event.xKey.keycode - 8) and $FF]:=false;
            OnRelease((event.xKey.keycode - 8) and $FF);
          end;
        ButtonPress: begin
          _MouseX:=event.xbutton.x;
          _MouseY:=event.xbutton.y;
          case (Event.xbutton.button) of
            Button1..Button3: begin
              _KeyState[-Event.xbutton.button]:=true;
              OnPress(-Event.xbutton.button);
            end;
            Button4..Button5: begin
              OnPress(-Event.xbutton.button);
            end;
          end;
        end;
        VisibilityNotify: begin
          _Visible:=(_IsFullscreen or (event.xvisibility.state <> VisibilityFullyObscured));
        end;
        ButtonRelease: begin
          _MouseX:=event.xbutton.x;
          _MouseY:=event.xbutton.y;
          case (Event.xbutton.button) of
            Button1..Button3: begin
              _KeyState[-Event.xbutton.button]:=false;
              OnRelease(-Event.xbutton.button);
            end;
          end;
        end;
        MotionNotify: begin
          _MouseX:=event.xmotion.x;
          _MouseY:=event.xmotion.y;
          OnMouseMove;
        end;
        ResizeRequest: begin
          WinW:=event.xresizerequest.Width;
          WinH:=event.xresizerequest.Height;
        end;
        DestroyNotify: begin
          VerboseLog('Window received the "DestroyNotify" message.') ;
          _WindowExists:=false;
          Exit;
        end;
      else
        ;
      end;
      hadmessages:=true;
    end;
    OnIdle;
    if HasFocus and hadmessages then begin
                  //    ^ without this, everything dies with "broken pipe"
                  // when I close window using its system menu...
      XGetWindowAttributes(Display, WindowHandle, @WinAttr);
      if (WinAttr.width <> WinW)
      or (WinAttr.height <> WinH)
      then begin
        WinW:=WinAttr.width;
        WinH:=WinAttr.height;
        OnResize;
      end;
    end;
  Until ExitRequested;
end;
{$endif}

{$ifdef win32}

//        .
function WndProc(hWnd: HWND; Msg: UINT;  wParam: WPARAM;  lParam: LPARAM): LRESULT; stdcall;
begin
   if msg = WM_ACTIVATE then begin
     // cannot be processed in the main message loop:
     // arrives only here, in the window procedure
     Case LOWORD(wParam) of
      WA_ACTIVE, WA_CLICKACTIVE: glob_focus:=True;
      WA_INACTIVE: glob_focus:=false;
     end;
   end;
  if msg = WM_ACTIVATE then  Result:=0
  else Result := DefWindowProc(hWnd, Msg, wParam, lParam)    // Default result if nothing happens
end;

procedure TCLWindow.CreateWindow;
var
  wndClass : TWndClass;
  dwStyle : DWORD;
  dwExStyle : DWORD;
  s: string;
begin
  VerboseLog('Creating the window...');
  s:=AppNick+'_OpenGL_WND';

  //  -,       
  ZeroMemory(@wndClass, SizeOf(wndClass));
  with wndClass do
  begin
    style         := CS_HREDRAW or    //      
                     CS_VREDRAW or    // ... ,  
                     CS_OWNDC;        //     
    lpfnWndProc   := @WndProc;        //  ,    
    hInstance     := System.HInstance;
    lpszClassName := PChar(s);
  end;
  //    (,       - ,
  //   - ,  ... ,    .)
  if (0=Windows.RegisterClass(wndClass)) then {$ifdef cge}Die(MI_ERROR_CANTCREATEWINDOW);
                                              {$else}Die('Cannot register the window class!');{$endif}
  //   ,      
  if _IsFullScreen then begin
    dwStyle := WS_POPUP + WS_MAXIMIZE + // popup -     
               + WS_VISIBLE + WS_CLIPCHILDREN;      //     
    dwExStyle :=  WS_EX_TOPMOST      //   -     
                  or WS_EX_APPWINDOW  //      
  end
  else begin
    dwExStyle := WS_EX_APPWINDOW;
    dwStyle:=WS_CAPTION + WS_SYSMENU + WS_SIZEBOX + WS_VISIBLE + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_CLIPCHILDREN;
  end;
  //  
  WindowHandle:= CreateWindowEx
    (dwExStyle, PChar(s), PChar(AppNick), dwStyle, 0, 0, WinW, WinH, 0, 0, hInstance, nil);
  if WindowHandle = 0 then {$ifdef cge}Die(MI_ERROR_CANTCREATEWINDOW);
                           {$else}Die('Cannot create window!');{$endif}
  _WindowExists:=True;
  VerboseLog('Ok');
end;

//     
Procedure TCLWindow.MainLoop;
var
  msg: TMsg;
  i, oldmx, oldmy: integer;
  rect: TRect;
  point: TPoint;
  KeyboardState: array[0..255] of byte;
  buff: array[0..10] of WideChar;
  txt: PWideChar;
  numchars: integer;
begin
  repeat
    if not IsWindow(WindowHandle) then begin
      _WindowExists:=false;
      Exit;
    end;   //   
    //      ,  
    //         ,
    //      ,     
    //      OpenGL... :(
    _focus:= glob_focus and (GetFocus() = WindowHandle);

    GetClientRect(WindowHandle, rect);
    if _focus and not _IsFullScreen then begin
      if ((rect.right - rect.left + 1) <> WinW)
      or ((rect.bottom - rect.top + 1) <> WinH)
      then begin
        WinW:=rect.right - rect.left + 1;
        WinH:=rect.bottom - rect.top + 1;
        OnResize;
      end;
    end;

    While PeekMessage(msg, 0, 0, 0, PM_REMOVE) do begin
      case msg.message of
      //    .      
      //   ,      Alt-Tab.
        WM_KEYDOWN:
          begin
            numchars:=0;
            if TextInput then begin
              GetKeyboardState(@KeyboardState[0]);
              numchars:=ToUnicode(msg.wparam, (msg.lParam shr 16) and $FF, @KeyboardState[0], @buff[0], 10, 0);
            end;
            if (msg.lParam and $FFFF ) = 1 then begin
              if numchars < 1 then begin
                if not _KeyState[(msg.lParam shr 16) and $FF] then begin
                  _KeyState[(msg.lParam shr 16) and $FF]:=true;
                  OnPress((msg.lParam shr 16) and $FF);
                end;
              end
              else for i:=0 to numchars - 1 do OnType(buff[i]);
            end;
          end;
        WM_KEYUP:
          begin
            if _KeyState[(msg.lParam shr 16) and $FF] then begin
              _KeyState[(msg.lParam shr 16) and $FF]:=false;
              OnRelease((msg.lParam shr 16) and $FF);
            end;
          end;
        WM_SYSKEYDOWN:
          begin

          end;
        WM_SYSKEYUP:
          begin
             ;
          end;
        WM_LBUTTONDOWN:
          begin
            _KeyState[LeftMouseButton]:=true;
            OnPress(LeftMouseButton);
          end;
        WM_LBUTTONUP:
          begin
            _KeyState[LeftMouseButton]:=false;
            OnRelease(LeftMouseButton);
          end;
        WM_RBUTTONDOWN:
          begin
            _KeyState[RightMouseButton]:=true;
            OnPress(RightMouseButton);
          end;
        WM_RBUTTONUP:
          begin
            _KeyState[RightMouseButton]:=false;
            OnRelease(RightMouseButton);
          end;
        WM_MBUTTONDOWN:
          begin
            _KeyState[MiddleMouseButton]:=true;
            OnPress(MiddleMouseButton);
          end;
        WM_MBUTTONUP:
          begin
            _KeyState[MiddleMouseButton]:=false;
            OnRelease(MiddleMouseButton);
          end;
        WM_MOUSEMOVE: begin
          GetCursorPos(point);
          ScreenToClient(Windowhandle, point);
          ShowCursor(not (_focus and (_HideCursor or _DeltaMouse))
            or (point.x < 0) or (point.x > rect.right) or (point.y < 0) or (point.y > rect.bottom));
          if _DeltaMouse then begin
            _MouseX:=point.x - rect.right div 2;
            _MouseY:=point.y - rect.bottom div 2;
            if (_MouseX <> 0) or (_MouseY <> 0) then OnMouseMove;
            point.x:=rect.right div 2;
            point.y:=rect.bottom div 2;
            ClientToScreen(Windowhandle, Point);
            SetCursorPos(point.x, point.y);
          end
          else begin
            oldmx:=_MouseX;
            oldmy:=_MouseY;
            _MouseX:=point.x - rect.left;
            _MouseY:=point.y - rect.top;
            ShowCursor(not (_focus and (_HideCursor or _DeltaMouse))
              or (point.x < 0) or (point.x > rect.right) or (point.y < 0) or (point.y > rect.bottom));
            // Windows 2000 has ugly habit to send movement messages every second,
            // regardless of moved the cursor or not...
            // Not without a reason its nick in Russian is "Mazdai" ("must die").
            if (_MouseX <> oldmx) or (_MouseY <> oldmy) then OnMouseMove;
          end;
        end;
        WM_MOUSEWHEEL:
          begin
            i:=smallint(HIWORD(msg.wParam)) div 120;
            while i > 0 do begin
              OnPress(MouseWheelUp);
              dec(i);
            end;
            while i < 0 do begin
              OnPress(MouseWheelDown);
              inc(i);
            end;
          end;
        WM_SYSCOMMAND: begin
          case msg.wParam of
            SC_CLOSE: Exit;
            SC_MAXIMIZE:;
            SC_MINIMIZE:;
          end;
        end;
        WM_SIZE: begin
          if msg.wparam <> SIZE_MINIMIZED then begin
            WinW:=loword(msg.lParam);
            WinH:=hiword(msg.lParam);
            OnResize;
          end;
        end;
        WM_CLOSE, WM_DESTROY:
          begin
            //PostQuitMessage(0);
            ExitRequested:=true;
          end;
       { WM_ACTIVATE: begin
          Case LOWORD(msg.wParam) of
            WA_ACTIVE, WA_CLICKACTIVE: _focus:=True;
            WA_INACTIVE: _focus:=false;
          end;
        end;}
      else
         ;
      end;
      {if not msg.Message in [WM_QUIT, WM_CLOSE, WM_DESTROY] then} begin
        TranslateMessage(msg);
        DispatchMessage(msg);
      end;
    end;
    OnIdle;

     if _focus <> HasFocus then begin
      if not _focus
        then begin
          if _IgnoreLoseFocusCount = 0 then begin
            OnLoseFocus;
            if _IsFullScreen then begin
              _WasFullScreen:=True;
              SwitchToWindowedMode;
              ShowWindow(WindowHandle, SW_SHOWMINNOACTIVE);
              _Visible:=False;
            end;
          end
          else dec(_IgnoreLoseFocusCount);
        end
        else begin
          if _WasFullScreen then begin
            SwitchToFullscreenMode(_FullscreenWidth, _FullScreenHeight, _RefreshRate);
            _Visible:=True;
            _WasFullScreen:=False;
            OnResize;
          end
          else ShowWindow(WindowHandle, SW_RESTORE);
          OnGetFocus;
        end;
      HasFocus:=_focus;
    end;

    if not _focus then Sleep(150);
  Until ExitRequested;
end;
{$endif}

Procedure TCLWindow.Flip;
begin
 {$ifdef unix}
   glXSwapBuffers(Display, WindowHandle);
 {$else}
   SwapBuffers(display);
 {$endif}
end;

{$ifdef win32}
Procedure  TCLWindow.EnumVidModes;
var
  DevMode: TDevMode;
  h: hresult;
  i,j, k, hu: integer;
  q: boolean;
begin
  DevMode.dmSize:=SizeOf(TDevMode);

  //      - ,
  //  640480  .
  DevMode.dmFields:=DM_BITSPERPEL + DM_PELSWIDTH + DM_PELSHEIGHT;
  i:=0;
  while EnumDisplaySettings(nil, i, DevMode) do begin
    inc(i);
    DevMode.dmSize:=SizeOf(TDevMode);
    DevMode.dmFields:=DM_PELSWIDTH + DM_PELSHEIGHT + DM_BITSPERPEL + DM_DISPLAYFREQUENCY;
    if  ChangeDisplaySettings(DevMode, CDS_TEST + CDS_FULLSCREEN)
       <> DISP_CHANGE_SUCCESSFUL then CONTINUE; //some of'em are invalid from the start...
    with DevMode do begin
      AddVmToList(dmBitsPerPel, dmPelsWidth, dmPelsHeight, dmDisplayFrequency);
      if dmBitsPerPel = 24
        then AddVmToList(32, dmPelsWidth, dmPelsHeight, dmDisplayFrequency);
    end;
  end;
  For hu:=0 to 2 do _VidMode[hu].Sort; //guess, why I used TStringList?.. ^_^
end;
{$endif}

procedure TCLWindow.AddVMToList(bits, width, height, hertz: integer);
var
  i,j, k, hu: integer;
  q: boolean;
begin
  If not (bits in [16, 24, 32]) then Exit; // ,   -  .
  If (Width < 0) or (Width > 4096) then Exit;
  If (Height < 0) or (Height > 4096) then Exit;
  If (Hertz < 0) or (Hertz > 500) then Exit;
  hu:= (bits - 16) div 8;
  k:=-1;
  For j:=0 to _VidMode[hu].Count - 1 do
    if Copy(_VidMode[hu][j], 1, 8) = IntTo4Str(Width) + IntTo4Str(Height)
      then begin k:=j; break end;
  if k < 0 then begin
    _VidMode[hu].Add(IntTo4Str(Width) + IntTo4Str(Height));
    k:=_VidMode[hu].Count - 1;
    if hu = 0 then
      VerboseLog('... 16-bit vidmode #' + IntToStr(_VidMode[hu].Count) + ':  ' + IntToStr(width) + 'x' + IntToStr(Height) + '.');
      VerboseLog('... vidmode #' + IntToStr(_VidMode[hu].Count) + ':  ' + IntToStr(width) + 'x' + IntToStr(Height) + '.');
  end;
  q:=false;
  For j:=0 to (Length(_VidMode[hu][k]) - 8) div 4 - 1 do
    if Copy(_VidMode[hu][k], 8 + j*4 + 1, 4) = IntTo4Str(Hertz)
      then begin q:=true; break end;
  if not q then _VidMode[hu][k]:=_VidMode[hu][k] + IntTo4Str(Hertz);
end;

function TCLWindow._readKeyState (i: integer): boolean;
begin
  Result:=_KeyState[i];
end;

{$ifdef unix}

{$else}
  procedure TCLWindow._SetDeltaMouse(b: boolean);
  var
    rect: TRect;
    point: TPoint;
  begin
    _DeltaMouse:=b;
    if b then begin
      GetClientRect(WindowHandle, rect);
      point.x:=rect.right div 2;
      point.y:=rect.bottom div 2;
      ClientToScreen(Windowhandle, Point);
      SetCursorPos(point.x, point.y);
    end;
  end;

  procedure TCLWindow._SetHideCursor(b: boolean);
  begin
    _HideCursor:=b;
  end;

{$endif}

 function TCLWindow.VidModesNum: integer;
 var hu: integer;
 begin
   if VidModes16bit then hu:=0 else hu:=2;
   Result:=_VidMode[hu].Count;
 end;

 function TCLWindow.VidModeWidth(i: integer): integer;
 var hu: integer;
 begin
   if VidModes16bit then hu:=0 else hu:=2;
   Result:=StrToInt(Copy(_VidMode[hu][i], 1, 4));
 end;

 function TCLWindow.VidModeHeight(i: integer): integer;
 var hu: integer;
 begin
   if VidModes16bit then hu:=0 else hu:=2;
   Result:=StrToInt(Copy(_VidMode[hu][i], 5, 4));
 end;

 function TCLWindow.VidModeMaxRefreshRate(i: integer): integer;
 var hu, j, r: integer;
 begin
   if VidModes16bit then hu:=0 else hu:=2;
   Result:=0;
   if i < 0 then Exit;
   For j:=0 to (Length(_VidMode[hu][i]) - 8) div 4 - 1 do begin
     r:= StrToInt(Copy(_VidMode[hu][i], 8 + j*4 + 1, 4));
     if r > Result then Result:=r;
   end;
 end;

 function TCLWindow.VidModeSupported(width, height: integer): boolean;
 begin
   Result:=GetVMNum(width, height) >=0;
 end;

 function TCLWindow.GetVMNum(width, height: integer): integer;
 var hu, j, r: integer;
 begin
   if VidModes16bit then hu:=0 else hu:=2;
   Result:=-1;
   For j:=0 to _VidMode[hu].Count - 1 do begin
     //VerboseLog(Copy(_VidMode[hu][j], 1, 8));
     if Copy(_VidMode[hu][j], 1, 8) = IntTo4Str(Width) + IntTo4Str(Height)
       then begin Result:=j; break end;
   end;
 end;

 function TCLWindow.SwitchToFullscreenMode(width, height: integer): boolean;
 var q: integer;
 begin
   q:=GetVMNum(width, height);
   //VerboseLog(' %0 %1 %2  %3 ',[width, height, q, VidModeMaxRefreshRate(q)]);
   Result:=SwitchToFullscreenMode(width, height, VidModeMaxRefreshRate(q))
 end;

{$ifdef unix}
 procedure TCLWindow._SetDeltaMouse(b: boolean);
 begin
   _DeltaMouse:=b;
 end;

 procedure TCLWindow._SetHideCursor(b: boolean);
 begin
   _HideCursor:=b;
 end;

{$ifdef Linked_with_xf86vm}
type
  PXF86VidModeModeLine = ^XF86VidModeModeLine;
  XF86VidModeModeLine = packed record
    hdisplay,
    hsyncstart,
    hsyncend,
    htotal,
    hskew,
    vdisplay,
    vsyncstart,
    vsyncend,
    vtotal : word;
    flags: dword;
    privsize: integer;
    c_private: PInteger;
  end;


(*typedef struct {
    unsigned int	dotclock;
    unsigned short	hdisplay;
    unsigned short	hsyncstart;
    unsigned short	hsyncend;
    unsigned short	htotal;
    unsigned short	hskew;
    unsigned short	vdisplay;
    unsigned short	vsyncstart;
    unsigned short	vsyncend;
    unsigned short	vtotal;
    unsigned int	flags;
    int			privsize;
#if defined(__cplusplus) || defined(c_plusplus)
    /* private is a C++ reserved word */
    INT32		*c_private;
#else
    INT32		*private;
#endif
}XF86VidModeModeInfo;
*)
  PPPXF86VidModeModeInfo = ^PPXF86VidModeModeInfo;
  PPXF86VidModeModeInfo = ^PXF86VidModeModeInfo;
  PXF86VidModeModeInfo = ^XF86VidModeModeInfo;
  XF86VidModeModeInfo = packed record
    dotclock: dword;
    modeline: XF86VidModeModeLine;
  end;

  function XF86VidModeGetModeLine(dpy: PDisplay; screen: integer; dotclock: PInteger; modeline: PXF86VidModeModeLine): LongBool; cdecl; external 'Xxf86vm';
  function XF86VidModeGetAllModeLines(dpy: PDisplay; screen: integer; modecount: PInteger; modelinesptr: PPPXF86VidModeModeInfo): LongBool; cdecl; external 'Xxf86vm';
//  function XF86VidModeValidateModeLine(dpy: PDisplay; screen: integer;  modeline: PXF86VidModeModeLine): TStatus; cdecl; external 'Xxf86vm';
  function XF86VidModeSwitchToMode(dpy: PDisplay; screen: integer; modeline: PXF86VidModeModeLine): LongBool; cdecl; external 'Xxf86vm';
  function XF86VidModeSwitchMode(dpy: PDisplay; screen, zoom: integer): LongBool; cdecl; external 'Xxf86vm';
  function XF86VidModeSetViewPort(dpy: PDisplay; screen, x, y: integer): LongBool; cdecl; external 'Xxf86vm';

  var
    VidModeInfo: PPXF86VidModeModeInfo;
 {$endif}
  var
    VidModeCount: integer;
    InitialWidth, InitialHeight, CurrentModeIndex: integer;

Procedure  TCLWindow.EnumVidModes;
var
  j: integer;
 {$ifdef Linked_with_xf86vm}
  p: PXF86VidModeModeInfo;
  pp: PPXF86VidModeModeInfo;
 {$endif}
begin
  //  X 
  Display:= XOpenDisplay(nil);
  if Display = nil then {$ifdef cge}Die(MI_CANT_CONNECT_TO_X_SERVER);{$else}Die('Cannot connect to X server!');{$endif}
  screen:= XDefaultScreen(Display);

  {$ifndef Linked_with_xf86vm}
   VerboseLog('This version had been linked without XFree86 VidMode extensions. Video mode switching unavailable!');
   // add current screen size to avoid the empty video mode list.
   AddVMToList(32, xlib.DisplayWidth(display, screen), xlib.DisplayHeight(display, screen), 0);
  {$else}
   if not XF86VidModeGetAllModeLines(Display, Screen, @VidModeCount, @VidModeInfo)
   then Die('XF86VidModeGetAllModeLines() returned false!');
   VerboseLog(IntToStr(VidModeCount) + ' video modes found. Sorting...');
   pp:=vidModeInfo;
   For j:=0 to VidModeCount - 1 do begin
     p:=pp^;
     AddVMToList(32, p^.modeline.hdisplay, p^.modeline.vdisplay, 0); // just for reporting purposes... :(
     inc(pp);
   end;
// *******************
   InitialWidth:=xlib.DisplayWidth(display, screen);
   InitialHeight:=xlib.DisplayHeight(display, screen);
  {$endif}
end;

{$ifdef Linked_with_xf86vm}
function TCLWindow._SwitchToFullscreenMode(width, height: integer): boolean;
var
  m: XF86VidModeModeLine;
  j, x, y, dotclock: integer;
begin
  VerboseLog('Switching to video mode ' +IntToStr(width) + 'x' + IntToStr(height));
  Result:=false;
  j:=0;
  FillChar(m, sizeof(m), 0);
  repeat
    XF86VidModeGetModeLine(display, screen, @dotclock, @m);
    x:=m.hdisplay;
    y:=m.vdisplay;
    VerboseLog('..current mode is ' +IntToStr(x) + 'x' + IntToStr(y));
    if (x = width) and (y = height) then begin
      Result:=True;
      Exit;
    end;
    inc (j); if j = VidModeCount then Exit;
    if not XF86VidModeSwitchMode(display, screen, 1) then Exit;
    Inc(CurrentModeIndex);
    if CurrentModeIndex = VidModeCount then CurrentModeIndex:=0;
    VerboseLog('...flipped one mode forth...');
  until false;
end;
{$else}
function TCLWindow._SwitchToFullscreenMode(width, height: integer): boolean;
begin
  Result:=(width=InitialWidth) and (Height = InitialHeight);
end;
{$endif}

function TCLWindow.SwitchToFullscreenMode(width, height, Hertz: integer): boolean;
var
  attr: TXSetWindowAttributes;
  b1, b2: boolean;
  x, y: integer;
  stub: TWindow;
begin
  Result:=_SwitchToFullscreenMode(width, height);
  If not Result then Exit;
  attr.border_pixel:=0;
  attr.override_redirect:=true;
  XChangeWindowAttributes(display, Windowhandle, CWBorderPixel, @attr); //doesn't work?..
  XResizeWindow(display, WindowHandle, width, height);
  XFlush(display);
  XSync(display, false);
  WinW:=width;
  WinH:=height;
  _Visible:=True;
  XMoveWindow(display, WindowHandle, 0, 0);
  XFlush(display);
  XSync(display, false);
  XF86VidModeSetViewPort(display, screen, 0, 0);
  // Now we have almost everything Ok... except the window title bar
  //   and border, adorning the upper/left edges, just like the
  //   dirty socks sticking from under the bed... :(
  // So, we'll hide that trash under the carpet and will move window so
  //   that they'll disappear beyond the window edge:
  XTranslateCoordinates(display, Windowhandle, RootWindow(display, screen), 0, 0, @x, @y, @stub);
  XMoveWindow(display, WindowHandle, -x, -y);
  XSync(display, false);


  XMapRaised(display, Windowhandle);
  XFlush(display);
  XSync(display, false);

  // Now block any further machinations with the window...
  XChangeWindowAttributes(display, Windowhandle, CWOverrideRedirect, @attr);
  XFlush(display);
  XSync(display, false);
  _IsFullScreen:=True;
  b1:= 0 = XGrabKeyboard(display, WindowHandle, true, GrabModeAsync, GrabModeAsync, CurrentTime);
  if b1 then b2:= 0 = XGrabPointer(display, WindowHandle, true, {FocusChangeMask or StructureNotifyMask or KeyPressMask or KeyReleasemask or }ButtonPressMask or ButtonReleaseMask or PointerMotionMask, GrabModeAsync, GrabModeAsync, WindowHandle, None, CurrentTime);
  if not (b1 and b2) then begin
    VerboseLog('Unable to grab pointer or keyboard!');
    SwitchToWindowedMode;
    Exit;
  end;
  OnResize;
end;

procedure TCLWindow.SwitchToWindowedMode;
var
  attr: TXSetWindowAttributes;
begin
  _IsFullScreen:=False;
  if not _SwitchToFullscreenMode(InitialWidth, InitialHeight)
  then VerboseLog('Switching to the default video mode failed!');
  attr.border_pixel:=win_default_border_width;
  attr.override_redirect:=false;
  XChangeWindowAttributes(display, Windowhandle, CWBorderPixel or CWOverrideRedirect, @attr);
  XFlush(display);
  XSync(display, false);
  XUngrabPointer(display, CurrentTime);
  XUngrabKeyboard(display, CurrentTime);
  XFlush(display);
  XSync(display, false);
  XMoveWindow(display, WindowHandle, 20, 20);
  XFlush(display);
  XSync(display, false);
end;

procedure TCLWindow._SetVidMode16bit (b: boolean);
begin
end; //do nothing. Not supported in Unix.
{$endif}

{$ifdef win32}
procedure TCLWindow._SetVidMode16bit (b: boolean);
begin
  _VidMode16bit:=b;
end;
{$endif}


destructor  TCLWindow.Destroy;
var j: integer;
begin
  if HasFocus then OnLoseFocus;
  OnDestroy;

  //     
  SwitchToWindowedMode;

  //  OpenGL
  CloseGL;

  CloseWindow;

  For j:=0 to 2 do _VidMode[j].Free;

  {$ifdef unix}
   {$ifdef Linked_with_xf86vm}
    XFree(VidModeInfo);
   {$endif}
  {$endif}

  inherited;
  _CLWindow:= nil;
end;