{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      and contains string handling routines.
      
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 **********************************************************************}
{$mode delphi}

unit cl_strings;
interface
  uses SysUtils, strings;

Type Chars = Set of char;

Const
  RussianChars: Chars = [''..'', ''..'', '', ''];
  CyrillicChars: Chars = [''..'', ''..'', '', '', '', '', '', '',
                          '', '', '', '', '', '', '', '', '', '',
                          '', '', '', '', '', '', '', '', '', '',
                          '', '', '', ''];
  LatinChars: Chars = ['A'..'Z', 'a'..'z'];
  NumberChars: Chars = ['0'..'9'];
  ASCIISafeChars = [' '..'~'];

Function PCharToStr(P:PChar):AnsiString;
Function RanStr(s: AnsiString):AnsiString; //separator = '~'
//function UpCase(h: char): char;
//function LowCase(h: char): char;
//Function NumParm(s:AnsiString; n:integer):integer;

Function StrParm(s:AnsiString; n:integer{1..}; sep: Chars):AnsiString; OVERLOAD;
Function StrParm(s:WideString; n:integer{1..}; sep: WideChar):WideString; OVERLOAD;


Function StrDelSet(s:AnsiString;c:chars):AnsiString;
Function StrFilter(s:AnsiString;c:chars):AnsiString;

Function StrUpLett(s:AnsiString):AnsiString;
Function StrUpFirst(s: AnsiString): AnsiString;
Function StrLowLett(s:AnsiString):AnsiString;

Function StrDelAllSp(S:AnsiString):AnsiString;
Function StrCut (S:AnsiString;K:integer ):AnsiString;

Function StrSupplRight(S:AnsiString;K:integer;c:char ):AnsiString;
Function StrSupplLeft(S:AnsiString;K:integer;c:char ):AnsiString;

Function StrRepeat (S:AnsiString;K: integer):AnsiString;
Function StrReplace (S, zamenjaemoe, zamenjajushee:AnsiString):AnsiString;  OVERLOAD;
Function StrReplace (S, zamenjaemoe, zamenjajushee:WideString):WideString;  OVERLOAD;

Function StrContPos (S,w:AnsiString): integer;

Function ParIs(s: AnsiString): BOOLean;

IMPLEMENTATION

  Function RanStr(s: AnsiString):AnsiString;
  var c :integer;
      EM: Array of AnsiString;
  begin
    SetLength(EM, 1);
    c:=0;
    Repeat
      inc(c);
      IF s[c]='~' then SetLength(EM, Length(EM) + 1)
                  else EM[Length(EM) - 1]:=EM[Length(EM) - 1]+S[c];
    Until c = Length(S);
    RanStr:=EM[Random(Length(EM))];
    SetLength(EM, 0);
  end;

Function StrDelAllSp;
  var c: integer;
      cus: AnsiString;
begin
  cus:='';
  For c:=1 to Length(S) do
    IF S[c] <> ' ' Then cus:=cus+S[c];
  StrDelAllSp:=cus;
end;

Function StrUpLett;
var n: integer;
begin
  For n:=1 to Length(s) do s[n]:=UpCase(s[n]);
  StrUpLett:=s
end;

Function StrUpFirst;
begin
  s[1]:=UpCase(s[1]);
  StrUpFirst:=s;
end;

Function StrLowLett;
var n: integer;
begin
  For n:=1 to Length(s) do s[n]:=LowerCase(s[n]);
  StrLowLett:=s
end;

Function StrContPos;
var b,n:integer;
begin
  b:=Length(s)-Length(w)+1;
  repeat
    Dec(b); n:=-1;
    repeat
      Inc(n);
    until (s[b+n]<>w[n+1]) or( n=Length(w)-1)
  until (b=0) or (n=Length(w)-1);
  StrContPos:=b;
end;


Function StrCut ;
begin
  IF K<Length(S) then StrCut:=copy(s,1,K)
                 else StrCut:=s;
end;

Function StrRepeat;
  var cy:integer; cus:AnsiString;
begin
  cus:= '';
  FOR cy:=1 to K do
              IF (255-Length(cus))>=Length(s) then cus:=cus+s
              ELSE if Length(CUS)<255 then
                        cus:=cus+StrCut(s,255-Length(cus));
  StrRepeat := cus;
end;

Function StrReplace (S, zamenjaemoe, zamenjajushee: AnsiString): AnsiString;
var p: integer;
    s2: AnsiString;
begin
  p:=Pos(zamenjaemoe, s);
  While p > 0 do begin
    s:=COPY(s, 1, p - 1) + zamenjajushee + COPY(s, p + Length(zamenjaemoe), Length(s));
    p:=Pos(zamenjaemoe, s);
  end;
  StrReplace:=s;
end;

Function StrReplace (S, zamenjaemoe, zamenjajushee:WideString):WideString;
var p: integer;
    s2: WideString;
begin
  p:=Pos(zamenjaemoe, s);
  While p > 0 do begin
    s:=COPY(s, 1, p - 1) + zamenjajushee + COPY(s, p + Length(zamenjaemoe), Length(s));
    p:=Pos(zamenjaemoe, s);
  end;
  StrReplace:=s;
end;


Function StrDelSet;
var cy:integer;Ul:AnsiString;
begin
  ul:='';
  For Cy:=1 to length(s) do
           IF not(s[cy] in c) then ul:=ul+s[cy];
  StrDelSet:=ul;
end;

Function StrFilter;
var cy:integer;Ul:AnsiString;
begin
  ul:='';
  For Cy:=0 to length(s) do
           IF not(s[cy] in c) then ul:=ul+s[cy];
  StrFilter:=ul;
end;

Function StrSupplLeft;
begin
  if Length(s)<K Then
        StrSupplLeft:=S+StrRepeat(c,k-Length(s))
  else StrSupplLeft:=s;
end;

Function StrSupplRight;
begin
  if Length(s)<K Then
        StrSupplRight:=StrRepeat(c,k-Length(s))+S
  else StrSupplRight:=s;
end;

{Function NumParm(s:AnsiString;n:integer):integer;
var st: AnsiString;
    i,j:integer;
begin
  st:=StrParm(s,n);
  VAL(st,i,j);
  NumParm:=i;
end;
}

Function StrParm(s:AnsiString; n:integer; sep: Chars):AnsiString;
var
  c,d,p,l: integer;
  h: char;
begin
  h:=#0;
  While not (h in sep) and (h < #255) do inc(h);
  s:=h + s + h + h;
  c:=1; d:=0; p:=0; l:=0;
  Repeat
    While (s[c] in sep) and (c<Length(s)) do Inc(c);
    if c=Length(s) then Break;
    inc(d);
    p:=c;
    While not(s[c] in sep) and (c<Length(s)) do Inc(c);
    l:=c-p;
  Until (d=n) or (c>=Length(s));
  If d=n then StrParm:=Copy(s,p,l) else StrParm:='';
end;

Function StrParm(s:WideString; n:integer; sep: WideChar):WideString;
var
  c,d,p,l: integer;
begin
  s:=sep + s + sep + sep;
  c:=1; d:=0; p:=0; l:=0;
  Repeat
    While (s[c] = sep) and (c < Length(s)) do Inc(c);
    if c=Length(s) then Break;
    inc(d);
    p:=c;
    While not(s[c] = sep) and (c < Length(s)) do Inc(c);
    l:=c-p;
  Until ( d = n ) or (c >= Length(s));
  If d=n then StrParm:=Copy(s, p, l) else StrParm:='';
end;


Function ParIs(s: AnsiString): BOOLean;
var c: integer;
begin
  ParIs:=False;
  For c:=1 to ParamCount do
    If StrUpLett(ParamStr(c))=s then ParIs:=True;
end;

{function UpCase(h: char): char;
begin
  Case h of
    'a'..'z': UpCase:=chr(ord(h)+(ord('Z')-ord('z')));
    ''..'': UpCase:=chr(ord(h)+(ord('')-ord('')));
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';   '': UpCase:='';
    '': UpCase:='';
  else
    UpCase:=h;
  end;
end;

function LowCase(h: char): char;
begin
  Case h of
    'A'..'Z': LowCase:=chr(ord(h)+(ord('z')-ord('Z')));
    ''..'': LowCase:=chr(ord(h)+(ord('')-ord('')));
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';    '': LowCase:='';
    '': LowCase:='';
  else
    LowCase:=h;
  end;
end; }

Function PCharToStr(P:PChar):AnsiString;
begin
  PCharToStr:=Format('%P', [p]);
end;

END.
