{
    This file is part of the ChebLib library,
    Copyright (c) 2004 by Anton Rzheshevski (chebmaster@mail.ru),
      it contains basic OpenGL handling routines.

    see the the file COPYING_CL.txt included in this distribution,
    for details about the copyright.

    You should have received a copy of the GNU Library General Public
    License along with this source code; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 **********************************************************************}

{$MACRO ON}
{$MODE Delphi}
{$IFDEF Win32}
  {$DEFINE extdecl := stdcall}
{$ELSE}
  {$DEFINE extdecl := cdecl}
  {$LINKLIB c}
{$ENDIF}

unit cl_gl_core;

interface

uses
  SysUtils
  {$ifdef win32}
  ,Windows
  {$else}
  ,dllfuncs, dl, x, xlib, xutil
  {$endif}
  ;

{$include cl_gl_header.inc}  //*****  OpenGL HEADER ITSELF  *******

Procedure InitOpenGL(GLLibName, GLULibName: string);
Procedure CloseOpenGL;


implementation

{$ifdef cge}uses cge;{$endif}

var
  LibGL, LibGLU: {$IFDEF Win32} THandle {$ELSE} Pointer {$ENDIF} ;


function GetGLProcAddress(ProcName: String): Pointer;
begin
{$IFDEF Win32}
   Result:=GetProcAddress(LibGL, PChar(ProcName));
{$ELSE}
   Result:=dlsym(LibGL, PChar(ProcName));
{$ENDIF}
end;

function GetGLUProcAddress(ProcName: String): Pointer;
begin
{$IFDEF Win32}
   Result:=GetProcAddress(LibGLU, PChar(ProcName));
{$ELSE}
   Result:=dlsym(LibGLU, PChar(ProcName));
{$ENDIF}
end;

function GetGLEXTProcAddress(ProcName: String): Pointer;
begin
{$IFDEF Win32}
   Result:=wglGetProcAddress(PChar(ProcName));
{$ELSE}
   Result:=dlsym(LibGL, PChar(ProcName));
{$ENDIF}
end;

{$include cl_gl_loadprocs.inc} //******  INIT IMPLEMENTATION  ******

Procedure CloseOpenGL;
begin
  ClearProcAddresses;
 {$IFDEF Win32}
  If LibGL <> 0 then FreeLibrary(LibGl);
  If LibGLU <> 0 then FreeLibrary(LibGLU);
 {$ELSE}
  If Assigned(LibGL) then dlClose(LibGl);
  If Assigned(LibGLU) then dlClose(LibGLU);
 {$ENDIF}
end;

Procedure InitOpenGL(GLLibName, GLULibName: string);
begin
  CloseOpenGL;
 {$IFDEF Win32}
  LibGL:=LoadLibrary(PChar(GLLibName));
  if LibGL = 0 then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLLibName]);
    {$else}raise Exception.Create('OpenGL library ' + GLLibName + ' not found!');{$endif}
  LibGLU:=LoadLibrary(PChar(GLULibName));
  if LibGLU = 0 then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLULibName]);
    {$else}raise Exception.Create('OpenGL library ' + GLLibName + ' not found!');{$endif}
 {$ELSE}
  LibGL := dlopen(PChar(GLLibName), RTLD_NOW);
  If not Assigned(LibGL) then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLLibName]);
    {$else}raise Exception.Create('OpenGL library ' + GLLibName + ' not found!');{$endif}
  LibGLU := dlopen(PChar(GLULibName), RTLD_NOW);
  If not Assigned(LibGLU) then
    {$ifdef cge}Die(MI_ERROR_OPENGLDLLNOTFOUND, [GLULibName]);
    {$else}raise Exception.Create('OpenGL library ' + GLLibName + ' not found!');{$endif}
 {$ENDIF}
  InitProcAddresses;
end;

initialization

 //Disable FPU exceptions (it will ignore divisions by zero and such)
 {$ifdef win32}
  Set8087CW($133F);
  LibGL:=0;
  LibGLU:=0;
 {$else}
  LibGL:=nil;
  LibGLU:=nil;
 {$endif}

finalization
  CloseOpenGL;
  // we don't need to reset the FPU control word as the previous set call is process specific

end.