
{$mode delphi}
{$macro on}

 unit _cl_winman_demo_main;

 interface

 uses SysUtils
      {$ifdef unix} , x, xlib, xutil
      {$else}, Windows
      {$endif}, Classes, cl_strings, cl_gl_core;

 {$include cl_winman_h.inc}

 Type
   TMyWindow = class (TCLWindow)
     r, g, b, ar, ag ,ab, aa, s: glFloat;
   public
    procedure OnGetFocus; OVERRIDE;
    procedure OnLoseFocus; OVERRIDE;
    procedure OnMouseMove; OVERRIDE;
    procedure OnPress(scancode: integer); OVERRIDE;
    procedure OnRelease(scancode: integer); OVERRIDE;
    procedure OnCreate; OVERRIDE;
    procedure OnDestroy; OVERRIDE;
    procedure OnIdle; OVERRIDE;
    procedure OnResize; OVERRIDE;
    procedure OnType(input: WideChar); OVERRIDE;
   end;



 implementation

 //Required by cl_winman:
 const
   Yes = true;
   No = false;
   WindowWidth = 500;
   WindowHeight = 300;
   AppNick = 'ChebLib Window Manager demo';

 procedure VerboseLog(s: AnsiString);
 begin
   WriteLn(s);
 end;

 procedure Die(s: AnsiString);
 begin
   raise Exception.Create(s);
 end;

 {$ifdef unix}
   {$LinkLib Xext}
   {$Linklib Xxf86vm}
   {$define Linked_with_xf86vm}
 {$endif}


 {$include cl_winman.inc}


    procedure TMyWindow.OnGetFocus;
    begin
      if VidModes16bit then r:=0.3 else r:=0.15;
      g:=0.25;
      if VidModes16bit then b:=0 else b:=0.5;
      glEnable(GL_ALPHA_TEST);
      glEnable(GL_BLEND);
      glAlphaFunc(GL_GREATER, 0);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      glDisable(GL_TEXTURE_2D);
      glDisable(GL_CULL_FACE);
      glDisable(GL_DEPTH_TEST);
    end;

    procedure TMyWindow.OnLoseFocus;
    begin
      r:=1;
      g:=0;
      b:=0;
    end;

    procedure TMyWindow.OnMouseMove;
    begin
      s:=5;
    end;

    const
      KeyEsc = 1;
      KeyLAlt = 56;
      KeyRAlt = 0;
      KeyEnter = 28;
      KeySpace = 57;

    procedure TMyWindow.OnPress(scancode: integer);
    begin
      case Scancode of
        MouseWheelUp: aa:=aa + 0.1;
        MouseWheelDown: aa:=aa - 0.1;
        -3: begin ar:=1; ag:=0; ab:=0 end;
        -2: begin ar:=0; ag:=1; ab:=0 end;
        -1: begin ar:=0; ag:=0; ab:=1 end;
        KeyEsc: ExitRequested:=True;
        KeyEnter: begin
           {if Pressed[KeyLAlt] or Pressed[KeyRAlt] then} begin
             if InFullScreenMode then SwitchToWindowedMode
                                 else SwitchToFullscreenMode(640, 480);
           end;
        end;
        KeySpace: begin
          VidModes16bit:= not VidModes16bit;
          if VidModes16bit then r:=0.3 else r:=0.15;
          if VidModes16bit then b:=0 else b:=0.5;
          if InFullScreenMode then SwitchToFullscreenMode(640, 480); //immediately change bitdepth
          {TextInput:= not TextInput;
          if TextInput then r:=0.3 else r:=0.15;
          if TextInput then b:=0 else b:=0.5;}
        end;
      else
        g:=g + 0.2;
      end;
    end;

    procedure TMyWindow.OnRelease(scancode: integer);
    begin
      if not (scancode in [-5..-1, KeyEsc, KeyEnter, KeySpace]) then g:=g - 0.2;
    end;

    procedure TMyWindow.OnCreate;
    begin
      ar:=1;
      ag:=1;
      ab:=1;
      aa:=0.7;
      s:=10;
    end;

    procedure TMyWindow.OnDestroy;
    begin

    end;

    procedure TMyWindow.OnIdle;
    begin
      if not WindowVisible then Exit;
      if aa > 1 then aa:=1;
      if aa < 0 then aa:=0;
      s:=s + 0.01 * (155 - s);
      if s > 155 then s:=155;
      glViewport(0, 0, DisplayWidth, DisplayHeight);
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      gluOrtho2d(0, DisplayWidth, 0, DisplayHeight);
      //glClearColor(r, g, b, 0);
      //glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
      glBegin(GL_QUADS);
        glNormal3f( 0.0, 0.0, 1.0);
        glColor3f(r, g, b);
        glVertex2f(0, 0);
        glVertex2f(0, DisplayHeight);
        glVertex2f(DisplayWidth, DisplayHeight);
        glVertex2f(DisplayWidth, 0);
      glEnd;
      glBegin(GL_TRIANGLES);
        glNormal3f( 0.0, 0.0, 1.0);
        glColor4f(ar, ag, ab , aa);
        glVertex2f(MouseX, DisplayHeight - MouseY);
        glColor4f(ar, ag, ab , 0);
        glVertex2f(MouseX - s, DisplayHeight - MouseY + s/2);
        glVertex2f(MouseX - s/2, DisplayHeight - MouseY + s);
      glEnd;

      Flip;
     {$ifdef unix}
       //delay(15);
     {$else}
       //Sleep(15);
     {$endif}
    end;

    procedure TMyWindow.OnResize;
    begin

    end;

    procedure TMyWindow.OnType(input: WideChar);
    var w: WideString;
    begin
      SetLength(w, 1);
      PWideChar(@w[1])^:=input;
      WriteLn(input)
    end;


 end.